/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.mixin;

import dev.anvilcraft.lite.AnvilCraftLite;
import dev.anvilcraft.lite.block.MagnetBlock;
import dev.anvilcraft.lite.init.block.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={AnvilBlock.class})
abstract class AnvilBlockMixin
extends FallingBlock {
    public AnvilBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.anvilcraftLite$isAttracts(level.getBlockState(pos.above())) || !FallingBlock.isFree((BlockState)level.getBlockState(pos.below())) || pos.getY() < level.getMinY()) {
            return;
        }
        FallingBlockEntity fallingBlockEntity = FallingBlockEntity.fall((Level)level, (BlockPos)pos, (BlockState)state);
        this.falling(fallingBlockEntity);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        this.anvilcraftLite$wasAttracted(state, level, pos);
        super.neighborChanged(state, level, pos, neighborBlock, orientation, movedByPiston);
    }

    @Unique
    private boolean anvilcraftLite$isAttracts(BlockState state) {
        return state.is(ModBlockTags.MAGNET) && (Boolean)state.getValue((Property)MagnetBlock.LIT) == false;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        BlockState state1 = level.getBlockState(pos.above());
        if (!this.anvilcraftLite$isAttracts(state1)) {
            this.anvilcraftLite$wasAttracted(state, level, pos);
        }
    }

    @Unique
    private void anvilcraftLite$wasAttracted(BlockState state, Level level, BlockPos anvil) {
        BlockPos magnet = anvil;
        BlockState aboveState = level.getBlockState(anvil.above());
        if (aboveState.is(ModBlockTags.MAGNET) || aboveState.getBlock() instanceof MagnetBlock) {
            return;
        }
        int distance = AnvilCraftLite.CONFIG.magnetAttractsDistance;
        for (int i = 0; i < distance; ++i) {
            BlockState state1 = level.getBlockState(magnet = magnet.above());
            if (!(state1.getBlock() instanceof MagnetBlock) || ((Boolean)state1.getValue((Property)MagnetBlock.LIT)).booleanValue()) {
                if (level.isEmptyBlock(magnet) || state1.getBlock() instanceof LiquidBlock) continue;
                return;
            }
            level.destroyBlock(magnet.below(), true);
            level.setBlockAndUpdate(magnet.below(), state);
            level.setBlockAndUpdate(anvil, Blocks.AIR.defaultBlockState());
            return;
        }
    }
}

