/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.recipe.anvil.wrap;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.anvilcraft.lib.recipe.InWorldRecipe;
import dev.anvilcraft.lib.recipe.component.BlockStatePredicate;
import dev.anvilcraft.lib.recipe.component.ChanceBlockState;
import dev.anvilcraft.lib.recipe.component.ChanceItemStack;
import dev.anvilcraft.lib.recipe.component.ItemIngredientPredicate;
import dev.anvilcraft.lib.recipe.outcome.IRecipeOutcome;
import dev.anvilcraft.lib.recipe.predicate.IRecipePredicate;
import dev.anvilcraft.lib.recipe.predicate.block.HasBlock;
import dev.anvilcraft.lib.recipe.predicate.block.HasBlockIngredient;
import dev.anvilcraft.lib.recipe.trigger.IRecipeTrigger;
import dev.anvilcraft.lite.init.reicpe.ModRecipeTriggers;
import dev.anvilcraft.lite.recipe.anvil.builder.AbstractRecipeBuilder;
import dev.anvilcraft.lite.recipe.component.HasCauldronSimple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractProcessRecipe<T extends InWorldRecipe>
extends InWorldRecipe {
    protected final Property property;

    public AbstractProcessRecipe(Property property) {
        super(property.getIcon(), (IRecipeTrigger)ModRecipeTriggers.ON_ANVIL_FALL_ON.get(), property.getConflictingPredicates(), property.getNonConflictingPredicates(), property.getOutcomes(), property.getPriority(), false);
        this.property = property;
    }

    public abstract RecipeSerializer<T> getSerializer();

    public abstract RecipeType<T> getType();

    public List<ItemIngredientPredicate> getInputItems() {
        return Objects.requireNonNullElseGet(this.property.getInputItems(), List::of);
    }

    public List<ChanceItemStack> getResultItems() {
        return Objects.requireNonNullElseGet(this.property.getResultItems(), List::of);
    }

    public List<BlockStatePredicate> getInputBlocks() {
        return Objects.requireNonNullElseGet(this.property.getInputBlocks(), List::of);
    }

    public BlockStatePredicate getFirstInputBlock() {
        return Objects.requireNonNullElseGet(this.getInputBlocks().getFirst(), () -> BlockStatePredicate.builder(null).of(new Block[]{Blocks.AIR}).build());
    }

    public List<ChanceBlockState> getResultBlocks() {
        return Objects.requireNonNullElseGet(this.property.getResultBlocks(), List::of);
    }

    public ChanceBlockState getFirstResultBlock() {
        return Objects.requireNonNullElseGet(this.getResultBlocks().getFirst(), () -> new ChanceBlockState(Blocks.AIR.defaultBlockState(), 1.0f));
    }

    public HasCauldronSimple getHasCauldron() {
        return this.property.getHasCauldron();
    }

    @Generated
    public Property getProperty() {
        return this.property;
    }

    public static class Property {
        private Vec3 itemInputOffset = Vec3.ZERO;
        private Vec3 itemInputRange = new Vec3(1.0, 1.0, 1.0);
        private List<ItemIngredientPredicate> inputItems = null;
        private Vec3 itemOutputOffset = Vec3.ZERO;
        private List<ChanceItemStack> resultItems = null;
        private Vec3i blockInputOffset = Vec3i.ZERO;
        private boolean consumeInputBlocks = false;
        private List<BlockStatePredicate> inputBlocks = null;
        private Vec3i blockOutputOffset = Vec3i.ZERO;
        private List<ChanceBlockState> resultBlocks = null;
        private Vec3i cauldronOffset = Vec3i.ZERO;
        private HasCauldronSimple hasCauldron = null;
        private Integer priority = null;

        public Property setItemInputOffset(Vec3 itemInputOffset) {
            this.itemInputOffset = itemInputOffset;
            return this;
        }

        public Property setItemInputRange(Vec3 itemInputRange) {
            this.itemInputRange = itemInputRange;
            return this;
        }

        public Property setInputItems(List<ItemIngredientPredicate> inputItems) {
            this.inputItems = inputItems;
            return this;
        }

        public Property setInputItems(ItemIngredientPredicate ... inputItems) {
            return this.setInputItems(Arrays.asList(inputItems));
        }

        public Property setItemOutputOffset(Vec3 itemOutputOffset) {
            this.itemOutputOffset = itemOutputOffset;
            return this;
        }

        public Property setResultItems(List<ChanceItemStack> resultItems) {
            this.resultItems = resultItems;
            return this;
        }

        public Property setResultItems(ChanceItemStack ... resultItems) {
            return this.setResultItems(Arrays.asList(resultItems));
        }

        public Property setBlockInputOffset(Vec3i blockInputOffset) {
            this.blockInputOffset = blockInputOffset;
            return this;
        }

        public Property setInputBlocks(List<BlockStatePredicate> inputBlocks) {
            this.inputBlocks = inputBlocks;
            return this;
        }

        public Property setConsumeInputBlocks(boolean consumeInputBlocks) {
            this.consumeInputBlocks = consumeInputBlocks;
            return this;
        }

        public Property setInputBlocks(BlockStatePredicate ... inputBlocks) {
            return this.setInputBlocks(Arrays.asList(inputBlocks));
        }

        public Property setBlockOutputOffset(Vec3i blockOutputOffset) {
            this.blockOutputOffset = blockOutputOffset;
            return this;
        }

        public Property setResultBlocks(List<ChanceBlockState> resultBlocks) {
            this.resultBlocks = resultBlocks;
            return this;
        }

        public Property setResultBlocks(ChanceBlockState ... resultBlocks) {
            return this.setResultBlocks(Arrays.asList(resultBlocks));
        }

        public Property setCauldronOffset(Vec3i cauldronOffset) {
            this.cauldronOffset = cauldronOffset;
            return this;
        }

        public Property setHasCauldron(HasCauldronSimple hasCauldron) {
            this.hasCauldron = hasCauldron;
            return this;
        }

        public Property setPriority(int priority) {
            this.priority = priority;
            return this;
        }

        private ItemStack getIcon() {
            Item item;
            ItemStack icon = null;
            if (this.resultItems != null && !this.resultItems.isEmpty()) {
                icon = this.resultItems.getFirst().stack();
            }
            if (icon == null && this.resultBlocks != null && !this.resultBlocks.isEmpty() && (item = this.resultBlocks.getFirst().state().getBlock().asItem()) != Items.AIR) {
                icon = item.getDefaultInstance();
            }
            if (icon == null) {
                icon = Items.ANVIL.getDefaultInstance();
            }
            return icon;
        }

        private int getPriority() {
            if (this.priority != null) {
                return this.priority;
            }
            return (this.inputItems == null ? 0 : this.inputItems.size()) + (this.resultItems == null ? 0 : this.resultItems.size()) + (this.inputBlocks == null ? 0 : this.inputBlocks.size() * 100) + (this.resultBlocks == null ? 0 : this.resultBlocks.size()) + (this.hasCauldron != null ? 1 : 0);
        }

        private List<IRecipePredicate<?>> getNonConflictingPredicates() {
            ArrayList predicates = new ArrayList();
            if (this.hasCauldron != null) {
                predicates.add(this.hasCauldron.toHasCauldron(this.getCauldronOffset()));
            }
            if (this.inputBlocks != null) {
                for (int i = 0; i < this.inputBlocks.size(); ++i) {
                    BlockStatePredicate block = this.inputBlocks.get(i);
                    Object hasBlock = this.consumeInputBlocks ? new HasBlockIngredient(this.getBlockInputOffset().subtract(0.0, (double)i, 0.0), block) : new HasBlock(this.getBlockInputOffset().subtract(0.0, (double)i, 0.0), block);
                    predicates.add((IRecipePredicate<?>)hasBlock);
                }
            }
            return predicates;
        }

        private List<IRecipePredicate<?>> getConflictingPredicates() {
            ArrayList predicates = new ArrayList();
            if (this.inputItems != null) {
                for (ItemIngredientPredicate ingredient : this.inputItems) {
                    predicates.add((IRecipePredicate<?>)ingredient.toHasItemIngredient(this.itemInputOffset, this.itemInputRange));
                }
            }
            return predicates;
        }

        private List<IRecipeOutcome<?>> getOutcomes() {
            ArrayList outcomes = new ArrayList();
            if (this.resultItems != null) {
                for (ChanceItemStack chanceItemStack : this.resultItems) {
                    outcomes.add((IRecipeOutcome<?>)chanceItemStack.toSpawnItem(this.itemOutputOffset));
                }
            }
            if (this.resultBlocks != null) {
                for (int i = 0; i < this.resultBlocks.size(); ++i) {
                    ChanceBlockState chanceBlockState = this.resultBlocks.get(i);
                    outcomes.add((IRecipeOutcome<?>)chanceBlockState.toSetBlock(this.getBlockOutputOffset().subtract(0.0, (double)i, 0.0)));
                }
            }
            return outcomes;
        }

        public Vec3 getBlockOutputOffset() {
            return new Vec3((double)this.blockOutputOffset.getX(), (double)this.blockOutputOffset.getY(), (double)this.blockOutputOffset.getZ());
        }

        public Vec3 getBlockInputOffset() {
            return new Vec3((double)this.blockInputOffset.getX(), (double)this.blockInputOffset.getY(), (double)this.blockInputOffset.getZ());
        }

        public Vec3 getCauldronOffset() {
            return new Vec3((double)this.cauldronOffset.getX(), (double)this.cauldronOffset.getY(), (double)this.cauldronOffset.getZ());
        }

        @Generated
        public Vec3 getItemInputOffset() {
            return this.itemInputOffset;
        }

        @Generated
        public Vec3 getItemInputRange() {
            return this.itemInputRange;
        }

        @Generated
        public List<ItemIngredientPredicate> getInputItems() {
            return this.inputItems;
        }

        @Generated
        public Vec3 getItemOutputOffset() {
            return this.itemOutputOffset;
        }

        @Generated
        public List<ChanceItemStack> getResultItems() {
            return this.resultItems;
        }

        @Generated
        public boolean isConsumeInputBlocks() {
            return this.consumeInputBlocks;
        }

        @Generated
        public List<BlockStatePredicate> getInputBlocks() {
            return this.inputBlocks;
        }

        @Generated
        public List<ChanceBlockState> getResultBlocks() {
            return this.resultBlocks;
        }

        @Generated
        public HasCauldronSimple getHasCauldron() {
            return this.hasCauldron;
        }
    }

    public static abstract class SimpleAbstractBuilder<T extends AbstractProcessRecipe<T>, B extends SimpleAbstractBuilder<T, B>>
    extends AbstractBuilder<T, B> {
        protected SimpleAbstractBuilder(HolderGetter<Item> getter) {
            super(getter);
        }

        protected abstract T of(List<ItemIngredientPredicate> var1, List<ChanceItemStack> var2);

        @Override
        public T buildRecipe() {
            return this.of(this.itemIngredients, this.results);
        }

        @Override
        public void validate(ResourceLocation pId) {
            if (this.itemIngredients.isEmpty()) {
                throw new IllegalArgumentException("Recipe ingredients must not be empty, RecipeId: " + String.valueOf(pId));
            }
            if (this.results.isEmpty()) {
                throw new IllegalArgumentException("Recipe result must not be empty, RecipeId: " + String.valueOf(pId));
            }
        }
    }

    public static abstract class AbstractBuilder<T extends AbstractProcessRecipe<T>, B extends AbstractBuilder<T, B>>
    extends AbstractRecipeBuilder<T> {
        private final HolderGetter<Item> getter;
        protected final List<ItemIngredientPredicate> itemIngredients = new ArrayList<ItemIngredientPredicate>();
        protected final List<ChanceItemStack> results = new ArrayList<ChanceItemStack>();

        protected AbstractBuilder(HolderGetter<Item> getter) {
            this.getter = getter;
        }

        protected abstract B getThis();

        public B requires(ItemIngredientPredicate ingredient) {
            this.itemIngredients.add(ingredient);
            return this.getThis();
        }

        public B requires(TagKey<Item> ingredient, int count) {
            this.itemIngredients.add(ItemIngredientPredicate.Builder.item(this.getter).of(ingredient).withCount(count).build());
            return this.getThis();
        }

        public B requires(TagKey<Item> ingredient) {
            return this.requires(ingredient, 1);
        }

        public B requires(ItemStack ingredient) {
            this.itemIngredients.add(ItemIngredientPredicate.Builder.item(this.getter).of(ingredient).build());
            return this.getThis();
        }

        public B requires(ItemLike ingredient, int count) {
            return this.requires(ItemIngredientPredicate.Builder.item(this.getter).of(new ItemLike[]{ingredient}).withCount(count).build());
        }

        public B requires(ItemLike ingredient) {
            return this.requires(ingredient, 1);
        }

        public B result(ItemStack result, NumberProvider count) {
            this.results.add(ChanceItemStack.of((ItemStack)result, (NumberProvider)count));
            return this.getThis();
        }

        public B result(ItemStack result, float chance) {
            return this.result(result, (NumberProvider)BinomialDistributionGenerator.binomial((int)result.getCount(), (float)chance));
        }

        public B result(ItemStack result) {
            return this.result(result, (NumberProvider)ConstantValue.exactly((float)result.getCount()));
        }

        public B result(ItemLike result, NumberProvider count) {
            this.results.add(ChanceItemStack.of((ItemLike)result, (NumberProvider)count));
            return this.getThis();
        }

        public B result(ItemLike result, int count, float chance) {
            return this.result(result, (NumberProvider)BinomialDistributionGenerator.binomial((int)count, (float)chance));
        }

        public B result(ItemLike result, int count) {
            return this.result(result, (NumberProvider)ConstantValue.exactly((float)count));
        }

        public B result(ItemLike result, float chance) {
            return this.result(result, 1, chance);
        }

        public B result(ItemLike result) {
            return this.result(result, (NumberProvider)ConstantValue.exactly((float)1.0f));
        }

        @Override
        public Item getResult() {
            return this.results.isEmpty() ? Items.ANVIL : this.results.getFirst().getItem();
        }
    }

    public static abstract class AbstractSerializer<T extends AbstractProcessRecipe<T>>
    implements RecipeSerializer<T> {
        protected final MapCodec<T> codec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemIngredientPredicate.CODEC.codec().listOf().optionalFieldOf("ingredients", List.of()).forGetter(AbstractProcessRecipe::getInputItems), (App)ChanceItemStack.CODEC.listOf().optionalFieldOf("results", List.of()).forGetter(AbstractProcessRecipe::getResultItems)).apply((Applicative)instance, this::of));
        protected final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec = StreamCodec.composite((StreamCodec)ItemIngredientPredicate.STREAM_CODEC.apply(ByteBufCodecs.list()), AbstractProcessRecipe::getInputItems, (StreamCodec)ChanceItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()), AbstractProcessRecipe::getResultItems, this::of);

        protected abstract T of(List<ItemIngredientPredicate> var1, List<ChanceItemStack> var2);

        public MapCodec<T> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }
    }
}

