/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.recipe.anvil.wrap;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.anvilcraft.lib.recipe.component.BlockStatePredicate;
import dev.anvilcraft.lib.recipe.component.ChanceBlockState;
import dev.anvilcraft.lite.init.reicpe.ModRecipeTypes;
import dev.anvilcraft.lite.recipe.anvil.builder.AbstractRecipeBuilder;
import dev.anvilcraft.lite.recipe.anvil.util.WrapUtils;
import dev.anvilcraft.lite.recipe.anvil.wrap.AbstractProcessRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;

public class BlockSmearRecipe
extends AbstractProcessRecipe<BlockSmearRecipe> {
    public BlockSmearRecipe(List<BlockStatePredicate> inputs, ChanceBlockState result) {
        super(new AbstractProcessRecipe.Property().setBlockInputOffset(new Vec3i(0, -1, 0)).setInputBlocks(inputs).setBlockOutputOffset(new Vec3i(0, -2, 0)).setResultBlocks(result));
    }

    @Override
    public RecipeSerializer<BlockSmearRecipe> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.BLOCK_SMEAR_SERIALIZER.get();
    }

    @Override
    public RecipeType<BlockSmearRecipe> getType() {
        return (RecipeType)ModRecipeTypes.BLOCK_SMEAR_TYPE.get();
    }

    public static Builder builder(HolderGetter<Block> getter) {
        return new Builder(getter);
    }

    public static class Builder
    extends AbstractRecipeBuilder<BlockSmearRecipe> {
        private final HolderGetter<Block> getter;
        private final List<BlockStatePredicate> inputs = new ArrayList<BlockStatePredicate>();
        private ChanceBlockState result = null;

        public Builder(HolderGetter<Block> getter) {
            this.getter = getter;
        }

        public Builder input(BlockStatePredicate input) {
            this.inputs.add(input);
            return this;
        }

        public Builder input(TagKey<Block> input) {
            this.inputs.add(BlockStatePredicate.builder(this.getter).of(input).build());
            return this;
        }

        public Builder input(Block input) {
            this.inputs.add(BlockStatePredicate.builder(this.getter).of(new Block[]{input}).build());
            return this;
        }

        public Builder result(ChanceBlockState result) {
            this.result = result;
            return this;
        }

        public Builder result(Block result) {
            this.result = new ChanceBlockState(result.defaultBlockState(), 1.0f);
            return this;
        }

        @Override
        public BlockSmearRecipe buildRecipe() {
            return new BlockSmearRecipe(this.inputs, this.result);
        }

        @Override
        public void validate(ResourceLocation pId) {
            if (this.inputs.isEmpty()) {
                throw new IllegalArgumentException("Recipe inputs must not be empty, RecipeId: " + String.valueOf(pId));
            }
            if (this.result == null) {
                throw new IllegalArgumentException("Recipe result must not be null, RecipeId: " + String.valueOf(pId));
            }
        }

        @Override
        public String getType() {
            return "block_smear";
        }

        @Override
        public Item getResult() {
            return WrapUtils.getItem(this.result);
        }
    }

    public static class Serializer
    implements RecipeSerializer<BlockSmearRecipe> {
        private static final MapCodec<BlockSmearRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockStatePredicate.CODEC.listOf().fieldOf("inputs").forGetter(AbstractProcessRecipe::getInputBlocks), (App)ChanceBlockState.CODEC.codec().fieldOf("result").forGetter(AbstractProcessRecipe::getFirstResultBlock)).apply((Applicative)instance, BlockSmearRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, BlockSmearRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockStatePredicate.STREAM_CODEC.apply(ByteBufCodecs.list()), AbstractProcessRecipe::getInputBlocks, (StreamCodec)ChanceBlockState.STREAM_CODEC, AbstractProcessRecipe::getFirstResultBlock, BlockSmearRecipe::new);

        public MapCodec<BlockSmearRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BlockSmearRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

