/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.lighting.LayerLightSectionStorage;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class LevelLike
implements BlockAndTintGetter {
    private final Map<BlockPos, BlockState> blocks = new HashMap<BlockPos, BlockState>();
    private final Map<BlockPos, BlockEntity> blockEntities = new HashMap<BlockPos, BlockEntity>();
    private final ClientLevel parent;
    private final LevelLightEngine fullLight = new FullLightLevelLightEngine();
    private int currentVisibleLayer = 0;
    private boolean allLayersVisible = true;

    public LevelLike(ClientLevel parent) {
        this.parent = parent;
    }

    public int horizontalSize() {
        Set<BlockPos> keys = this.blocks.keySet();
        return Math.max(keys.stream().map(Vec3i::getX).max(Integer::compare).map(it -> it + 1).orElse(0), keys.stream().map(Vec3i::getZ).max(Integer::compare).map(it -> it + 1).orElse(0));
    }

    public int verticalSize() {
        Set<BlockPos> keys = this.blocks.keySet();
        return keys.stream().map(Vec3i::getY).max(Integer::compare).map(it -> it + 1).orElse(0);
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos blockPos) {
        return this.blockEntities.get(blockPos);
    }

    public void setBlockState(BlockPos pos, BlockState state) {
        this.blockEntities.remove(pos);
        this.blocks.put(pos, state);
        Block block = state.getBlock();
        if (block instanceof EntityBlock) {
            EntityBlock entityBlock = (EntityBlock)block;
            BlockEntity blockEntity = entityBlock.newBlockEntity(pos, state);
            if (blockEntity == null) {
                return;
            }
            if (Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(blockEntity) == null) {
                return;
            }
            blockEntity.setLevel((Level)this.parent);
            blockEntity.setBlockState(state);
            this.blockEntities.put(pos, blockEntity);
        }
    }

    public BlockState getBlockState(BlockPos pos) {
        if (!this.allLayersVisible && pos.getY() != this.currentVisibleLayer) {
            return Blocks.AIR.defaultBlockState();
        }
        return this.blocks.getOrDefault(pos, Blocks.AIR.defaultBlockState());
    }

    public FluidState getFluidState(BlockPos blockPos) {
        return this.getBlockState(blockPos).getFluidState();
    }

    public float getShade(Direction direction, boolean b) {
        boolean flag = this.parent.effects().constantAmbientLight();
        if (!b) {
            return flag ? 0.9f : 1.0f;
        }
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> {
                if (flag) {
                    yield 0.9f;
                }
                yield 0.5f;
            }
            case Direction.UP -> {
                if (flag) {
                    yield 0.9f;
                }
                yield 1.0f;
            }
            case Direction.NORTH, Direction.SOUTH -> 0.8f;
            case Direction.WEST, Direction.EAST -> 0.6f;
        };
    }

    public LevelLightEngine getLightEngine() {
        return this.fullLight;
    }

    public int getBlockTint(BlockPos blockPos, ColorResolver colorResolver) {
        Holder.Reference plains = this.parent.registryAccess().lookupOrThrow(Registries.BIOME).getOrThrow(Biomes.PLAINS);
        return colorResolver.getColor((Biome)plains.value(), (double)blockPos.getX(), (double)blockPos.getZ());
    }

    public int getHeight() {
        return 256;
    }

    public int getMinY() {
        return 0;
    }

    public int getBrightness(LightLayer type, BlockPos pos) {
        return 14;
    }

    public int getRawBrightness(BlockPos pos, int amount) {
        return 14 - amount;
    }

    public void nextLayer() {
        this.currentVisibleLayer = this.currentVisibleLayer >= this.verticalSize() - 1 ? 0 : ++this.currentVisibleLayer;
    }

    public void previousLayer() {
        this.currentVisibleLayer = this.currentVisibleLayer <= 0 ? this.verticalSize() - 1 : --this.currentVisibleLayer;
    }

    @Generated
    public int getCurrentVisibleLayer() {
        return this.currentVisibleLayer;
    }

    @Generated
    public void setAllLayersVisible(boolean allLayersVisible) {
        this.allLayersVisible = allLayersVisible;
    }

    @Generated
    public boolean isAllLayersVisible() {
        return this.allLayersVisible;
    }

    public static class FullLightLevelLightEngine
    extends LevelLightEngine {
        public void checkBlock(BlockPos pos) {
        }

        public boolean hasLightWork() {
            return false;
        }

        public int runLightUpdates() {
            return 15;
        }

        public void updateSectionStatus(SectionPos pos, boolean isEmpty) {
        }

        public void updateSectionStatus(BlockPos pos, boolean isQueueEmpty) {
        }

        public void setLightEnabled(ChunkPos chunkPos, boolean b) {
        }

        public void propagateLightSources(ChunkPos pos) {
        }

        public String getDebugData(LightLayer lightLayer, SectionPos sectionPos) {
            return "n/a";
        }

        public LayerLightSectionStorage.SectionType getDebugSectionType(LightLayer lightLayer, SectionPos sectionPos) {
            return LayerLightSectionStorage.SectionType.EMPTY;
        }

        public void queueSectionData(LightLayer lightLayer, SectionPos sectionPos, @Nullable DataLayer dataLayer) {
        }

        public void retainData(ChunkPos pos, boolean retain) {
        }

        public int getRawBrightness(BlockPos blockPos, int amount) {
            return 15;
        }

        public boolean lightOnInColumn(long columnPos) {
            return true;
        }
    }

    public static class AirLevelLike
    extends LevelLike {
        public AirLevelLike(ClientLevel parent) {
            super(parent);
        }

        @Override
        public BlockState getBlockState(BlockPos pos) {
            return Blocks.AIR.defaultBlockState();
        }

        @Override
        public FluidState getFluidState(BlockPos blockPos) {
            return Fluids.EMPTY.defaultFluidState();
        }
    }
}

