/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.integration.jei;

import dev.anvilcraft.lite.AnvilCraftLite;
import dev.anvilcraft.lite.integration.jei.category.anvil.BlockCompressCategory;
import dev.anvilcraft.lite.integration.jei.category.anvil.BlockCrushCategory;
import dev.anvilcraft.lite.integration.jei.category.anvil.BlockSmearCategory;
import dev.anvilcraft.lite.integration.jei.category.anvil.BoilingCategory;
import dev.anvilcraft.lite.integration.jei.category.anvil.BulgingCategory;
import dev.anvilcraft.lite.integration.jei.category.anvil.CookingCategory;
import dev.anvilcraft.lite.integration.jei.category.anvil.ItemCompressCategory;
import dev.anvilcraft.lite.integration.jei.category.anvil.ItemCrushCategory;
import dev.anvilcraft.lite.integration.jei.category.anvil.ItemInjectCategory;
import dev.anvilcraft.lite.integration.jei.category.anvil.MeshRecipeCategory;
import dev.anvilcraft.lite.integration.jei.category.anvil.SqueezingCategory;
import dev.anvilcraft.lite.integration.jei.category.anvil.StampingCategory;
import dev.anvilcraft.lite.integration.jei.category.anvil.SuperHeatingCategory;
import dev.anvilcraft.lite.integration.jei.category.anvil.UnpackCategory;
import dev.anvilcraft.lite.integration.jei.recipe.MeshRecipeGroup;
import dev.anvilcraft.lite.recipe.anvil.wrap.BlockCompressRecipe;
import dev.anvilcraft.lite.recipe.anvil.wrap.BlockCrushRecipe;
import dev.anvilcraft.lite.recipe.anvil.wrap.BlockSmearRecipe;
import dev.anvilcraft.lite.recipe.anvil.wrap.BoilingRecipe;
import dev.anvilcraft.lite.recipe.anvil.wrap.BulgingRecipe;
import dev.anvilcraft.lite.recipe.anvil.wrap.CookingRecipe;
import dev.anvilcraft.lite.recipe.anvil.wrap.ItemCompressRecipe;
import dev.anvilcraft.lite.recipe.anvil.wrap.ItemCrushRecipe;
import dev.anvilcraft.lite.recipe.anvil.wrap.ItemInjectRecipe;
import dev.anvilcraft.lite.recipe.anvil.wrap.SqueezingRecipe;
import dev.anvilcraft.lite.recipe.anvil.wrap.StampingRecipe;
import dev.anvilcraft.lite.recipe.anvil.wrap.SuperHeatingRecipe;
import dev.anvilcraft.lite.recipe.anvil.wrap.UnpackRecipe;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeHolderType;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeMap;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@JeiPlugin
public class AnvilCraftJeiPlugin
implements IModPlugin {
    public static final ThreadLocal<Rect2i> AREA_WHEN_DRAW = new ThreadLocal();
    public static RecipeMap recipes = RecipeMap.EMPTY;
    public static final IRecipeType<MeshRecipeGroup> MESH = AnvilCraftJeiPlugin.createIRecipeType("mesh", MeshRecipeGroup.class);
    public static final IRecipeType<RecipeHolder<BlockCompressRecipe>> BLOCK_COMPRESS = AnvilCraftJeiPlugin.createRecipeHolderType("block_compress");
    public static final IRecipeType<RecipeHolder<BlockCrushRecipe>> BLOCK_CRUSH = AnvilCraftJeiPlugin.createRecipeHolderType("block_crush");
    public static final IRecipeType<RecipeHolder<BlockSmearRecipe>> BLOCK_SMEAR = AnvilCraftJeiPlugin.createRecipeHolderType("block_smear");
    public static final IRecipeType<RecipeHolder<ItemCrushRecipe>> ITEM_CRUSH = AnvilCraftJeiPlugin.createRecipeHolderType("item_crush");
    public static final IRecipeType<RecipeHolder<ItemInjectRecipe>> ITEM_INJECT = AnvilCraftJeiPlugin.createRecipeHolderType("item_inject");
    public static final IRecipeType<RecipeHolder<ItemCompressRecipe>> ITEM_COMPRESS = AnvilCraftJeiPlugin.createRecipeHolderType("item_compress");
    public static final IRecipeType<RecipeHolder<UnpackRecipe>> UNPACK = AnvilCraftJeiPlugin.createRecipeHolderType("unpack");
    public static final IRecipeType<RecipeHolder<CookingRecipe>> COOKING = AnvilCraftJeiPlugin.createRecipeHolderType("cooking");
    public static final IRecipeType<RecipeHolder<BoilingRecipe>> BOILING = AnvilCraftJeiPlugin.createRecipeHolderType("boiling");
    public static final IRecipeType<RecipeHolder<StampingRecipe>> STAMPING = AnvilCraftJeiPlugin.createRecipeHolderType("stamping");
    public static final IRecipeType<RecipeHolder<SuperHeatingRecipe>> SUPER_HEATING = AnvilCraftJeiPlugin.createRecipeHolderType("super_heating");
    public static final IRecipeType<RecipeHolder<SqueezingRecipe>> SQUEEZING = AnvilCraftJeiPlugin.createRecipeHolderType("squeezing");
    public static final IRecipeType<RecipeHolder<BulgingRecipe>> BULGING = AnvilCraftJeiPlugin.createRecipeHolderType("bulging");

    public ResourceLocation getPluginUid() {
        return AnvilCraftLite.of("jei_plugin");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        MeshRecipeCategory.registerRecipes(registration);
        BlockCompressCategory.registerRecipes(registration);
        BlockCrushCategory.registerRecipes(registration);
        BlockSmearCategory.registerRecipes(registration);
        ItemCrushCategory.registerRecipes(registration);
        SqueezingCategory.registerRecipes(registration);
        ItemInjectCategory.registerRecipes(registration);
        ItemCompressCategory.registerRecipes(registration);
        UnpackCategory.registerRecipes(registration);
        CookingCategory.registerRecipes(registration);
        BoilingCategory.registerRecipes(registration);
        StampingCategory.registerRecipes(registration);
        SuperHeatingCategory.registerRecipes(registration);
        BulgingCategory.registerRecipes(registration);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        MeshRecipeCategory.registerCraftingStations(registration);
        BlockCompressCategory.registerCraftingStations(registration);
        BlockCrushCategory.registerCraftingStations(registration);
        BlockSmearCategory.registerCraftingStations(registration);
        ItemCrushCategory.registerCraftingStations(registration);
        SqueezingCategory.registerCraftingStations(registration);
        ItemInjectCategory.registerCraftingStations(registration);
        ItemCompressCategory.registerCraftingStations(registration);
        UnpackCategory.registerCraftingStations(registration);
        CookingCategory.registerCraftingStations(registration);
        BoilingCategory.registerCraftingStations(registration);
        StampingCategory.registerCraftingStations(registration);
        SuperHeatingCategory.registerCraftingStations(registration);
        BulgingCategory.registerCraftingStations(registration);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new MeshRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BlockCompressCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BlockCrushCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BlockSmearCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ItemCrushCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new SqueezingCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ItemInjectCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ItemCompressCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new UnpackCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CookingCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BoilingCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new StampingCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new SuperHeatingCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BulgingCategory(guiHelper)});
    }

    public static <T> IRecipeType<T> createIRecipeType(String name, Class<T> clazz) {
        return IRecipeType.create((ResourceLocation)AnvilCraftLite.of(name), clazz);
    }

    public static <R extends Recipe<?>> IRecipeType<RecipeHolder<R>> createRecipeHolderType(String name) {
        return IRecipeHolderType.create((ResourceLocation)AnvilCraftLite.of(name));
    }
}

