/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.integration.jei.category.anvil;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.anvilcraft.lite.init.reicpe.ModRecipeTypes;
import dev.anvilcraft.lite.integration.jei.AnvilCraftJeiPlugin;
import dev.anvilcraft.lite.integration.jei.drawable.DrawableBlockStateIcon;
import dev.anvilcraft.lite.integration.jei.util.JeiRecipeUtil;
import dev.anvilcraft.lite.integration.jei.util.JeiRenderHelper;
import dev.anvilcraft.lite.integration.jei.util.JeiSlotUtil;
import dev.anvilcraft.lite.recipe.anvil.wrap.BulgingRecipe;
import dev.anvilcraft.lite.recipe.component.HasCauldronSimple;
import dev.anvilcraft.lite.util.CauldronUtil;
import dev.anvilcraft.lite.util.render.RenderHelper;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BulgingCategory
implements IRecipeCategory<RecipeHolder<BulgingRecipe>> {
    public static final int WIDTH = 162;
    public static final int HEIGHT = 64;
    private final IDrawable icon = new DrawableBlockStateIcon(Blocks.ANVIL.defaultBlockState(), CauldronUtil.fullState(Blocks.WATER_CAULDRON));
    private final IDrawable slotDefault;
    private final IDrawable slotProbability;
    private final Component title;
    private final ITickTimer timer;
    private final IDrawable arrowIn;
    private final IDrawable arrowOut;

    public BulgingCategory(IGuiHelper helper) {
        this.slotDefault = JeiRenderHelper.getSlotDefault(helper);
        this.slotProbability = JeiRenderHelper.getSlotProbability(helper);
        this.title = Component.translatable((String)"gui.anvilcraft.category.bulging");
        this.timer = helper.createTickTimer(30, 60, true);
        this.arrowIn = JeiRenderHelper.getArrowInput(helper);
        this.arrowOut = JeiRenderHelper.getArrowOutput(helper);
    }

    public IRecipeType<RecipeHolder<BulgingRecipe>> getRecipeType() {
        return AnvilCraftJeiPlugin.BULGING;
    }

    public Component getTitle() {
        return this.title;
    }

    public int getWidth() {
        return 162;
    }

    public int getHeight() {
        return 64;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<BulgingRecipe> recipeHolder, IFocusGroup focuses) {
        BulgingRecipe recipe = (BulgingRecipe)recipeHolder.value();
        JeiSlotUtil.addInputSlots(builder, recipe.getInputItems());
        if (!recipe.getResultItems().isEmpty()) {
            JeiSlotUtil.addOutputSlots(builder, recipe.getResultItems());
        }
    }

    public void draw(RecipeHolder<BulgingRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Rect2i area = AnvilCraftJeiPlugin.AREA_WHEN_DRAW.get();
        int left = area.getX() - 9;
        int top = area.getY() - 7;
        BulgingRecipe recipe = (BulgingRecipe)recipeHolder.value();
        float anvilYOffset = JeiRenderHelper.getAnvilAnimationOffset(this.timer);
        BlockState state = recipe.isFromWater() ? CauldronUtil.fullState(Blocks.WATER_CAULDRON) : (recipe.isProduceFluid() ? Blocks.CAULDRON.defaultBlockState() : recipe.getHasCauldron().getTransformCauldron().defaultBlockState());
        RenderHelper.renderSingleBlock(guiGraphics, state, left + 81, top + 40, 12.0f);
        RenderHelper.renderSingleBlock(guiGraphics, Blocks.ANVIL.defaultBlockState(), left + 81, (float)(top + 22) + anvilYOffset, 12.0f);
        this.arrowIn.draw(guiGraphics, 54, 30);
        this.arrowOut.draw(guiGraphics, 92, 29);
        JeiSlotUtil.drawInputSlots(guiGraphics, this.slotDefault, recipe.getInputItems().size());
        if (!recipe.getResultItems().isEmpty()) {
            if (JeiRecipeUtil.isChance(recipe.getResultItems())) {
                JeiSlotUtil.drawOutputSlots(guiGraphics, this.slotProbability, recipe.getResultItems().size());
            } else {
                JeiSlotUtil.drawOutputSlots(guiGraphics, this.slotDefault, recipe.getResultItems().size());
            }
            HasCauldronSimple hasCauldron = recipe.getHasCauldron();
            if (recipe.isConsumeFluid()) {
                PoseStack pose = new PoseStack();
                pose.pushPose();
                pose.scale(0.8f, 0.8f, 1.0f);
                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"gui.anvilcraft.category.bulging.consume_fluid", (Object[])new Object[]{hasCauldron.consume(), hasCauldron.getFluidCauldron().getName()}), 0, 70, -16777216, false);
                pose.popPose();
            } else if (recipe.isProduceFluid()) {
                PoseStack pose = new PoseStack();
                pose.pushPose();
                pose.scale(0.8f, 0.8f, 1.0f);
                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"gui.anvilcraft.category.bulging.produce_fluid", (Object[])new Object[]{-hasCauldron.consume(), hasCauldron.getTransformCauldron().getName()}), 0, 70, -16777216, false);
                pose.popPose();
            }
        } else {
            Block result = recipe.getHasCauldron().getTransformCauldron();
            state = recipe.isConsumeFluid() ? CauldronUtil.getStateFromContentAndLevel(result, CauldronUtil.maxLevel(result) - 1) : (recipe.isProduceFluid() ? CauldronUtil.getStateFromContentAndLevel(result, 1) : CauldronUtil.fullState(result));
            RenderHelper.renderSingleBlock(guiGraphics, state, left + 133, top + 30, 12.0f);
        }
    }

    public void getTooltip(ITooltipBuilder tooltip, RecipeHolder<BulgingRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        MutableComponent text;
        BulgingRecipe recipe = (BulgingRecipe)recipeHolder.value();
        if (mouseX >= 72.0 && mouseX <= 90.0 && mouseY >= 34.0 && mouseY <= 53.0) {
            Block material = recipe.getHasCauldron().getFluidCauldron();
            text = recipe.isFromWater() ? Blocks.WATER_CAULDRON.getName() : (recipe.isConsumeFluid() ? material.getName() : (recipe.isProduceFluid() ? Blocks.CAULDRON.getName() : material.getName()));
            tooltip.add((FormattedText)text);
        }
        if (mouseX >= 124.0 && mouseX <= 140.0 && mouseY >= 24.0 && mouseY <= 42.0) {
            Block result = recipe.getHasCauldron().getTransformCauldron();
            if (recipe.getResultItems().isEmpty()) {
                text = recipe.isConsumeFluid() ? (CauldronUtil.maxLevel(result) > 1 ? result.getName() : Blocks.CAULDRON.getName()) : result.getName();
                tooltip.add((FormattedText)text);
            }
        }
    }

    public static void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(AnvilCraftJeiPlugin.BULGING, JeiRecipeUtil.getRecipeHoldersFromType((RecipeType)ModRecipeTypes.BULGING_TYPE.get()));
    }

    public static void registerCraftingStations(IRecipeCatalystRegistration registration) {
        registration.addCraftingStation(AnvilCraftJeiPlugin.BULGING, new ItemStack[]{new ItemStack((ItemLike)Items.ANVIL)});
        registration.addCraftingStation(AnvilCraftJeiPlugin.BULGING, new ItemStack[]{new ItemStack((ItemLike)Items.CAULDRON)});
    }
}

