/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.integration.jei.category.anvil;

import dev.anvilcraft.lite.init.reicpe.ModRecipeTypes;
import dev.anvilcraft.lite.integration.jei.AnvilCraftJeiPlugin;
import dev.anvilcraft.lite.integration.jei.util.JeiRecipeUtil;
import dev.anvilcraft.lite.integration.jei.util.JeiRenderHelper;
import dev.anvilcraft.lite.integration.jei.util.JeiSlotUtil;
import dev.anvilcraft.lite.recipe.anvil.wrap.ItemInjectRecipe;
import dev.anvilcraft.lite.util.render.RenderHelper;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemInjectCategory
implements IRecipeCategory<RecipeHolder<ItemInjectRecipe>> {
    public static final int WIDTH = 162;
    public static final int HEIGHT = 64;
    private final IDrawable icon;
    private final IDrawable slotDefault;
    private final Component title;
    private final ITickTimer timer;
    private final IDrawable arrowIn;
    private final IDrawable arrowOut;

    public ItemInjectCategory(IGuiHelper helper) {
        this.icon = helper.createDrawableItemStack(new ItemStack((ItemLike)Items.ANVIL));
        this.slotDefault = JeiRenderHelper.getSlotDefault(helper);
        this.title = Component.translatable((String)"gui.anvilcraft.category.item_inject");
        this.timer = helper.createTickTimer(30, 60, true);
        this.arrowIn = JeiRenderHelper.getArrowInput(helper);
        this.arrowOut = JeiRenderHelper.getArrowOutput(helper);
    }

    public IRecipeType<RecipeHolder<ItemInjectRecipe>> getRecipeType() {
        return AnvilCraftJeiPlugin.ITEM_INJECT;
    }

    public Component getTitle() {
        return this.title;
    }

    public int getWidth() {
        return 162;
    }

    public int getHeight() {
        return 64;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<ItemInjectRecipe> recipeHolder, IFocusGroup focuses) {
        ItemInjectRecipe recipe = (ItemInjectRecipe)recipeHolder.value();
        JeiSlotUtil.addInputSlots(builder, recipe.getInputItems());
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).add(Ingredient.of(recipe.getFirstInputBlock().getBlocks().stream().map(Holder::value)));
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).add(new ItemStack((ItemLike)recipe.getFirstResultBlock().state().getBlock()));
    }

    public void draw(RecipeHolder<ItemInjectRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Rect2i area = AnvilCraftJeiPlugin.AREA_WHEN_DRAW.get();
        int left = area.getX() - 9;
        int top = area.getY() - 7;
        ItemInjectRecipe recipe = (ItemInjectRecipe)recipeHolder.value();
        float anvilYOffset = JeiRenderHelper.getAnvilAnimationOffset(this.timer);
        List input = recipe.getFirstInputBlock().constructStatesForRender();
        if (input.isEmpty()) {
            return;
        }
        BlockState renderedState = (BlockState)input.get((int)(System.currentTimeMillis() / 1000L % (long)input.size()));
        if (renderedState == null) {
            return;
        }
        RenderHelper.renderSingleBlock(guiGraphics, renderedState, left + 81, top + 40, 12.0f);
        RenderHelper.renderSingleBlock(guiGraphics, Blocks.ANVIL.defaultBlockState(), left + 81, (float)(top + 22) + anvilYOffset, 12.0f);
        this.arrowIn.draw(guiGraphics, 54, 30);
        this.arrowOut.draw(guiGraphics, 92, 29);
        JeiSlotUtil.drawInputSlots(guiGraphics, this.slotDefault, recipe.getInputItems().size());
        RenderHelper.renderSingleBlock(guiGraphics, recipe.getFirstResultBlock().state(), left + 133, top + 30, 12.0f);
    }

    public void getTooltip(ITooltipBuilder tooltip, RecipeHolder<ItemInjectRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ItemInjectRecipe recipe = (ItemInjectRecipe)recipeHolder.value();
        if (mouseX >= 72.0 && mouseX <= 90.0 && mouseY >= 34.0 && mouseY <= 53.0) {
            tooltip.add((FormattedText)((BlockState)recipe.getFirstInputBlock().constructStatesForRender().getFirst()).getBlock().getName());
        }
        if (mouseX >= 124.0 && mouseX <= 140.0 && mouseY >= 24.0 && mouseY <= 42.0) {
            tooltip.add((FormattedText)recipe.getFirstResultBlock().state().getBlock().getName());
        }
    }

    public static void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(AnvilCraftJeiPlugin.ITEM_INJECT, JeiRecipeUtil.getRecipeHoldersFromType((RecipeType)ModRecipeTypes.ITEM_INJECT_TYPE.get()));
    }

    public static void registerCraftingStations(IRecipeCatalystRegistration registration) {
        registration.addCraftingStation(AnvilCraftJeiPlugin.ITEM_INJECT, new ItemStack[]{new ItemStack((ItemLike)Items.ANVIL)});
    }
}

