/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.integration.jei.recipe;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import dev.anvilcraft.lib.recipe.component.ChanceItemStack;
import dev.anvilcraft.lib.recipe.component.ItemIngredientPredicate;
import dev.anvilcraft.lib.util.NumberProviderUtil;
import dev.anvilcraft.lite.init.reicpe.ModRecipeTypes;
import dev.anvilcraft.lite.integration.jei.util.JeiRecipeUtil;
import dev.anvilcraft.lite.recipe.anvil.wrap.MeshRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public record MeshRecipeGroup(ItemIngredientPredicate ingredient, List<Result> results) {
    public static int maxRows;

    /*
     * Iterators could be improved
     * Loose catch block
     */
    public static ImmutableList<MeshRecipeGroup> getAllRecipesGrouped() {
        maxRows = 1;
        List recipes = JeiRecipeUtil.getRecipesFromType((RecipeType)ModRecipeTypes.MESH_TYPE.get());
        ArrayListMultimap ingredientGrouper = ArrayListMultimap.create();
        for (MeshRecipe recipe : recipes) {
            for (ItemIngredientPredicate ingredient : recipe.getInputItems()) {
                ingredientGrouper.put((Object)ingredient, (Object)recipe);
            }
        }
        ImmutableList.Builder jeiRecipes = ImmutableList.builder();
        Comparator<Result> resultSorter = Comparator.comparingDouble(Result::expectedCount).reversed();
        for (ItemIngredientPredicate ingredient : ingredientGrouper.keySet()) {
            Collection values = ingredientGrouper.get((Object)ingredient);
            ArrayList<Result> results = new ArrayList<Result>(values.size());
            for (MeshRecipe recipe : values) {
                for (ChanceItemStack stack : recipe.getResultItems()) {
                    int n;
                    NumberProvider numberProvider = stack.count();
                    if (numberProvider instanceof ConstantValue) {
                        float f;
                        ConstantValue constantValue = (ConstantValue)numberProvider;
                        float value = f = constantValue.value();
                        n = Math.round(value);
                    } else {
                        n = 1;
                    }
                    int resultCount = n;
                    results.add(new Result(stack.stack().copyWithCount(resultCount), stack.count()));
                }
            }
            results.sort(resultSorter);
            jeiRecipes.add((Object)new MeshRecipeGroup(ingredient, results));
            int rows = Mth.ceil((float)((float)values.size() / 9.0f));
            if (rows <= maxRows) continue;
            maxRows = rows;
        }
        return jeiRecipes.build();
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    public record Result(ItemStack item, NumberProvider provider, double expectedCount) {
        public Result(ItemStack item, NumberProvider provider) {
            this(item, provider, NumberProviderUtil.expected((NumberProvider)provider));
        }
    }
}

