/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.integration.jei.util;

import com.google.common.collect.ImmutableList;
import dev.anvilcraft.lib.recipe.component.ChanceItemStack;
import dev.anvilcraft.lib.util.NumberProviderUtil;
import dev.anvilcraft.lite.integration.jei.AnvilCraftJeiPlugin;
import java.lang.runtime.SwitchBootstraps;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class JeiRecipeUtil {
    private static final DecimalFormat FORMATTER = new DecimalFormat();

    public static <I extends RecipeInput, T extends Recipe<I>> List<T> getRecipesFromType(RecipeType<T> recipeType) {
        if (AnvilCraftJeiPlugin.recipes.values().isEmpty()) {
            throw new IllegalStateException(I18n.get((String)"jei.message.missing.recipes.from.server", (Object[])new Object[0]));
        }
        return AnvilCraftJeiPlugin.recipes.byType(recipeType).stream().map(RecipeHolder::value).collect(Collectors.toCollection(ArrayList::new));
    }

    public static <I extends RecipeInput, T extends Recipe<I>> List<RecipeHolder<T>> getRecipeHoldersFromType(RecipeType<T> recipeType) {
        if (AnvilCraftJeiPlugin.recipes.values().isEmpty()) {
            throw new IllegalStateException(I18n.get((String)"jei.message.missing.recipes.from.server", (Object[])new Object[0]));
        }
        return new ArrayList<RecipeHolder<T>>(AnvilCraftJeiPlugin.recipes.byType(recipeType));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addTooltips(IRecipeSlotBuilder slot, int count, NumberProvider provider) {
        ImmutableList.Builder tooltipLines;
        block8: {
            double val;
            block6: {
                NumberProvider n;
                block7: {
                    block5: {
                        NumberProvider p;
                        NumberProvider numberProvider;
                        tooltipLines = new ImmutableList.Builder();
                        if (!(provider instanceof BinomialDistributionGenerator)) break block6;
                        BinomialDistributionGenerator binomialDistributionGenerator = (BinomialDistributionGenerator)provider;
                        try {
                            n = numberProvider = binomialDistributionGenerator.n();
                            p = numberProvider = binomialDistributionGenerator.p();
                        }
                        catch (Throwable throwable) {
                            throw new MatchException(throwable.toString(), throwable);
                        }
                        {
                            float f;
                            float value;
                            if (!(n instanceof ConstantValue) || (value = (f = (numberProvider = (ConstantValue)n).value())) != 1.0f) break block5;
                        }
                        String chance = FORMATTER.format(NumberProviderUtil.expected((NumberProvider)p) * 100.0);
                        tooltipLines.add((Object)Component.translatable((String)"gui.anvilcraft.category.chance", (Object[])new Object[]{chance}).withStyle(ChatFormatting.GRAY));
                        break block7;
                    }
                    JeiRecipeUtil.addAvgOutput((ImmutableList.Builder<Component>)tooltipLines, (double)count * NumberProviderUtil.expected((NumberProvider)provider));
                }
                JeiRecipeUtil.addMinMax((ImmutableList.Builder<Component>)tooltipLines, 0.0, JeiRecipeUtil.getMax(n));
                break block8;
            }
            if (provider.getClass() != ConstantValue.class && (val = (double)count * NumberProviderUtil.expected((NumberProvider)provider)) != -1.0) {
                JeiRecipeUtil.addAvgOutput((ImmutableList.Builder<Component>)tooltipLines, val);
                if (provider instanceof UniformGenerator) {
                    JeiRecipeUtil.addMinMax((ImmutableList.Builder<Component>)tooltipLines, JeiRecipeUtil.getMin(provider), JeiRecipeUtil.getMax(provider));
                }
            }
        }
        slot.addRichTooltipCallback((slotView, tooltip) -> tooltip.addAll((Collection)tooltipLines.build()));
    }

    public static boolean isChance(List<ChanceItemStack> chanceItemStacks) {
        for (ChanceItemStack chanceItemStack : chanceItemStacks) {
            NumberProvider provider = chanceItemStack.count();
            if (provider instanceof BinomialDistributionGenerator) {
                return true;
            }
            if (provider.getClass() == ConstantValue.class) continue;
            return true;
        }
        return false;
    }

    private static double getMin(NumberProvider provider) {
        NumberProvider numberProvider = provider;
        Objects.requireNonNull(numberProvider);
        NumberProvider numberProvider2 = numberProvider;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConstantValue.class, UniformGenerator.class}, (Object)numberProvider2, n)) {
            case 0 -> {
                ConstantValue value = (ConstantValue)numberProvider2;
                yield value.value();
            }
            case 1 -> {
                UniformGenerator uniform = (UniformGenerator)numberProvider2;
                yield JeiRecipeUtil.getMin(uniform.min());
            }
            default -> 0.0;
        };
    }

    private static double getMax(NumberProvider provider) {
        NumberProvider numberProvider = provider;
        Objects.requireNonNull(numberProvider);
        NumberProvider numberProvider2 = numberProvider;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConstantValue.class, UniformGenerator.class, BinomialDistributionGenerator.class}, (Object)numberProvider2, n)) {
            case 0 -> {
                ConstantValue value = (ConstantValue)numberProvider2;
                yield value.value();
            }
            case 1 -> {
                UniformGenerator uniform = (UniformGenerator)numberProvider2;
                yield JeiRecipeUtil.getMax(uniform.max());
            }
            case 2 -> {
                BinomialDistributionGenerator binomial = (BinomialDistributionGenerator)numberProvider2;
                yield JeiRecipeUtil.getMax(binomial.n());
            }
            default -> 0.0;
        };
    }

    private static void addAvgOutput(ImmutableList.Builder<Component> tooltipLines, double avgValue) {
        String avgOutput = FORMATTER.format(avgValue);
        tooltipLines.add((Object)Component.translatable((String)"gui.anvilcraft.category.average_output", (Object[])new Object[]{avgOutput}).withStyle(ChatFormatting.GRAY));
    }

    private static void addMinMax(ImmutableList.Builder<Component> tooltipLines, double min, double max) {
        String minOutput = FORMATTER.format(min);
        String maxOutput = FORMATTER.format(max);
        tooltipLines.add((Object)Component.translatable((String)"gui.anvilcraft.category.min_output", (Object[])new Object[]{minOutput}).withStyle(ChatFormatting.GRAY));
        tooltipLines.add((Object)Component.translatable((String)"gui.anvilcraft.category.max_output", (Object[])new Object[]{maxOutput}).withStyle(ChatFormatting.GRAY));
    }
}

