/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.item.property.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.anvilcraft.lite.AnvilCraftLite;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public record SavedEntity(CompoundTag tag, boolean isMonster) {
    public static final Codec<SavedEntity> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)CompoundTag.CODEC.fieldOf("tag").forGetter(SavedEntity::tag), (App)Codec.BOOL.fieldOf("isMonster").forGetter(SavedEntity::isMonster)).apply((Applicative)ins, SavedEntity::new));
    public static final StreamCodec<ByteBuf, SavedEntity> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG, SavedEntity::tag, (StreamCodec)ByteBufCodecs.BOOL, SavedEntity::isMonster, SavedEntity::new);

    @Nullable
    public Entity toEntity(Level level) {
        try (ProblemReporter.ScopedCollector reporter = new ProblemReporter.ScopedCollector(AnvilCraftLite.LOGGER);){
            ValueInput tagValueInput = TagValueInput.create((ProblemReporter)reporter, (HolderLookup.Provider)level.registryAccess(), (CompoundTag)this.tag);
            Optional optional = EntityType.by((ValueInput)tagValueInput);
            if (optional.isEmpty()) {
                Entity entity = null;
                return entity;
            }
            EntityType type = (EntityType)optional.get();
            Entity entity = type.create(level, EntitySpawnReason.SPAWN_ITEM_USE);
            if (entity == null) {
                Entity entity2 = null;
                return entity2;
            }
            entity.load(tagValueInput);
            Entity entity3 = entity;
            return entity3;
        }
    }

    public static SavedEntity fromMob(Mob entity) {
        try (ProblemReporter.ScopedCollector reporter = new ProblemReporter.ScopedCollector(AnvilCraftLite.LOGGER);){
            TagValueOutput tagValueOutput = TagValueOutput.createWithContext((ProblemReporter)reporter, (HolderLookup.Provider)entity.level().registryAccess());
            entity.saveAsPassenger((ValueOutput)tagValueOutput);
            CompoundTag entityTag = tagValueOutput.buildResult();
            entityTag.remove("UUID");
            entityTag.remove("Pos");
            entityTag.remove("Motion");
            entityTag.remove("Fire");
            entityTag.remove("Air");
            entityTag.remove("fall_distance");
            SavedEntity savedEntity = new SavedEntity(entityTag, !entity.getType().getCategory().isFriendly());
            return savedEntity;
        }
    }
}

