/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.recipe.anvil.builder;

import dev.anvilcraft.lite.AnvilCraftLite;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class AbstractRecipeBuilder<T extends Recipe<?>>
implements RecipeBuilder {
    protected final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public RecipeBuilder unlockedBy(String pName, Criterion<?> pCriterion) {
        this.criteria.put(pName, pCriterion);
        return this;
    }

    public RecipeBuilder group(@Nullable String pGroupName) {
        return this;
    }

    public void save(RecipeOutput pRecipeOutput, ResourceKey<Recipe<?>> pId) {
        this.validate(pId.location());
        Advancement.Builder advancement = pRecipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked(pId)).rewards(AdvancementRewards.Builder.recipe(pId)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement).addCriterion(arg_0, arg_1));
        T recipe = this.buildRecipe();
        pRecipeOutput.accept(pId, recipe, advancement.build(pId.location().withPrefix("recipes/")));
    }

    public void save(RecipeOutput pRecipeOutput, ResourceLocation pId) {
        this.save(pRecipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)pId));
    }

    public void save(RecipeOutput recipeOutput) {
        this.save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)AnvilCraftLite.of(BuiltInRegistries.ITEM.getKey((Object)this.getResult()).getPath()).withPrefix(this.getType() + "/")));
    }

    public abstract T buildRecipe();

    public abstract void validate(ResourceLocation var1);

    public abstract String getType();

    public abstract Item getResult();
}

