/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.recipe.anvil.util;

import dev.anvilcraft.lib.recipe.component.BlockStatePredicate;
import dev.anvilcraft.lib.recipe.component.ChanceBlockState;
import dev.anvilcraft.lib.recipe.outcome.IRecipeOutcome;
import dev.anvilcraft.lib.recipe.predicate.IRecipePredicate;
import dev.anvilcraft.lib.recipe.predicate.block.HasBlock;
import dev.anvilcraft.lib.recipe.predicate.block.HasBlockIngredient;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Unmodifiable;

public class WrapUtils {
    public static List<IRecipePredicate<?>> getPredicates(List<BlockStatePredicate> results) {
        ArrayList predicates = new ArrayList();
        for (int i = 0; i < results.size(); ++i) {
            BlockStatePredicate result = results.get(i);
            predicates.add((IRecipePredicate<?>)new HasBlock(new Vec3(0.0, (double)(-i - 1), 0.0), result));
        }
        return predicates;
    }

    public static IRecipePredicate<?> getIngredientPredicate(BlockStatePredicate block) {
        return new HasBlockIngredient(new Vec3(0.0, -1.0, 0.0), block);
    }

    public static @Unmodifiable List<IRecipePredicate<?>> getIngredientPredicates(BlockStatePredicate block) {
        return List.of(WrapUtils.getIngredientPredicate(block));
    }

    public static List<IRecipePredicate<?>> getIngredientPredicates(List<BlockStatePredicate> results) {
        ArrayList predicates = new ArrayList();
        for (int i = 0; i < results.size(); ++i) {
            BlockStatePredicate result = results.get(i);
            predicates.add((IRecipePredicate<?>)new HasBlockIngredient(new Vec3(0.0, (double)(-i - 1), 0.0), result));
        }
        return predicates;
    }

    public static @Unmodifiable List<IRecipeOutcome<?>> getOutcomes(ChanceBlockState result, int yOffset) {
        return List.of(result.toSetBlock(new Vec3(0.0, (double)yOffset, 0.0)));
    }

    public static @Unmodifiable List<IRecipeOutcome<?>> getOutcomes(ChanceBlockState result) {
        return WrapUtils.getOutcomes(result, -1);
    }

    public static List<IRecipeOutcome<?>> getOutcomes(List<ChanceBlockState> results) {
        ArrayList outcomes = new ArrayList();
        for (int i = 0; i < results.size(); ++i) {
            ChanceBlockState result = results.get(i);
            outcomes.add((IRecipeOutcome<?>)result.toSetBlock(new Vec3(0.0, (double)(-i - 1), 0.0)));
        }
        return outcomes;
    }

    public static Item getItem(ChanceBlockState result) {
        BlockState state = result.state();
        if (state.isEmpty() || state.isAir()) {
            return Items.ANVIL;
        }
        Item item = state.getBlock().asItem();
        if (item == Items.AIR) {
            item = Items.ANVIL;
        }
        return item;
    }

    public static Item getItem(List<ChanceBlockState> results) {
        if (results.isEmpty()) {
            return Items.ANVIL;
        }
        return WrapUtils.getItem(results.getFirst());
    }

    public static ItemStack getItemStack(ChanceBlockState result) {
        return WrapUtils.getItem(result).getDefaultInstance();
    }

    public static ItemStack getItemStack(List<ChanceBlockState> results) {
        if (results.isEmpty()) {
            return Items.ANVIL.getDefaultInstance();
        }
        return WrapUtils.getItem(results.getFirst()).getDefaultInstance();
    }

    public static ResourceLocation cauldron2Fluid(Block cauldron) {
        ResourceLocation key = BuiltInRegistries.BLOCK.getKey((Object)cauldron);
        String namespace = key.getNamespace();
        String path = key.getPath();
        if (path.endsWith("_cauldron")) {
            path = path.substring(0, path.length() - 9);
        }
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
    }
}

