/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.recipe.anvil.wrap;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.anvilcraft.lib.recipe.component.BlockStatePredicate;
import dev.anvilcraft.lib.recipe.component.ChanceBlockState;
import dev.anvilcraft.lite.init.reicpe.ModRecipeTypes;
import dev.anvilcraft.lite.recipe.anvil.builder.AbstractRecipeBuilder;
import dev.anvilcraft.lite.recipe.anvil.predicate.block.HasCauldron;
import dev.anvilcraft.lite.recipe.anvil.util.WrapUtils;
import dev.anvilcraft.lite.recipe.anvil.wrap.AbstractProcessRecipe;
import dev.anvilcraft.lite.recipe.component.HasCauldronSimple;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;

public class SqueezingRecipe
extends AbstractProcessRecipe<SqueezingRecipe> {
    public SqueezingRecipe(BlockStatePredicate ingredient, ChanceBlockState result, HasCauldronSimple hasCauldron) {
        super(new AbstractProcessRecipe.Property().setBlockInputOffset(new Vec3i(0, -1, 0)).setConsumeInputBlocks(true).setInputBlocks(ingredient).setCauldronOffset(new Vec3i(0, -2, 0)).setHasCauldron(hasCauldron).setBlockOutputOffset(new Vec3i(0, -1, 0)).setResultBlocks(result));
    }

    @Override
    public RecipeSerializer<SqueezingRecipe> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.SQUEEZING_SERIALIZER.get();
    }

    @Override
    public RecipeType<SqueezingRecipe> getType() {
        return (RecipeType)ModRecipeTypes.SQUEEZING_TYPE.get();
    }

    public static Builder builder(HolderGetter<Block> getter) {
        return new Builder(getter);
    }

    public boolean isProduceFluid() {
        HasCauldronSimple hasCauldron = this.getHasCauldron();
        return HasCauldron.isNotEmpty(hasCauldron.transform()) && this.getHasCauldron().consume() < 0;
    }

    public static class Builder
    extends AbstractRecipeBuilder<SqueezingRecipe> {
        private final HolderGetter<Block> getter;
        private BlockStatePredicate ingredient = null;
        private ChanceBlockState result = null;
        private final HasCauldronSimple.Builder hasCauldron = HasCauldronSimple.empty();

        public Builder(HolderGetter<Block> getter) {
            this.getter = getter;
        }

        public Builder requires(BlockStatePredicate ingredient) {
            this.ingredient = ingredient;
            return this;
        }

        public Builder requires(Block ingredient) {
            return this.requires(BlockStatePredicate.builder(this.getter).of(new Block[]{ingredient}).build());
        }

        public Builder requires(TagKey<Block> ingredient) {
            return this.requires(BlockStatePredicate.builder(this.getter).of(ingredient).build());
        }

        public Builder result(ChanceBlockState result) {
            this.result = result;
            return this;
        }

        public Builder result(Block result, float chance) {
            return this.result(new ChanceBlockState(result.defaultBlockState(), chance));
        }

        public Builder result(Block result) {
            return this.result(result, 1.0f);
        }

        public Builder cauldron(ResourceLocation fluid) {
            this.hasCauldron.fluid(fluid);
            return this;
        }

        public Builder cauldron(Block cauldron) {
            this.cauldron(WrapUtils.cauldron2Fluid(cauldron));
            return this;
        }

        public Builder transform(ResourceLocation transform) {
            this.hasCauldron.transform(transform);
            return this;
        }

        public Builder transform(Block transform) {
            this.hasCauldron.transform(WrapUtils.cauldron2Fluid(transform));
            return this;
        }

        public Builder produce(int produce) {
            if (produce <= 0) {
                return this;
            }
            this.hasCauldron.consume(-produce);
            return this;
        }

        public Builder consume(int consume) {
            if (consume <= 0) {
                return this;
            }
            this.hasCauldron.consume(consume);
            return this;
        }

        @Override
        public SqueezingRecipe buildRecipe() {
            return new SqueezingRecipe(this.ingredient, this.result, this.hasCauldron.build());
        }

        @Override
        public void validate(ResourceLocation pId) {
        }

        @Override
        public String getType() {
            return "bulging";
        }

        @Override
        public Item getResult() {
            return WrapUtils.getItem(this.result);
        }
    }

    public static class Serializer
    implements RecipeSerializer<SqueezingRecipe> {
        public static final MapCodec<SqueezingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockStatePredicate.CODEC.fieldOf("ingredient").forGetter(AbstractProcessRecipe::getFirstInputBlock), (App)ChanceBlockState.CODEC.codec().fieldOf("result").forGetter(AbstractProcessRecipe::getFirstResultBlock), (App)HasCauldronSimple.CODEC.forGetter(AbstractProcessRecipe::getHasCauldron)).apply((Applicative)instance, SqueezingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SqueezingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockStatePredicate.STREAM_CODEC, AbstractProcessRecipe::getFirstInputBlock, (StreamCodec)ChanceBlockState.STREAM_CODEC, AbstractProcessRecipe::getFirstResultBlock, HasCauldronSimple.STREAM_CODEC, AbstractProcessRecipe::getHasCauldron, SqueezingRecipe::new);

        public MapCodec<SqueezingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SqueezingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

