/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.recipe.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.anvilcraft.lite.recipe.anvil.predicate.block.HasCauldron;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public record HasCauldronSimple(ResourceLocation fluid, int consume, ResourceLocation transform) {
    public static final MapCodec<HasCauldronSimple> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.optionalFieldOf("fluid", (Object)HasCauldron.EMPTY).forGetter(HasCauldronSimple::fluid), (App)Codec.INT.optionalFieldOf("consume", (Object)0).forGetter(HasCauldronSimple::consume), (App)ResourceLocation.CODEC.optionalFieldOf("transform", (Object)HasCauldron.NULL).forGetter(HasCauldronSimple::transform)).apply((Applicative)instance, HasCauldronSimple::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, HasCauldronSimple> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, HasCauldronSimple::fluid, (StreamCodec)ByteBufCodecs.INT, HasCauldronSimple::consume, (StreamCodec)ResourceLocation.STREAM_CODEC, HasCauldronSimple::transform, HasCauldronSimple::new);

    public HasCauldron toHasCauldron(Vec3 offset) {
        return new HasCauldron(offset, this.fluid, this.consume, this.transform);
    }

    public Block getFluidCauldron() {
        return HasCauldron.getDefaultCauldron(this.fluid);
    }

    public Block getTransformCauldron() {
        return HasCauldron.getDefaultCauldron(this.transform);
    }

    @NotNull
    public static Builder empty() {
        return Builder.empty();
    }

    @NotNull
    public static Builder fluid(ResourceLocation fluid) {
        return Builder.of(fluid);
    }

    public static class Builder {
        private ResourceLocation fluid = HasCauldron.EMPTY;
        private int consume = 0;
        private ResourceLocation transform = HasCauldron.NULL;

        @NotNull
        public static Builder empty() {
            return new Builder();
        }

        @NotNull
        public static Builder of(ResourceLocation fluid) {
            Builder builder = new Builder();
            builder.fluid = fluid;
            return builder;
        }

        @NotNull
        public Builder fluid(ResourceLocation fluid) {
            this.fluid = fluid;
            return this;
        }

        @NotNull
        public Builder transform(ResourceLocation transform) {
            this.transform = transform;
            return this;
        }

        public Builder consume(int consume) {
            this.consume = consume;
            return this;
        }

        public HasCauldronSimple build() {
            return new HasCauldronSimple(this.fluid, this.consume, this.transform);
        }
    }
}

