/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.util;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.CauldronFluidContent;

public class CauldronUtil {
    public static IntegerProperty LEVEL_3 = LayeredCauldronBlock.LEVEL;
    public static IntegerProperty LEVEL_4 = IntegerProperty.create((String)"level", (int)1, (int)4);

    public static int currentLevel(BlockState state) {
        if (state.is(Blocks.CAULDRON)) {
            return 0;
        }
        Block block = state.getBlock();
        if (!(block instanceof AbstractCauldronBlock)) {
            return 0;
        }
        AbstractCauldronBlock cauldron = (AbstractCauldronBlock)block;
        if (state.hasProperty((Property)LEVEL_3)) {
            return (Integer)state.getValue((Property)LEVEL_3);
        }
        if (state.hasProperty((Property)LEVEL_4)) {
            return (Integer)state.getValue((Property)LEVEL_4);
        }
        return Optional.of(cauldron).map(CauldronFluidContent::getForBlock).map(content -> content.currentLevel(state)).orElse(1);
    }

    public static int maxLevel(Block cauldronContent) {
        if (cauldronContent == Blocks.CAULDRON) {
            return 0;
        }
        if (!(cauldronContent instanceof AbstractCauldronBlock)) {
            return 0;
        }
        AbstractCauldronBlock cauldron = (AbstractCauldronBlock)cauldronContent;
        BlockState defaultState = cauldron.defaultBlockState();
        if (defaultState.hasProperty((Property)LEVEL_3)) {
            return 3;
        }
        if (defaultState.hasProperty((Property)LEVEL_4)) {
            return 4;
        }
        return Optional.of(cauldron).map(CauldronFluidContent::getForBlock).map(content -> content.maxLevel).orElse(1);
    }

    public static boolean compatibleFor(BlockState state, Block cauldronContent) {
        if (cauldronContent == Blocks.CAULDRON) {
            return false;
        }
        return state.is(Blocks.CAULDRON) || state.is(cauldronContent);
    }

    public static int remainSpaceFor(BlockState state, Block cauldronContent) {
        if (!CauldronUtil.compatibleFor(state, cauldronContent)) {
            return 0;
        }
        int contentMaxLevel = CauldronUtil.maxLevel(cauldronContent);
        return Math.max(0, contentMaxLevel - CauldronUtil.currentLevel(state));
    }

    public static BlockState getStateFromContentAndLevel(Block cauldronContent, int cauldronLevel) {
        if (!(cauldronContent instanceof AbstractCauldronBlock)) {
            return cauldronContent.defaultBlockState();
        }
        AbstractCauldronBlock cauldron = (AbstractCauldronBlock)cauldronContent;
        if (cauldronLevel <= 0) {
            return Blocks.CAULDRON.defaultBlockState();
        }
        BlockState state = cauldronContent.defaultBlockState();
        if (state.hasProperty((Property)LEVEL_3)) {
            return (BlockState)state.setValue((Property)LEVEL_3, (Comparable)Integer.valueOf(Math.min(3, cauldronLevel)));
        }
        if (state.hasProperty((Property)LEVEL_4)) {
            return (BlockState)state.setValue((Property)LEVEL_4, (Comparable)Integer.valueOf(Math.min(4, cauldronLevel)));
        }
        return Optional.of(cauldron).map(CauldronFluidContent::getForBlock).filter(content -> content.levelProperty != null).map(content -> (BlockState)state.setValue((Property)content.levelProperty, (Comparable)Integer.valueOf(Math.min(content.maxLevel, cauldronLevel)))).orElse(state);
    }

    public static BlockState fullState(Block cauldronContent) {
        if (cauldronContent == Blocks.CAULDRON) {
            return Blocks.CAULDRON.defaultBlockState();
        }
        BlockState state = cauldronContent.defaultBlockState();
        if (!(cauldronContent instanceof AbstractCauldronBlock)) {
            return state;
        }
        AbstractCauldronBlock cauldron = (AbstractCauldronBlock)cauldronContent;
        if (state.hasProperty((Property)LEVEL_3)) {
            return (BlockState)state.setValue((Property)LEVEL_3, (Comparable)Integer.valueOf(3));
        }
        if (state.hasProperty((Property)LEVEL_4)) {
            return (BlockState)state.setValue((Property)LEVEL_4, (Comparable)Integer.valueOf(4));
        }
        return Optional.of(cauldron).map(CauldronFluidContent::getForBlock).filter(content -> content.levelProperty != null).map(content -> (BlockState)state.setValue((Property)content.levelProperty, (Comparable)Integer.valueOf(content.maxLevel))).orElse(state);
    }

    public static void setContentLevel(Level level, BlockPos pos, Block cauldronContent, int cauldronLevel) {
        level.setBlockAndUpdate(pos, CauldronUtil.getStateFromContentAndLevel(cauldronContent, cauldronLevel));
    }

    public static int fill(Level level, BlockPos pos, Block cauldronContent, int fillLevel, boolean simulate) {
        if (fillLevel <= 0) {
            return 0;
        }
        BlockState state = level.getBlockState(pos);
        int remainSpace = CauldronUtil.remainSpaceFor(state, cauldronContent);
        if (remainSpace <= 0) {
            return 0;
        }
        int filled = Math.min(remainSpace, fillLevel);
        if (!simulate) {
            CauldronUtil.setContentLevel(level, pos, cauldronContent, CauldronUtil.currentLevel(state) + filled);
        }
        return filled;
    }

    public static int drain(Level level, BlockPos pos, Block cauldronContent, int drainLevel, boolean simulate) {
        if (drainLevel <= 0) {
            return 0;
        }
        BlockState state = level.getBlockState(pos);
        if (!CauldronUtil.compatibleFor(state, cauldronContent)) {
            return 0;
        }
        int currentLevel = CauldronUtil.currentLevel(state);
        int drained = Math.min(drainLevel, currentLevel);
        if (drained <= 0) {
            return 0;
        }
        if (!simulate) {
            CauldronUtil.setContentLevel(level, pos, cauldronContent, currentLevel - drained);
        }
        return drained;
    }

    public static boolean compatibleForDrain(BlockState state, Block cauldronContent, int drainLevel) {
        if (drainLevel <= 0) {
            return true;
        }
        return CauldronUtil.compatibleFor(state, cauldronContent) && CauldronUtil.currentLevel(state) >= drainLevel;
    }

    public static boolean compatibleForFill(BlockState state, Block cauldronContent, int fillLevel) {
        if (fillLevel <= 0) {
            return true;
        }
        return CauldronUtil.remainSpaceFor(state, cauldronContent) >= fillLevel;
    }
}

