/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.lite.util;

import com.mojang.datafixers.util.Either;
import dev.anvilcraft.lib.recipe.component.ItemIngredientPredicate;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.util.TriState;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public final class RecipeUtil {
    private RecipeUtil() {
    }

    public static ItemIngredientPredicate.Builder wrapIngredient(HolderGetter<Item> items, Ingredient ingredient) {
        if (ingredient.isCustom()) {
            return ItemIngredientPredicate.Builder.item(items);
        }
        Either data = ingredient.getValues().unwrap();
        ItemIngredientPredicate.Builder[] result = new ItemIngredientPredicate.Builder[1];
        data.ifLeft(tag -> {
            result[0] = ItemIngredientPredicate.of((HolderGetter)items, (TagKey)tag);
        });
        if (result[0] != null) {
            return result[0];
        }
        data.ifRight(holders -> {
            result[0] = ItemIngredientPredicate.of((HolderGetter)items, (ItemLike[])((ItemLike[])holders.stream().map(Holder::value).toArray(ItemLike[]::new)));
        });
        if (result[0] != null) {
            return result[0];
        }
        return ItemIngredientPredicate.Builder.item(items);
    }

    public static String getName(Ingredient ingredient) {
        if (ingredient.isCustom()) {
            return "empty";
        }
        Either data = ingredient.getValues().unwrap();
        String[] result = new String[1];
        data.ifLeft(tag -> {
            result[0] = tag.location().getPath().replace("/", "_");
        });
        if (result[0] != null) {
            return result[0];
        }
        data.ifRight(holders -> {
            result[0] = BuiltInRegistries.ITEM.getKey((Object)((Item)((Holder)holders.getFirst()).value())).getPath();
        });
        if (result[0] != null) {
            return result[0];
        }
        return "empty";
    }

    public static TriState testIngredient(Ingredient ingredient, Predicate<Holder<Item>> tester) {
        if (ingredient.isCustom()) {
            return TriState.DEFAULT;
        }
        Either data = ingredient.getValues().unwrap();
        TriState[] result = new TriState[]{TriState.DEFAULT};
        data.ifLeft(tag -> {
            for (Holder holder : BuiltInRegistries.ITEM.getOrThrow(tag)) {
                if (tester.test(holder)) continue;
                result[0] = TriState.FALSE;
                return;
            }
            result[0] = TriState.TRUE;
        });
        if (result[0] != TriState.DEFAULT) {
            return result[0];
        }
        data.ifRight(tag -> {
            for (Holder holder : tag) {
                if (tester.test(holder)) continue;
                result[0] = TriState.FALSE;
                return;
            }
            result[0] = TriState.TRUE;
        });
        if (result[0] != TriState.DEFAULT) {
            return result[0];
        }
        return TriState.DEFAULT;
    }
}

