/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.client.gui.widget;

import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import ru.blatfan.blatapi.BlatApi;
import ru.blatfan.blatapi.client.render.FluidRenderMap;

public class FluidBar
extends AbstractWidget {
    public final ResourceLocation FLUID_WIDGET;
    private final IFluidHandler fluidHandler;
    private final int tank;
    private final float scale;
    private final Color barColor;

    public FluidBar(int pX, int pY, int pWidth, ResourceLocation fluidWidget, IFluidHandler fluidHandler, int tank, Color barColor) {
        super(pX, pY, pWidth, 62 * (pWidth / 16), (Component)Component.m_237113_((String)"Fluid Bar"));
        this.FLUID_WIDGET = fluidWidget;
        this.fluidHandler = fluidHandler;
        this.tank = tank;
        this.scale = (float)pWidth / 16.0f;
        this.barColor = barColor;
    }

    public FluidBar(int pX, int pY, int pWidth, IFluidHandler fluidHandler, int tank, Color barColor) {
        this(pX, pY, pWidth, BlatApi.loc("textures/gui/fluid.png"), fluidHandler, tank, barColor);
    }

    public FluidBar(int pX, int pY, int pWidth, IFluidHandler fluidHandler, int tank) {
        this(pX, pY, pWidth, BlatApi.loc("textures/gui/fluid.png"), fluidHandler, tank, Color.WHITE);
    }

    public boolean isMouseover(int mouseX, int mouseY) {
        return this.m_252754_() < mouseX && mouseX < this.m_252754_() + this.f_93618_ && this.m_252907_() < mouseY && mouseY < this.m_252907_() + this.m_93694_();
    }

    protected void m_87963_(GuiGraphics gui, int mouseX, int mouseY, float pPartialTick) {
        gui.m_280246_((float)this.barColor.getRed() / 255.0f, (float)this.barColor.getGreen() / 255.0f, (float)this.barColor.getBlue() / 255.0f, 1.0f);
        gui.m_280163_(this.FLUID_WIDGET, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.f_93618_, this.f_93619_, this.f_93618_ * 2, this.f_93619_);
        gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.fluidHandler != null && this.fluidHandler.getTankCapacity(this.tank) != 0 && this.fluidHandler.getFluidInTank(this.tank).getAmount() != 0) {
            float capacity = this.fluidHandler.getTankCapacity(this.tank);
            float amount = this.fluidHandler.getFluidInTank(this.tank).getAmount();
            FluidStack fluidStack = this.fluidHandler.getFluidInTank(this.tank);
            float fillRatio = Math.min(1.0f, amount / capacity);
            int fluidHeight = Math.round((float)this.f_93619_ * fillRatio);
            TextureAtlasSprite sprite = FluidRenderMap.getCachedFluidTexture(fluidStack, FluidRenderMap.FluidFlow.STILL);
            int fluidColor = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack);
            int xPosition = Math.round((float)this.m_252754_() + this.scale);
            int yPosition = Math.round((float)this.m_252907_() + this.scale);
            int maxHeight = Math.round((float)this.f_93619_ - 2.0f * this.scale);
            int renderWidth = Math.round((float)this.f_93618_ - 2.0f * this.scale);
            int renderHeight = Math.round((float)fluidHeight - 2.0f * this.scale);
            if (renderHeight > 0) {
                int currentTileHeight;
                float r = (float)(fluidColor >> 16 & 0xFF) / 255.0f;
                float g = (float)(fluidColor >> 8 & 0xFF) / 255.0f;
                float b = (float)(fluidColor & 0xFF) / 255.0f;
                float a = (float)(fluidColor >> 24 & 0xFF) / 255.0f;
                int tileSize = (int)(16.0f * this.scale);
                int yOffset = 0;
                for (int remainingHeight = renderHeight; remainingHeight > 0; remainingHeight -= currentTileHeight) {
                    currentTileHeight = Math.min(tileSize, remainingHeight);
                    int renderY = yPosition + maxHeight - yOffset - currentTileHeight;
                    gui.m_280565_(xPosition, renderY, 0, renderWidth, currentTileHeight, sprite, r, g, b, a);
                    yOffset += currentTileHeight;
                }
            }
            if (this.isMouseover(mouseX, mouseY)) {
                Object tt = "0mb";
                FluidStack current = this.fluidHandler.getFluidInTank(this.tank);
                if (!current.isEmpty()) {
                    tt = current.getAmount() + "mb /" + this.fluidHandler.getTankCapacity(this.tank) + "mb " + current.getDisplayName().getString();
                }
                ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
                list.add(Component.m_237115_((String)tt));
                gui.m_280666_(Minecraft.m_91087_().f_91062_, list, mouseX, mouseY);
            }
        }
        gui.m_280246_((float)this.barColor.getRed() / 255.0f, (float)this.barColor.getGreen() / 255.0f, (float)this.barColor.getBlue() / 255.0f, 1.0f);
        gui.m_280163_(this.FLUID_WIDGET, this.m_252754_(), this.m_252907_(), (float)this.f_93618_, 0.0f, this.f_93618_, this.f_93619_, this.f_93618_ * 2, this.f_93619_);
        gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
    }
}

