/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.client.gui.widget;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import ru.blatfan.blatapi.BlatApi;

public class TexturedProgress {
    protected final int x;
    protected final int y;
    protected final int width;
    protected final int height;
    protected final ResourceLocation texture;
    public int guiLeft;
    public int guiTop;
    public int max = 1;
    protected boolean topDown = false;

    public static TexturedProgress createHorizontal(int x, int y) {
        return new TexturedProgress(x, y, 22, 16, BlatApi.loc("textures/gui/progress_bar.png"));
    }

    public static TexturedProgress createVertical(int x, int y) {
        TexturedProgress vert = new TexturedProgress(x, y, 16, 22, BlatApi.loc("textures/gui/progress_bar_vertical.png"));
        vert.setTopDown(true);
        return vert;
    }

    public static TexturedProgress create(int x, int y, ResourceLocation texture) {
        return new TexturedProgress(x, y, 22, 16, texture);
    }

    public static TexturedProgress create(int x, int y, int width, int height, ResourceLocation texture) {
        return new TexturedProgress(x, y, width, height, texture);
    }

    public static TexturedProgress create(int x, int y, int width, int height, boolean topDown, ResourceLocation texture) {
        TexturedProgress bar = new TexturedProgress(x, y, width, height, texture);
        bar.setTopDown(topDown);
        return bar;
    }

    protected TexturedProgress(int x, int y, int width, int height, ResourceLocation texture) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.texture = texture;
    }

    public boolean isMouseover(int mouseX, int mouseY) {
        return this.guiLeft + this.x <= mouseX && mouseX <= this.guiLeft + this.x + this.width && this.guiTop + this.y <= mouseY && mouseY <= this.guiTop + this.y + this.height;
    }

    public void draw(GuiGraphics gg, float current) {
        int relX = this.guiLeft + this.x;
        int relY = this.guiTop + this.y;
        if (this.topDown) {
            gg.m_280163_(this.texture, relX, relY, 0.0f, 0.0f, this.width, this.height, this.width, this.height * 2);
            int rHeight = this.height - (int)((float)this.height * Math.min(current / (float)this.max, 1.0f));
            if (current != 0.0f) {
                gg.m_280163_(this.texture, relX, relY, 0.0f, (float)this.height, this.width, this.height - rHeight, this.width, this.height * 2);
            }
        } else {
            gg.m_280163_(this.texture, relX, relY, 0.0f, 0.0f, this.width, this.height, this.width, this.height * 2);
            int rWidth = (int)((float)this.width * Math.min(current / (float)this.max, 1.0f));
            if (current != 0.0f) {
                gg.m_280163_(this.texture, relX, relY, 0.0f, (float)this.height, rWidth, this.height, this.width, this.height * 2);
            }
        }
    }

    public void renderHoveredToolTip(GuiGraphics gg, int mouseX, int mouseY, int curr) {
        if (this.isMouseover(mouseX, mouseY) && curr > 0) {
            String display;
            int seconds = curr / 20;
            if (curr > 1200) {
                int minutes = seconds / 60;
                int remainder = seconds % 60;
                display = minutes + "m " + remainder + "s";
            } else {
                display = curr > 100 ? seconds + "s" : curr + "t";
            }
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.m_237115_((String)display));
            gg.m_280666_(Minecraft.m_91087_().f_91062_, list, mouseX, mouseY);
        }
    }

    public void setTopDown(boolean topDown) {
        this.topDown = topDown;
    }
}

