/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.client.render;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import ru.blatfan.blatapi.client.render.FluidRenderMap;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="moracraft", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class TextureCache {
    private static final Map<FluidTextureKey, WeakReference<TextureAtlasSprite>> CACHE = new ConcurrentHashMap<FluidTextureKey, WeakReference<TextureAtlasSprite>>();

    @Nullable
    public static TextureAtlasSprite get(FluidTextureKey key) {
        WeakReference<TextureAtlasSprite> ref = CACHE.get(key);
        return ref != null ? (TextureAtlasSprite)ref.get() : null;
    }

    public static void put(FluidTextureKey key, TextureAtlasSprite texture) {
        CACHE.put(key, new WeakReference<TextureAtlasSprite>(texture));
    }

    public static void clear() {
        CACHE.clear();
    }

    public static void cleanUp() {
        CACHE.entrySet().removeIf(entry -> {
            WeakReference ref = (WeakReference)entry.getValue();
            return ref == null || ref.get() == null;
        });
    }

    public static int size() {
        return CACHE.size();
    }

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Post event) {
        TextureCache.clear();
    }

    public static FluidTextureKey createKey(FluidStack fluidStack, FluidRenderMap.FluidFlow type) {
        String fluidName = BuiltInRegistries.f_257020_.m_7981_((Object)fluidStack.getFluid()).toString();
        return new FluidTextureKey(fluidName, type);
    }

    public static class FluidTextureKey {
        private final String fluidName;
        private final FluidRenderMap.FluidFlow type;
        private final int hashCode;

        private FluidTextureKey(String fluidName, FluidRenderMap.FluidFlow type) {
            this.fluidName = fluidName;
            this.type = type;
            this.hashCode = this.calculateHashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FluidTextureKey other = (FluidTextureKey)obj;
            return this.fluidName.equals(other.fluidName) && this.type == other.type;
        }

        public int hashCode() {
            return this.hashCode;
        }

        private int calculateHashCode() {
            int result = this.fluidName.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }
    }
}

