/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.biome_replacer;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.blatfan.blatapi.common.biome_replacer.BABiomeSource;
import ru.blatfan.blatapi.utils.BiomeHelper;

public class BiomeRaplacerModule {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"BiomeReplacer");
    public static RegistryAccess registryAccess;

    public BiomeRaplacerModule(IEventBus modEventBus) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onServerAboutToStart(ServerAboutToStartEvent event) {
        registryAccess = event.getServer().m_206579_();
        Registry levelStems = registryAccess.m_175515_(Registries.f_256862_);
        for (ResourceKey dimension : levelStems.m_214010_()) {
            BiomeSource biomeSource;
            Optional optionalLevelStem = levelStems.m_203636_(dimension);
            if (!optionalLevelStem.isPresent() || !((biomeSource = ((LevelStem)((Holder.Reference)optionalLevelStem.get()).m_203334_()).f_63976_().m_62218_()) instanceof BABiomeSource)) continue;
            BABiomeSource biomeSource2 = (BABiomeSource)biomeSource;
            if (dimension.equals((Object)LevelStem.f_63971_)) {
                biomeSource2.setDimension((ResourceKey<LevelStem>)LevelStem.f_63971_);
                biomeSource2.addPossibleBiomes(BiomeHelper.overworldPossibleBiomes);
                continue;
            }
            if (!dimension.equals((Object)LevelStem.f_63972_)) continue;
            biomeSource2.setDimension((ResourceKey<LevelStem>)LevelStem.f_63972_);
            biomeSource2.addPossibleBiomes(BiomeHelper.netherPossibleBiomes);
        }
    }
}

