/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.cap.item;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import ru.blatfan.blatapi.common.cap.CustomEnergyStorage;

public class CapabilityProviderEnergyStack
implements ICapabilitySerializable<CompoundTag> {
    private static final String NBTENERGY = "energy";
    CustomEnergyStorage energy;
    private final LazyOptional<IEnergyStorage> energyCap;

    public CapabilityProviderEnergyStack(int max) {
        this.energy = new CustomEnergyStorage(max, max);
        this.energyCap = LazyOptional.of(() -> this.energy);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyCap.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_(NBTENERGY, (Tag)this.energy.serializeNBT());
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.energy.deserializeNBT((Tag)nbt.m_128469_(NBTENERGY));
    }

    public String toString() {
        return "CapabilityProviderEnergyStack [energy=" + this.energy + "]";
    }
}

