/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.cap.item;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import ru.blatfan.blatapi.common.cap.CustomEnergyStorage;
import ru.blatfan.blatapi.utils.NBTHelper;

public class EnergyCapabilityItemStack
implements ICapabilityProvider {
    private final LazyOptional<IEnergyStorage> energy;
    private final int max;
    private final ItemStack stack;

    private IEnergyStorage createEnergy() {
        return new CustomEnergyStorage(this.max){

            private CompoundTag getTag() {
                return NBTHelper.getTagCompound(EnergyCapabilityItemStack.this.stack, this.tag);
            }

            public int getEnergyStored() {
                return this.getTag().m_128451_("energy");
            }

            @Override
            public void setEnergy(int energy) {
                this.getTag().m_128405_(this.tag, energy);
                super.setEnergy(energy);
            }
        };
    }

    public EnergyCapabilityItemStack(ItemStack stack, int capacity) {
        this.max = capacity;
        this.stack = stack;
        this.energy = LazyOptional.of(this::createEnergy);
    }

    public String toString() {
        return "EnergyCapabilityItemStack [energy=" + this.energy + ", max=" + this.max + "]";
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (ForgeCapabilities.ENERGY == capability) {
            return this.energy.cast();
        }
        return LazyOptional.empty();
    }
}

