/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.guide_book;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import ru.blatfan.blatapi.common.guide_book.GuideBookPage;
import ru.blatfan.blatapi.common.task.Task;
import ru.blatfan.blatapi.utils.RecipeUtil;
import ru.blatfan.blatapi.utils.collection.Text;

public record GuideBookEntry(Component title, Component description, ItemStack icon, ResourceLocation category, int x, int y, List<GuideBookPage> pages, List<Task> tasks, List<Task> view, boolean advance) {
    public static GuideBookEntry json(JsonElement element) {
        JsonObject json = element.getAsJsonObject();
        Text title = Text.create(json.get("title").getAsString());
        Text description = Text.create(json.get("description").getAsString());
        ItemStack icon = RecipeUtil.itemStackFromJson(json.get("icon").getAsJsonObject());
        ResourceLocation category = ResourceLocation.m_135820_((String)json.get("category").getAsString());
        int x = json.get("x").getAsInt() * 26;
        int y = -json.get("y").getAsInt() * 26;
        boolean adv = json.has("advance") && json.get("advance").getAsBoolean();
        ArrayList<GuideBookPage> pages = new ArrayList<GuideBookPage>();
        for (Object el : json.get("pages").getAsJsonArray()) {
            pages.add(GuideBookPage.json((JsonElement)el));
        }
        ArrayList<Task> tasks = new ArrayList<Task>();
        if (json.has("tasks")) {
            for (JsonElement el : json.get("tasks").getAsJsonArray()) {
                tasks.add(Task.fromJson(el.getAsJsonObject()));
            }
        }
        ArrayList<Task> view = new ArrayList<Task>();
        if (json.has("view")) {
            for (JsonElement el : json.get("view").getAsJsonArray()) {
                view.add(Task.fromJson(el.getAsJsonObject()));
            }
        }
        return new GuideBookEntry(title, description, icon, category, x, y, pages, tasks, view, adv);
    }

    public boolean visible(Player player) {
        if (this.view.isEmpty()) {
            return true;
        }
        for (Task task : this.view) {
            if (task.get(player)) continue;
            return false;
        }
        return true;
    }

    public boolean completed(Player player) {
        if (this.tasks.isEmpty()) {
            return true;
        }
        for (Task task : this.tasks) {
            if (task.get(player)) continue;
            return false;
        }
        return true;
    }
}

