/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.guide_book;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import ru.blatfan.blatapi.BlatApi;
import ru.blatfan.blatapi.client.guide_book.GuideClient;
import ru.blatfan.blatapi.common.BARegistry;
import ru.blatfan.blatapi.common.GuideManager;
import ru.blatfan.blatapi.common.guide_book.GuideBookData;
import ru.blatfan.blatapi.utils.NBTHelper;
import ru.blatfan.blatapi.utils.collection.Text;

public class GuideBookItem
extends Item {
    public static final String TAG = "guide_book_id";

    public GuideBookItem(Item.Properties pProperties) {
        super(pProperties.m_41487_(1));
    }

    public GuideBookItem() {
        this(new Item.Properties());
    }

    public static GuideBookData getBook(ItemStack stack) {
        ResourceLocation res = GuideBookItem.getBookId(stack);
        if (res == null) {
            return null;
        }
        return GuideManager.getBook(res);
    }

    public static ItemStack getBook(ResourceLocation bookId) {
        ItemStack stack = new ItemStack((ItemLike)BARegistry.GUIDE_BOOK.get(), 1);
        NBTHelper.setString(stack, TAG, bookId.toString());
        return stack;
    }

    private static ResourceLocation getBookId(ItemStack stack) {
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_(TAG)) {
            return BlatApi.loc("error");
        }
        String bookStr = stack.m_41783_().m_128461_(TAG);
        return ResourceLocation.m_135820_((String)bookStr);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemInHand = pPlayer.m_21120_(pUsedHand);
        if (pLevel.f_46443_) {
            GuideClient.open(GuideBookItem.getBook(itemInHand));
        }
        return InteractionResultHolder.m_19092_((Object)itemInHand, (boolean)pLevel.f_46443_);
    }

    public Component m_7626_(ItemStack pStack) {
        GuideBookData book = GuideBookItem.getBook(pStack);
        return book.getTitle();
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        GuideBookData book = GuideBookItem.getBook(stack);
        if (book != null) {
            if (flagIn.m_7050_()) {
                tooltip.add((Component)Component.m_237113_((String)"Book ID: ").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)Component.m_237113_((String)GuideBookItem.getBookId(stack).toString()).m_130940_(ChatFormatting.RED)));
            }
            if (!book.getTooltip().equals(Component.m_237119_())) {
                tooltip.add(book.getTooltip());
                tooltip.add((Component)Component.m_237119_());
            }
            tooltip.add(Text.create("guide_book.blatapi.author").add(book.getAuthor()));
        }
    }
}

