/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.guide_book.pages;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import ru.blatfan.blatapi.BlatApi;
import ru.blatfan.blatapi.client.guide_book.GuideClient;
import ru.blatfan.blatapi.common.guide_book.GuideBookPage;
import ru.blatfan.blatapi.common.guide_book.pages.TextPage;
import ru.blatfan.blatapi.utils.ClientTicks;
import ru.blatfan.blatapi.utils.ColorHelper;
import ru.blatfan.blatapi.utils.GuiUtil;
import ru.blatfan.blatapi.utils.collection.SplitText;
import ru.blatfan.blatapi.utils.collection.Text;

public class EntityPage
extends GuideBookPage {
    public static final ResourceLocation TYPE = BlatApi.loc("entity");
    private final ResourceLocation entity;
    private final int scale;
    private final int offsetX;
    private final int offsetY;
    private final Color color;
    private final SplitText texts;

    public EntityPage(Component title, Color titleColor, boolean separator, ResourceLocation entity, int scale, int offsetX, int offsetY, Color color, List<Component> text) {
        super(title, titleColor, separator);
        this.entity = entity;
        this.scale = scale;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.color = color;
        this.texts = !text.isEmpty() ? TextPage.splitText(text, GuideClient.pageWidth - 4, GuideClient.pageHeight - 100) : new SplitText(1.0f);
    }

    public static GuideBookPage json(JsonObject jsonObject) {
        ArrayList<Component> text = new ArrayList<Component>();
        if (jsonObject.has("text")) {
            for (JsonElement element : jsonObject.getAsJsonArray("text")) {
                text.add(Text.create(element.getAsString()));
            }
        }
        return new EntityPage(Text.create(jsonObject.get("title").getAsString()), jsonObject.has("title_color") ? ColorHelper.getColor(jsonObject.get("title_color").getAsString()) : Color.WHITE, jsonObject.has("separator") && jsonObject.get("separator").getAsBoolean(), ResourceLocation.m_135820_((String)jsonObject.get("entity").getAsString()), jsonObject.get("scale").getAsInt(), jsonObject.has("offsetX") ? jsonObject.get("offsetX").getAsInt() : 0, jsonObject.has("offsetY") ? jsonObject.get("offsetY").getAsInt() : 0, jsonObject.has("color") ? ColorHelper.getColor(jsonObject.get("color").getAsString()) : Color.WHITE, text);
    }

    @Override
    protected int height() {
        return this.offsetY + this.texts.height();
    }

    @Override
    protected void render(GuiGraphics gui, int x, int y, int mX, int mY, float partialTick) {
        Font font = GuideClient.font;
        Entity e = ((EntityType)BuiltInRegistries.f_256780_.m_7745_(this.entity)).m_20615_((Level)GuideClient.level);
        if (!(e instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)e;
        living.f_20885_ = 0.0f;
        living.f_20886_ = 0.0f;
        GuiUtil.renderEntityQuaternionf(gui, x + 5 + this.offsetX, y + this.offsetY, this.scale, Axis.f_252436_.m_252977_((float)ClientTicks.ticks), Axis.f_252529_.m_252977_(180.0f), living);
        gui.m_280509_(x + 4, y, x + 4, y + 10, 0xFFFFFF);
        for (int i = 0; i < this.texts.size(); ++i) {
            String c = (String)this.texts.get(i);
            Objects.requireNonNull(font);
            int ty = this.offsetY + y + 2 + 9 * i;
            GuiUtil.drawScaledString(gui, c, x + 4, ty, this.color, this.texts.scale());
        }
    }
}

