/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.guide_book.pages;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector4f;
import ru.blatfan.blatapi.BlatApi;
import ru.blatfan.blatapi.api.multiblock.Multiblock;
import ru.blatfan.blatapi.client.guide_book.GuideClient;
import ru.blatfan.blatapi.client.render.FluidBlockVertexConsumer;
import ru.blatfan.blatapi.client.render.MultiblockPreviewRenderer;
import ru.blatfan.blatapi.common.GuideManager;
import ru.blatfan.blatapi.common.guide_book.GuideBookPage;
import ru.blatfan.blatapi.common.guide_book.pages.TextPage;
import ru.blatfan.blatapi.utils.ClientTicks;
import ru.blatfan.blatapi.utils.ColorHelper;
import ru.blatfan.blatapi.utils.GuiUtil;
import ru.blatfan.blatapi.utils.collection.SplitText;
import ru.blatfan.blatapi.utils.collection.Text;

public class MultiblockPage
extends GuideBookPage {
    public static final ResourceLocation TYPE = BlatApi.loc("multiblock");
    private final ResourceLocation multiblock;
    private final float scale;
    private final int buttonY;
    private final Color color;
    private final SplitText texts;
    private int _buttonX;
    private int _buttonY;
    private final Map<BlockPos, BlockEntity> blockEntityCache = new Object2ObjectOpenHashMap();
    private final Set<BlockEntity> erroredBlockEntities = Collections.newSetFromMap(new WeakHashMap());
    protected Pair<BlockPos, Collection<Multiblock.SimulateResult>> multiblockSimulation;

    public MultiblockPage(Component title, Color titleColor, boolean separator, ResourceLocation multiblock, float scale, int buttonY, Color color, List<Component> text) {
        super(title, titleColor, separator);
        this.multiblock = multiblock;
        this.scale = scale;
        this.buttonY = buttonY;
        this.color = color;
        this.texts = !text.isEmpty() ? TextPage.splitText(text, GuideClient.pageWidth - 4, GuideClient.pageHeight - 100) : new SplitText(1.0f);
    }

    public static GuideBookPage json(JsonObject jsonObject) {
        ArrayList<Component> text = new ArrayList<Component>();
        if (jsonObject.has("text")) {
            for (JsonElement element : jsonObject.getAsJsonArray("text")) {
                text.add(Text.create(element.getAsString()));
            }
        }
        return new MultiblockPage(Text.create(jsonObject.get("title").getAsString()), jsonObject.has("title_color") ? ColorHelper.getColor(jsonObject.get("title_color").getAsString()) : Color.WHITE, jsonObject.has("separator") && jsonObject.get("separator").getAsBoolean(), ResourceLocation.m_135820_((String)jsonObject.get("multiblock").getAsString()), jsonObject.has("scale") ? jsonObject.get("scale").getAsFloat() : 1.0f, jsonObject.get("buttonY").getAsInt(), jsonObject.has("color") ? ColorHelper.getColor(jsonObject.get("color").getAsString()) : Color.WHITE, text);
    }

    public Multiblock getMultiblock() {
        return GuideManager.getMultiblock(this.multiblock);
    }

    @Override
    protected int height() {
        return this.buttonY + 7 + this.texts.height();
    }

    @Override
    protected void render(GuiGraphics gui, int x, int y, int mX, int mY, float partialTick) {
        this.blockEntityCache.clear();
        this.blockEntityCache.putAll(MultiblockPreviewRenderer.blockEntityCache);
        this.erroredBlockEntities.clear();
        this.erroredBlockEntities.addAll(MultiblockPreviewRenderer.erroredBlockEntities);
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        pose.m_252880_((float)x, (float)y, 0.0f);
        pose.m_85841_(this.scale, this.scale, this.scale);
        this.renderMultiblock(gui);
        pose.m_85849_();
        Multiblock preview = MultiblockPreviewRenderer.getMultiblock();
        this._buttonX = x + 104;
        this._buttonY = y + this.buttonY;
        if (preview == null || !preview.getId().equals((Object)this.multiblock)) {
            gui.m_280218_(GuideClient.guideBookData.getTexture(), this._buttonX, this._buttonY, 22, 70, 11, 7);
        } else {
            gui.m_280218_(GuideClient.guideBookData.getTexture(), this._buttonX, this._buttonY, 22, 77, 11, 7);
        }
        for (int i = 0; i < this.texts.size(); ++i) {
            String c = (String)this.texts.get(i);
            Objects.requireNonNull(GuideClient.font);
            int ty = this._buttonY + 7 + 9 * i;
            GuiUtil.drawScaledString(gui, c, x + 4, ty, this.color, this.texts.scale());
        }
    }

    @Override
    public boolean mouseClicked(double mX, double mY, int button) {
        Multiblock preview = MultiblockPreviewRenderer.getMultiblock();
        if (mX >= (double)this._buttonX && mX <= (double)(this._buttonX + 11) && mY >= (double)this._buttonY && mY <= (double)(this._buttonY + 7) && button == 0) {
            if (preview == null || !preview.getId().equals((Object)this.multiblock)) {
                Minecraft.m_91087_().m_91152_(null);
                MultiblockPreviewRenderer.setMultiblock(this.getMultiblock(), Text.create(this.getTitle()).withColor(this.getTitleColor()), false);
                return true;
            }
            MultiblockPreviewRenderer.setMultiblock(null, Text.create(this.getTitle()).withColor(this.getTitleColor()), false);
            return true;
        }
        return false;
    }

    private void renderMultiblock(GuiGraphics gui) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        float time = ClientTicks.ticks;
        BlockPos pos = BlockPos.f_121853_;
        Rotation facingRotation = Rotation.NONE;
        this.getMultiblock().setLevel((Level)level);
        Vec3i size = this.getMultiblock().getSize();
        int sizeX = size.m_123341_();
        int sizeY = size.m_123342_();
        int sizeZ = size.m_123343_();
        float maxX = 70.0f;
        float maxY = 70.0f;
        float diag = (float)Math.sqrt(sizeX * sizeX + sizeZ * sizeZ);
        float scaleX = maxX / diag;
        float scaleY = maxY / (float)sizeY;
        float scale = -Math.min(scaleX, scaleY);
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        pose.m_252880_(maxX, maxY / 2.0f, 100.0f);
        pose.m_85841_(scale, scale, scale);
        pose.m_252880_(-((float)sizeX) / 2.0f, -((float)sizeY) / 2.0f, 0.0f);
        Vector4f eye = new Vector4f(0.0f, 0.0f, -100.0f, 1.0f);
        Matrix4f rotMat = new Matrix4f();
        rotMat.identity();
        pose.m_252781_(Axis.f_252529_.m_252977_(-30.0f));
        rotMat.rotate((Quaternionfc)Axis.f_252529_.m_252977_(30.0f));
        float offX = (float)(-sizeX) / 2.0f;
        float offZ = (float)(-sizeZ) / 2.0f + 1.0f;
        pose.m_252880_(-offX, 0.0f, -offZ);
        pose.m_252781_(Axis.f_252436_.m_252977_(time));
        rotMat.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-time));
        pose.m_252781_(Axis.f_252436_.m_252977_(45.0f));
        rotMat.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-45.0f));
        pose.m_252880_(offX, 0.0f, offZ);
        rotMat.transform(eye);
        eye.div(eye.w);
        MultiBufferSource.BufferSource buffers = mc.m_91269_().m_110104_();
        BlockPos checkPos = null;
        HitResult hitResult = mc.f_91077_;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockRes = (BlockHitResult)hitResult;
            checkPos = blockRes.m_82425_().m_121945_(blockRes.m_82434_());
        }
        pose.m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        pose.m_252880_(0.0f, 0.0f, -1.0f);
        if (this.multiblockSimulation == null) {
            this.multiblockSimulation = this.getMultiblock().simulate((Level)level, pos, facingRotation, false, false);
        }
        for (Multiblock.SimulateResult r : (Collection)this.multiblockSimulation.getSecond()) {
            float alpha = 0.3f;
            if (r.getWorldPosition().equals((Object)checkPos)) {
                alpha = 0.6f + (float)(Math.sin(ClientTicks.total * 0.3f) + 1.0) * 0.1f;
            }
            BlockState renderState = r.getStateMatcher().getDisplayedState(ClientTicks.ticks).m_60717_(facingRotation);
            this.renderBlock(buffers, level, renderState, r.getWorldPosition(), alpha, pose);
            Block block = renderState.m_60734_();
            if (!(block instanceof EntityBlock)) continue;
            EntityBlock eb = (EntityBlock)block;
            BlockEntity be = this.blockEntityCache.computeIfAbsent(r.getWorldPosition().m_7949_(), p -> eb.m_142194_(p, renderState));
            if (be == null || this.erroredBlockEntities.contains(be)) continue;
            be.m_142339_((Level)level);
            be.m_155250_(renderState);
            pose.m_85836_();
            BlockPos bePos = r.getWorldPosition();
            pose.m_252880_((float)bePos.m_123341_(), (float)bePos.m_123342_(), (float)bePos.m_123343_());
            try {
                BlockEntityRenderer renderer = Minecraft.m_91087_().m_167982_().m_112265_(be);
                if (renderer != null) {
                    renderer.m_6922_(be, ClientTicks.partialTicks, pose, (MultiBufferSource)buffers, GuiUtil.FULL_BRIGHT, OverlayTexture.f_118083_);
                }
            }
            catch (Exception e) {
                this.erroredBlockEntities.add(be);
                BlatApi.LOGGER.error("Error rendering block entity", (Throwable)e);
            }
            pose.m_85849_();
        }
        pose.m_85849_();
        buffers.m_109911_();
        pose.m_85849_();
    }

    private void renderBlock(MultiBufferSource.BufferSource buffers, ClientLevel level, BlockState state, BlockPos pos, float alpha, PoseStack ps) {
        if (pos != null) {
            ps.m_85836_();
            ps.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
            BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
            FluidState fluidState = state.m_60819_();
            if (!fluidState.m_76178_()) {
                RenderType layer = ItemBlockRenderTypes.m_109287_((FluidState)fluidState);
                VertexConsumer buffer = buffers.m_6299_(layer);
                blockRenderer.m_234363_(pos, (BlockAndTintGetter)this.getMultiblock(), (VertexConsumer)new FluidBlockVertexConsumer(buffer, ps, pos), state, fluidState);
            }
            if (state.m_60799_() != RenderShape.INVISIBLE) {
                BakedModel model = blockRenderer.m_110910_(state);
                for (RenderType layer : model.getRenderTypes(state, level.f_46441_, ModelData.EMPTY)) {
                    VertexConsumer buffer = buffers.m_6299_(layer);
                    blockRenderer.renderBatched(state, pos, (BlockAndTintGetter)this.getMultiblock(), ps, buffer, false, level.f_46441_, ModelData.EMPTY, layer);
                }
            }
            ps.m_85849_();
        }
    }
}

