/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.guide_book.pages;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import ru.blatfan.blatapi.BlatApi;
import ru.blatfan.blatapi.client.guide_book.GuideClient;
import ru.blatfan.blatapi.common.guide_book.GuideBookPage;
import ru.blatfan.blatapi.utils.ColorHelper;
import ru.blatfan.blatapi.utils.GuiUtil;
import ru.blatfan.blatapi.utils.collection.SplitText;
import ru.blatfan.blatapi.utils.collection.Text;

public class TextPage
extends GuideBookPage {
    public static final ResourceLocation TYPE = BlatApi.loc("text");
    private final Color color;
    private final SplitText texts;

    public TextPage(Component title, Color titleColor, boolean separator, List<Component> text, Color color) {
        super(title, titleColor, separator);
        this.color = color;
        this.texts = TextPage.splitText(text, GuideClient.pageWidth - 12, GuideClient.pageHeight - 10);
    }

    public static GuideBookPage json(JsonObject jsonObject) {
        ArrayList<Component> text = new ArrayList<Component>();
        for (JsonElement element : jsonObject.getAsJsonArray("text")) {
            text.add(Text.create(element.getAsString()));
        }
        return new TextPage(Text.create(jsonObject.get("title").getAsString()), jsonObject.has("title_color") ? ColorHelper.getColor(jsonObject.get("title_color").getAsString()) : Color.WHITE, jsonObject.has("separator") && jsonObject.get("separator").getAsBoolean(), text, jsonObject.has("color") ? ColorHelper.getColor(jsonObject.get("color").getAsString()) : Color.WHITE);
    }

    public static SplitText splitText(List<Component> text, int width, int height) {
        return GuiUtil.splitText(GuiUtil.toString(text), width, TextPage.findOptimalScale(text, width, height));
    }

    public static float findOptimalScale(List<Component> text, int width, int height) {
        float high;
        float low = 0.01f;
        float bestScale = high = 1.0f;
        String textString = GuiUtil.toString(text);
        for (int i = 0; i < 20; ++i) {
            float mid = (low + high) / 2.0f;
            SplitText lines = GuiUtil.splitText(textString, width, mid);
            float textHeight = (float)(lines.size() * 9) * mid;
            if (textHeight <= (float)height) {
                bestScale = mid;
                low = mid;
            } else {
                high = mid;
            }
            if (high - low < 0.01f) break;
        }
        return bestScale;
    }

    @Override
    public int height() {
        return this.texts.height();
    }

    @Override
    public void render(GuiGraphics gui, int x, int y, int mX, int mY, float partialTick) {
        Font font = GuideClient.font;
        for (int i = 0; i < this.texts.size(); ++i) {
            String t = (String)this.texts.get(i);
            Objects.requireNonNull(font);
            int ty = y + (int)((float)(9 * i) * this.texts.scale());
            GuiUtil.drawScaledString(gui, t, x + 8, ty, this.color, this.texts.scale());
        }
    }
}

