/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.multiblock;

import com.google.gson.JsonObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import ru.blatfan.blatapi.BlatApi;
import ru.blatfan.blatapi.api.multiblock.StateMatcher;
import ru.blatfan.blatapi.api.multiblock.TriPredicate;
import ru.blatfan.blatapi.common.multiblock.matcher.AnyMatcher;
import ru.blatfan.blatapi.common.multiblock.matcher.BlockMatcher;
import ru.blatfan.blatapi.common.multiblock.matcher.BlockStateMatcher;
import ru.blatfan.blatapi.common.multiblock.matcher.BlockStatePropertyMatcher;
import ru.blatfan.blatapi.common.multiblock.matcher.DisplayOnlyMatcher;
import ru.blatfan.blatapi.common.multiblock.matcher.Matchers;
import ru.blatfan.blatapi.common.multiblock.matcher.PredicateMatcher;
import ru.blatfan.blatapi.common.multiblock.matcher.TagMatcher;

public class MultiBlockData {
    private static final Map<ResourceLocation, Function<JsonObject, StateMatcher>> stateMatcherJsonLoaders = new ConcurrentHashMap<ResourceLocation, Function<JsonObject, StateMatcher>>();
    private static final Map<ResourceLocation, TriPredicate<BlockGetter, BlockPos, BlockState>> predicates = new ConcurrentHashMap<ResourceLocation, TriPredicate<BlockGetter, BlockPos, BlockState>>();

    public static void registerStateMatcherLoader(ResourceLocation id, Function<JsonObject, StateMatcher> jsonLoader) {
        stateMatcherJsonLoaders.put(id, jsonLoader);
    }

    public static Function<JsonObject, StateMatcher> getStateMatcherJsonLoader(ResourceLocation id) {
        Function<JsonObject, StateMatcher> loader = stateMatcherJsonLoaders.get(id);
        if (loader == null) {
            throw new IllegalArgumentException("No json loader registered for state matcher type " + id);
        }
        return loader;
    }

    public static void registerPredicate(ResourceLocation id, TriPredicate<BlockGetter, BlockPos, BlockState> predicate) {
        predicates.put(id, predicate);
    }

    public static TriPredicate<BlockGetter, BlockPos, BlockState> getPredicate(ResourceLocation id) {
        TriPredicate<BlockGetter, BlockPos, BlockState> predicate = predicates.get(id);
        if (predicate == null) {
            throw new IllegalArgumentException("No predicated registered for id " + id);
        }
        return predicate;
    }

    public static void init() {
        MultiBlockData.registerStateMatcherLoader(AnyMatcher.TYPE, AnyMatcher::fromJson);
        MultiBlockData.registerStateMatcherLoader(BlockMatcher.TYPE, BlockMatcher::fromJson);
        MultiBlockData.registerStateMatcherLoader(BlockStateMatcher.TYPE, BlockStateMatcher::fromJson);
        MultiBlockData.registerStateMatcherLoader(BlockStatePropertyMatcher.TYPE, BlockStatePropertyMatcher::fromJson);
        MultiBlockData.registerStateMatcherLoader(DisplayOnlyMatcher.TYPE, DisplayOnlyMatcher::fromJson);
        MultiBlockData.registerStateMatcherLoader(PredicateMatcher.TYPE, PredicateMatcher::fromJson);
        MultiBlockData.registerStateMatcherLoader(TagMatcher.TYPE, TagMatcher::fromJson);
        MultiBlockData.registerPredicate(Matchers.AIR.getPredicateId(), (getter, pos, state) -> state.m_60795_());
        MultiBlockData.registerPredicate(BlatApi.loc("non_solid"), (getter, pos, state) -> !state.m_280296_());
    }
}

