/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.multiblock.matcher;

import com.google.common.base.Suppliers;
import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import ru.blatfan.blatapi.BlatApi;
import ru.blatfan.blatapi.api.multiblock.StateMatcher;
import ru.blatfan.blatapi.api.multiblock.TriPredicate;
import ru.blatfan.blatapi.common.multiblock.matcher.TagMatcher;

public class BlockStatePropertyMatcher
implements StateMatcher {
    public static final ResourceLocation TYPE = BlatApi.loc("blockstateproperty");
    private final BlockState displayState;
    private final Block block;
    private final Supplier<Map<String, String>> props;
    private final TriPredicate<BlockGetter, BlockPos, BlockState> predicate;

    protected BlockStatePropertyMatcher(BlockState displayState, Block block, Supplier<Map<String, String>> props) {
        this.displayState = displayState;
        this.block = block;
        this.props = props;
        this.predicate = (blockGetter, blockPos, blockState) -> blockState.m_60734_() == block && TagMatcher.checkProps(blockState, this.props);
    }

    public static BlockStatePropertyMatcher fromJson(JsonObject json) {
        BlockState displayState = null;
        if (json.has("display")) {
            try {
                displayState = BlockStateParser.m_234691_((HolderLookup)BuiltInRegistries.f_256975_.m_255303_(), (StringReader)new StringReader(GsonHelper.m_13906_((JsonObject)json, (String)"display")), (boolean)false).f_234748_();
            }
            catch (CommandSyntaxException e) {
                throw new IllegalArgumentException("Failed to parse BlockState from json member \"display\" for BlockStatePropertyMatcher.", e);
            }
        }
        try {
            BlockStateParser.BlockResult result = BlockStateParser.m_234691_((HolderLookup)BuiltInRegistries.f_256975_.m_255303_(), (StringReader)new StringReader(GsonHelper.m_13906_((JsonObject)json, (String)"block")), (boolean)false);
            Map<String, String> props = BlockStatePropertyMatcher.convertProps(result.f_234749_());
            return new BlockStatePropertyMatcher(displayState, result.f_234748_().m_60734_(), (Supplier<Map<String, String>>)Suppliers.memoize(() -> props));
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Failed to parse BlockState from json member \"block\" for BlockStatePropertyMatcher.", e);
        }
    }

    private static Map<String, String> convertProps(Map<Property<?>, Comparable<?>> props) {
        Object2ObjectOpenHashMap newProps = new Object2ObjectOpenHashMap();
        for (Map.Entry<Property<?>, Comparable<?>> entry : props.entrySet()) {
            BlockStatePropertyMatcher.appendProperty((Map<String, String>)newProps, entry.getKey(), entry.getValue());
        }
        return newProps;
    }

    private static <T extends Comparable<T>> void appendProperty(Map<String, String> properties, Property<T> pProperty, Comparable<?> pValue) {
        properties.put(pProperty.m_61708_(), pProperty.m_6940_(pValue));
    }

    @Override
    public ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public BlockState getDisplayedState(long ticks) {
        return this.displayState == null ? this.block.m_49966_() : this.displayState;
    }

    @Override
    public TriPredicate<BlockGetter, BlockPos, BlockState> getStatePredicate() {
        return this.predicate;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.displayState != null);
        if (this.displayState != null) {
            buffer.m_130070_(BlockStateParser.m_116769_((BlockState)this.displayState));
        }
        buffer.m_130085_(BuiltInRegistries.f_256975_.m_7981_((Object)this.block));
        buffer.m_236831_(this.props.get(), FriendlyByteBuf::m_130070_, FriendlyByteBuf::m_130070_);
    }

    @Override
    public boolean countsTowardsTotalBlocks() {
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.block, this.displayState, this.props);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockStatePropertyMatcher that = (BlockStatePropertyMatcher)o;
        return this.block.equals(that.block) && this.props.equals(that.props) && this.displayState.equals(that.displayState);
    }
}

