/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.player_stages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import ru.blatfan.blatapi.BlatApi;
import ru.blatfan.blatapi.common.player_stages.PlayerStageEvent;
import ru.blatfan.blatapi.common.player_stages.PlayerStagesProvider;
import ru.blatfan.blatapi.common.player_stages.PlayerStagesSync;
import ru.blatfan.blatapi.fluffy_fur.common.network.FluffyFurPacketHandler;
import ru.blatfan.blatapi.utils.ICapacity;

public class PlayerStages
implements ICapacity<PlayerStages> {
    public static final List<String> allStages = new ArrayList<String>();
    private final Map<String, Value<?>> DATA = new HashMap();

    private static <T> Value<T> sendSetEvent(Player player, String key, Value<T> value) {
        PlayerStageEvent.Set<T> event = new PlayerStageEvent.Set<T>(player, key, value);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getValue();
    }

    private static boolean sendRemEvent(Player player, String key) {
        PlayerStageEvent.Remove event = new PlayerStageEvent.Remove(player, key);
        return !MinecraftForge.EVENT_BUS.post((Event)event);
    }

    @Override
    public void sync(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            FluffyFurPacketHandler.sendTo(player, (Object)new PlayerStagesSync(this));
        }
    }

    public Map<String, Value<?>> getAll() {
        return Collections.unmodifiableMap(this.DATA);
    }

    public static PlayerStages get(Player player) {
        return (PlayerStages)player.getCapability(PlayerStagesProvider.CAPABILITY, null).orElse((Object)new PlayerStages());
    }

    public static boolean has(Player player, String key) {
        return PlayerStages.get((Player)player).DATA.containsKey(key);
    }

    public static Object get(Player player, String key, Class<Object> clazz) {
        PlayerStages stages = PlayerStages.get(player);
        if (stages.DATA.get(key).isSimilar(clazz)) {
            return stages.DATA.get(key).getValue();
        }
        return null;
    }

    public static void set(Player player, String key, Object value) {
        if (!allStages.contains(key)) {
            allStages.add(key);
        }
        if (Value.getDes(value.getClass()) == null) {
            return;
        }
        player.getCapability(PlayerStagesProvider.CAPABILITY, null).ifPresent(playerStages -> {
            playerStages.DATA.put(key, PlayerStages.sendSetEvent(player, key, Value.getDes(value.getClass()).apply(value)));
            playerStages.sync((Entity)player);
        });
    }

    public static void set(Player player, String key, Value<?> value) {
        if (!allStages.contains(key)) {
            allStages.add(key);
        }
        player.getCapability(PlayerStagesProvider.CAPABILITY, null).ifPresent(playerStages -> {
            playerStages.DATA.put(key, PlayerStages.sendSetEvent(player, key, value));
            playerStages.sync((Entity)player);
        });
    }

    public static int getInt(Player player, String key) {
        PlayerStages stages = PlayerStages.get(player);
        Value<?> value = stages.DATA.get(key);
        if (value instanceof IntValue) {
            IntValue val = (IntValue)value;
            return (Integer)val.getValue();
        }
        return 0;
    }

    public static void setInt(Player player, String key, int value) {
        if (!allStages.contains(key)) {
            allStages.add(key);
        }
        player.getCapability(PlayerStagesProvider.CAPABILITY, null).ifPresent(playerStages -> {
            playerStages.DATA.put(key, PlayerStages.sendSetEvent(player, key, new IntValue(value)));
            playerStages.sync((Entity)player);
        });
    }

    public static double getDouble(Player player, String key) {
        PlayerStages stages = PlayerStages.get(player);
        Value<?> value = stages.DATA.get(key);
        if (value instanceof DoubleValue) {
            DoubleValue val = (DoubleValue)value;
            return (Double)val.getValue();
        }
        return 0.0;
    }

    public static void setDouble(Player player, String key, double value) {
        if (!allStages.contains(key)) {
            allStages.add(key);
        }
        player.getCapability(PlayerStagesProvider.CAPABILITY, null).ifPresent(playerStages -> {
            playerStages.DATA.put(key, PlayerStages.sendSetEvent(player, key, new DoubleValue(value)));
            playerStages.sync((Entity)player);
        });
    }

    public static float getFloat(Player player, String key) {
        PlayerStages stages = PlayerStages.get(player);
        Value<?> value = stages.DATA.get(key);
        if (value instanceof FloatValue) {
            FloatValue val = (FloatValue)value;
            return ((Float)val.getValue()).floatValue();
        }
        return 0.0f;
    }

    public static void setFloat(Player player, String key, float value) {
        if (!allStages.contains(key)) {
            allStages.add(key);
        }
        player.getCapability(PlayerStagesProvider.CAPABILITY, null).ifPresent(playerStages -> {
            playerStages.DATA.put(key, PlayerStages.sendSetEvent(player, key, new FloatValue(Float.valueOf(value))));
            playerStages.sync((Entity)player);
        });
    }

    public static String getString(Player player, String key) {
        PlayerStages stages = PlayerStages.get(player);
        Value<?> value = stages.DATA.get(key);
        if (value instanceof StringValue) {
            StringValue val = (StringValue)value;
            return (String)val.getValue();
        }
        return "";
    }

    public static void setString(Player player, String key, String value) {
        if (!allStages.contains(key)) {
            allStages.add(key);
        }
        player.getCapability(PlayerStagesProvider.CAPABILITY, null).ifPresent(playerStages -> {
            playerStages.DATA.put(key, PlayerStages.sendSetEvent(player, key, new StringValue(value)));
            playerStages.sync((Entity)player);
        });
    }

    public static long getLong(Player player, String key) {
        PlayerStages stages = PlayerStages.get(player);
        Value<?> value = stages.DATA.get(key);
        if (value instanceof LongValue) {
            LongValue val = (LongValue)value;
            return (Long)val.getValue();
        }
        return 0L;
    }

    public static void setLong(Player player, String key, long value) {
        if (!allStages.contains(key)) {
            allStages.add(key);
        }
        player.getCapability(PlayerStagesProvider.CAPABILITY, null).ifPresent(playerStages -> {
            playerStages.DATA.put(key, PlayerStages.sendSetEvent(player, key, new LongValue(value)));
            playerStages.sync((Entity)player);
        });
    }

    public static boolean getBool(Player player, String key) {
        PlayerStages stages = PlayerStages.get(player);
        Value<?> value = stages.DATA.get(key);
        if (value instanceof BooleanValue) {
            BooleanValue val = (BooleanValue)value;
            return (Boolean)val.getValue();
        }
        return false;
    }

    public static void setBool(Player player, String key, boolean value) {
        if (!allStages.contains(key)) {
            allStages.add(key);
        }
        player.getCapability(PlayerStagesProvider.CAPABILITY, null).ifPresent(playerStages -> {
            playerStages.DATA.put(key, PlayerStages.sendSetEvent(player, key, new BooleanValue(value)));
            playerStages.sync((Entity)player);
        });
    }

    public static CompoundTag getCompoundTag(Player player, String key) {
        PlayerStages stages = PlayerStages.get(player);
        Value<?> value = stages.DATA.get(key);
        if (value instanceof CompoundTagValue) {
            CompoundTagValue val = (CompoundTagValue)value;
            return (CompoundTag)val.getValue();
        }
        return null;
    }

    public static void setCompoundTag(Player player, String key, CompoundTag value) {
        if (!allStages.contains(key)) {
            allStages.add(key);
        }
        player.getCapability(PlayerStagesProvider.CAPABILITY, null).ifPresent(playerStages -> {
            playerStages.DATA.put(key, PlayerStages.sendSetEvent(player, key, new CompoundTagValue(value)));
            playerStages.sync((Entity)player);
        });
    }

    public static void remove(Player player, String key) {
        if (PlayerStages.sendRemEvent(player, key)) {
            player.getCapability(PlayerStagesProvider.CAPABILITY, null).ifPresent(playerStages -> {
                playerStages.DATA.remove(key);
                playerStages.sync((Entity)player);
            });
        }
    }

    @Override
    public Tag toNBT() {
        CompoundTag nbt = new CompoundTag();
        for (String key : this.DATA.keySet()) {
            Value<?> value = this.DATA.get(key);
            if (value == null) continue;
            CompoundTag vt = value.serializeNBT();
            vt.m_128359_("type", value.getType().toString());
            nbt.m_128365_(key, (Tag)vt);
        }
        return nbt;
    }

    @Override
    public void fromNBT(Tag tag) {
        this.DATA.clear();
        CompoundTag nbt = (CompoundTag)tag;
        for (String key : nbt.m_128431_()) {
            CompoundTag nbtM = nbt.m_128469_(key);
            ResourceLocation type = ResourceLocation.m_135820_((String)nbtM.m_128461_("type"));
            this.DATA.put(key, Value.deserialize(type, nbtM));
        }
    }

    @Override
    public void copy(PlayerStages instance) {
        this.DATA.clear();
        for (String key : instance.DATA.keySet()) {
            this.DATA.put(key, instance.DATA.get(key));
        }
    }

    @Override
    public PlayerStages clone() {
        PlayerStages instance = new PlayerStages();
        instance.copy(this);
        return instance;
    }

    public static abstract class Value<T>
    implements Predicate<Object>,
    Function<Object, Value<?>> {
        private final T value;
        private final Class<T> clazz;
        private final ResourceLocation type;
        private static final Map<Predicate<Object>, Function<Object, Value<?>>> TYPES = new LinkedHashMap();

        protected Value(ResourceLocation type, T value, Class<T> clazz) {
            this.value = value;
            this.type = type;
            this.clazz = clazz;
            TYPES.put(this, this);
        }

        @Override
        public Value<T> apply(Object o) {
            if (o instanceof CompoundTag) {
                CompoundTag tag = (CompoundTag)o;
                return this.deserializeNBT(tag);
            }
            return this.fromValue(o);
        }

        @Override
        public boolean test(Object o) {
            if (o instanceof ResourceLocation) {
                ResourceLocation rl = (ResourceLocation)o;
                return this.isSimilar(rl);
            }
            if (o instanceof Class) {
                Class tClass = (Class)o;
                return this.isSimilar(tClass);
            }
            return false;
        }

        public <V> boolean isSimilar(Class<V> oClazz) {
            return this.clazz.equals(oClazz);
        }

        public boolean isSimilar(ResourceLocation oType) {
            return this.type.equals((Object)oType);
        }

        public abstract CompoundTag serializeNBT();

        protected abstract Value<T> deserializeNBT(CompoundTag var1);

        protected abstract Value<T> fromValue(Object var1);

        public static Value<?> deserialize(ResourceLocation type, CompoundTag nbt) {
            if (Value.getDes(type) != null) {
                return Value.getDes(type).apply(nbt);
            }
            return null;
        }

        public static Map<Predicate<Object>, Function<Object, Value<?>>> types() {
            return Collections.unmodifiableMap(TYPES);
        }

        public static Function<Object, Value<?>> getDes(Object type) {
            for (Predicate<Object> pr : Value.types().keySet()) {
                if (!pr.test(type)) continue;
                return Value.types().get(pr);
            }
            return null;
        }

        public T getValue() {
            return this.value;
        }

        public Class<T> getClazz() {
            return this.clazz;
        }

        public ResourceLocation getType() {
            return this.type;
        }
    }

    public static class IntValue
    extends Value<Integer> {
        public IntValue(Integer value) {
            super(BlatApi.loc("int"), value, Integer.class);
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("value", ((Integer)this.getValue()).intValue());
            return tag;
        }

        @Override
        protected Value<Integer> deserializeNBT(CompoundTag nbt) {
            return new IntValue(nbt.m_128451_("value"));
        }

        @Override
        protected Value<Integer> fromValue(Object value) {
            if (value instanceof Integer) {
                Integer v = (Integer)value;
                return new IntValue(v);
            }
            return null;
        }
    }

    public static class DoubleValue
    extends Value<Double> {
        public DoubleValue(Double value) {
            super(BlatApi.loc("double"), value, Double.class);
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128347_("value", ((Double)this.getValue()).doubleValue());
            return tag;
        }

        @Override
        protected Value<Double> deserializeNBT(CompoundTag nbt) {
            return new DoubleValue(nbt.m_128459_("value"));
        }

        @Override
        protected Value<Double> fromValue(Object value) {
            if (value instanceof Double) {
                Double v = (Double)value;
                return new DoubleValue(v);
            }
            return null;
        }
    }

    public static class FloatValue
    extends Value<Float> {
        public FloatValue(Float value) {
            super(BlatApi.loc("float"), value, Float.class);
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128350_("value", ((Float)this.getValue()).floatValue());
            return tag;
        }

        @Override
        protected Value<Float> deserializeNBT(CompoundTag nbt) {
            return new FloatValue(Float.valueOf(nbt.m_128457_("value")));
        }

        @Override
        protected Value<Float> fromValue(Object value) {
            if (value instanceof Float) {
                Float v = (Float)value;
                return new FloatValue(v);
            }
            return null;
        }
    }

    public static class StringValue
    extends Value<String> {
        public StringValue(String value) {
            super(BlatApi.loc("string"), value, String.class);
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("value", (String)this.getValue());
            return tag;
        }

        @Override
        protected Value<String> deserializeNBT(CompoundTag nbt) {
            return new StringValue(nbt.m_128461_("value"));
        }

        @Override
        protected Value<String> fromValue(Object value) {
            if (value instanceof String) {
                String v = (String)value;
                return new StringValue(v);
            }
            return null;
        }
    }

    public static class LongValue
    extends Value<Long> {
        public LongValue(Long value) {
            super(BlatApi.loc("long"), value, Long.class);
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128356_("value", ((Long)this.getValue()).longValue());
            return tag;
        }

        @Override
        protected Value<Long> deserializeNBT(CompoundTag nbt) {
            return new LongValue(nbt.m_128454_("value"));
        }

        @Override
        protected Value<Long> fromValue(Object value) {
            if (value instanceof Long) {
                Long v = (Long)value;
                return new LongValue(v);
            }
            return null;
        }
    }

    public static class BooleanValue
    extends Value<Boolean> {
        public BooleanValue(Boolean value) {
            super(BlatApi.loc("boolean"), value, Boolean.class);
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("value", ((Boolean)this.getValue()).booleanValue());
            return tag;
        }

        @Override
        protected Value<Boolean> deserializeNBT(CompoundTag nbt) {
            return new BooleanValue(nbt.m_128471_("value"));
        }

        @Override
        protected Value<Boolean> fromValue(Object value) {
            if (value instanceof Boolean) {
                Boolean v = (Boolean)value;
                return new BooleanValue(v);
            }
            return null;
        }
    }

    public static class CompoundTagValue
    extends Value<CompoundTag> {
        public CompoundTagValue(CompoundTag value) {
            super(BlatApi.loc("compound_tag"), value, CompoundTag.class);
        }

        @Override
        public CompoundTag serializeNBT() {
            return (CompoundTag)this.getValue();
        }

        @Override
        protected Value<CompoundTag> deserializeNBT(CompoundTag nbt) {
            return new CompoundTagValue(nbt);
        }

        @Override
        protected Value<CompoundTag> fromValue(Object value) {
            if (value instanceof CompoundTag) {
                CompoundTag v = (CompoundTag)value;
                return new CompoundTagValue(v);
            }
            return null;
        }
    }
}

