/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.player_stages;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import ru.blatfan.blatapi.BlatApi;
import ru.blatfan.blatapi.common.player_stages.PlayerStages;
import ru.blatfan.blatapi.common.player_stages.PlayerStagesProvider;
import ru.blatfan.blatapi.common.task.CraftTask;
import ru.blatfan.blatapi.common.task.KillTask;

public class PlayerStagesEvents {
    @SubscribeEvent
    public static void onPlayerCraft(PlayerEvent.ItemCraftedEvent event) {
        Item item = event.getCrafting().m_41720_();
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (PlayerStages.allStages.contains(CraftTask.getStage((ItemLike)item))) {
            PlayerStages.setBool(event.getEntity(), CraftTask.getStage((ItemLike)item), true);
        }
    }

    @SubscribeEvent
    public static void onPlayerKill(LivingDeathEvent event) {
        DamageSource source = event.getSource();
        LivingEntity entity = event.getEntity();
        if (!source.m_276093_(DamageTypes.f_268464_)) {
            return;
        }
        Entity entity2 = source.m_7640_();
        if (entity2 instanceof Player) {
            Player player = (Player)entity2;
            if (PlayerStages.allStages.contains(KillTask.getStage(entity.m_6095_()))) {
                PlayerStages.setBool(player, KillTask.getStage(entity.m_6095_()), true);
            }
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
            event.addCapability(BlatApi.loc("player_stages"), (ICapabilityProvider)new PlayerStagesProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerLogged(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getEntity().m_9236_().m_5776_()) {
            PlayerStages.get(event.getEntity()).sync((Entity)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawned(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.getEntity().m_9236_().m_5776_()) {
            PlayerStages.get(event.getEntity()).sync((Entity)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.getEntity().m_9236_().m_5776_()) {
            PlayerStages.get(event.getEntity()).sync((Entity)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void clonePlayer(PlayerEvent.Clone event) {
        event.getOriginal().revive();
        PlayerStages original = PlayerStages.get(event.getOriginal());
        PlayerStages clone = PlayerStages.get(event.getEntity());
        clone.copy(original);
        event.isWasDeath();
    }
}

