/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.recipe;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.Nullable;
import ru.blatfan.blatapi.BlatApi;
import ru.blatfan.blatapi.common.BARegistry;
import ru.blatfan.blatapi.common.recipe.IAnvilRecipe;
import ru.blatfan.blatapi.common.recipe.IngredientWithCount;
import ru.blatfan.blatapi.utils.ItemHelper;

public class AnvilRecipe
implements IAnvilRecipe {
    public static final ResourceLocation type = BlatApi.loc("anvil");
    private final List<ICondition> conditions = Lists.newArrayList();
    private final Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();
    private final ResourceLocation id;
    private final ItemStack result;
    private final NonNullList<Ingredient> inputs;
    private final NonNullList<ItemStack> returns;
    private final List<CompoundTag> nbt;
    private final List<Boolean> strictNbt;
    private final List<Boolean> consumes;
    private final List<Boolean> useDurability;
    private final List<Integer> counts;
    private final int experience;
    private boolean shapeless;

    public AnvilRecipe(ResourceLocation id, ItemStack result, List<ItemStack> leftInput, List<ItemStack> rightInput, int experience) {
        this(id, result, (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43921_(leftInput.stream()), Ingredient.m_43921_(rightInput.stream())}), (NonNullList<ItemStack>)((NonNullList)Util.m_137469_((Object)NonNullList.m_122779_(), returns -> returns.addAll(List.of(ItemStack.f_41583_, ItemStack.f_41583_)))), (List)Util.m_137469_(new ArrayList(), nbt -> nbt.addAll(List.of(((ItemStack)leftInput.get(0)).m_41782_() ? ((ItemStack)leftInput.get(0)).m_41783_() : new CompoundTag(), ((ItemStack)rightInput.get(0)).m_41782_() ? ((ItemStack)rightInput.get(0)).m_41783_() : new CompoundTag()))), (List)Util.m_137469_(new ArrayList(), strictNbt -> strictNbt.addAll(List.of(Boolean.valueOf(false), Boolean.valueOf(false)))), (List)Util.m_137469_(new ArrayList(), consumes -> consumes.addAll(List.of(Boolean.valueOf(true), Boolean.valueOf(true)))), (List)Util.m_137469_(new ArrayList(), useDurability -> useDurability.addAll(List.of(Boolean.valueOf(false), Boolean.valueOf(false)))), List.of(Integer.valueOf(leftInput.get(0).m_41613_()), Integer.valueOf(rightInput.get(0).m_41613_())), false, experience);
    }

    public AnvilRecipe(ResourceLocation id, ItemStack result, IngredientWithCount leftInput, IngredientWithCount rightInput, int experience, boolean shapeless) {
        this(id, result, (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{leftInput, rightInput}), (NonNullList<ItemStack>)((NonNullList)Util.m_137469_((Object)NonNullList.m_122779_(), returns -> returns.addAll(List.of(ItemStack.f_41583_, ItemStack.f_41583_)))), (List)Util.m_137469_(new ArrayList(), nbt -> nbt.addAll(List.of(new CompoundTag(), new CompoundTag()))), (List)Util.m_137469_(new ArrayList(), strictNbt -> strictNbt.addAll(List.of(Boolean.valueOf(false), Boolean.valueOf(false)))), (List)Util.m_137469_(new ArrayList(), consumes -> consumes.addAll(List.of(Boolean.valueOf(true), Boolean.valueOf(true)))), (List)Util.m_137469_(new ArrayList(), useDurability -> useDurability.addAll(List.of(Boolean.valueOf(false), Boolean.valueOf(false)))), List.of(Integer.valueOf(leftInput.getCount()), Integer.valueOf(rightInput.getCount())), shapeless, experience);
    }

    public AnvilRecipe(ResourceLocation id, ItemStack result, IngredientWithCount leftInput, IngredientWithCount rightInput, int experience) {
        this(id, result, leftInput, rightInput, experience, false);
    }

    public AnvilRecipe(ResourceLocation id, ItemStack result, ItemStack leftInput, ItemStack rightInput, int experience) {
        this(id, result, (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{leftInput}), Ingredient.m_43927_((ItemStack[])new ItemStack[]{rightInput})}), (NonNullList<ItemStack>)((NonNullList)Util.m_137469_((Object)NonNullList.m_122779_(), returns -> returns.addAll(List.of(ItemStack.f_41583_, ItemStack.f_41583_)))), (List)Util.m_137469_(new ArrayList(), nbt -> nbt.addAll(List.of(leftInput.m_41782_() ? leftInput.m_41783_() : new CompoundTag(), rightInput.m_41782_() ? rightInput.m_41783_() : new CompoundTag()))), (List)Util.m_137469_(new ArrayList(), strictNbt -> strictNbt.addAll(List.of(Boolean.valueOf(false), Boolean.valueOf(false)))), (List)Util.m_137469_(new ArrayList(), consumes -> consumes.addAll(List.of(Boolean.valueOf(true), Boolean.valueOf(true)))), (List)Util.m_137469_(new ArrayList(), useDurability -> useDurability.addAll(List.of(Boolean.valueOf(false), Boolean.valueOf(false)))), List.of(Integer.valueOf(leftInput.m_41613_()), Integer.valueOf(rightInput.m_41613_())), false, experience);
    }

    public AnvilRecipe(ResourceLocation id, ItemStack result, Ingredient leftInput, int leftInputCount, List<ItemStack> rightInput, int experience) {
        this(id, result, (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{leftInput, Ingredient.m_43921_(rightInput.stream())}), (NonNullList<ItemStack>)((NonNullList)Util.m_137469_((Object)NonNullList.m_122779_(), returns -> returns.addAll(List.of(ItemStack.f_41583_, ItemStack.f_41583_)))), (List)Util.m_137469_(new ArrayList(), nbt -> nbt.addAll(List.of(new CompoundTag(), ((ItemStack)rightInput.get(0)).m_41782_() ? ((ItemStack)rightInput.get(0)).m_41783_() : new CompoundTag()))), (List)Util.m_137469_(new ArrayList(), strictNbt -> strictNbt.addAll(List.of(Boolean.valueOf(false), Boolean.valueOf(false)))), (List)Util.m_137469_(new ArrayList(), consumes -> consumes.addAll(List.of(Boolean.valueOf(true), Boolean.valueOf(true)))), (List)Util.m_137469_(new ArrayList(), useDurability -> useDurability.addAll(List.of(Boolean.valueOf(false), Boolean.valueOf(false)))), List.of(Integer.valueOf(leftInputCount), Integer.valueOf(rightInput.get(0).m_41613_())), false, experience);
    }

    public AnvilRecipe(ResourceLocation id, ItemStack result, Ingredient leftInput, int leftInputCount, ItemStack rightInput, int experience) {
        this(id, result, (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{leftInput, Ingredient.m_43927_((ItemStack[])new ItemStack[]{rightInput})}), (NonNullList<ItemStack>)((NonNullList)Util.m_137469_((Object)NonNullList.m_122779_(), returns -> returns.addAll(List.of(ItemStack.f_41583_, ItemStack.f_41583_)))), (List)Util.m_137469_(new ArrayList(), nbt -> nbt.addAll(List.of(new CompoundTag(), rightInput.m_41782_() ? rightInput.m_41783_() : new CompoundTag()))), (List)Util.m_137469_(new ArrayList(), strictNbt -> strictNbt.addAll(List.of(Boolean.valueOf(false), Boolean.valueOf(false)))), (List)Util.m_137469_(new ArrayList(), consumes -> consumes.addAll(List.of(Boolean.valueOf(true), Boolean.valueOf(true)))), (List)Util.m_137469_(new ArrayList(), useDurability -> useDurability.addAll(List.of(Boolean.valueOf(false), Boolean.valueOf(false)))), List.of(Integer.valueOf(leftInputCount), Integer.valueOf(rightInput.m_41613_())), false, experience);
    }

    public AnvilRecipe(ResourceLocation id, ItemStack result, List<ItemStack> leftInput, Ingredient rightInput, int rightInputCount, int experience) {
        this(id, result, (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43921_(leftInput.stream()), rightInput}), (NonNullList<ItemStack>)((NonNullList)Util.m_137469_((Object)NonNullList.m_122779_(), returns -> returns.addAll(List.of(ItemStack.f_41583_, ItemStack.f_41583_)))), (List)Util.m_137469_(new ArrayList(), nbt -> nbt.addAll(List.of(((ItemStack)leftInput.get(0)).m_41782_() ? ((ItemStack)leftInput.get(0)).m_41783_() : new CompoundTag(), new CompoundTag()))), (List)Util.m_137469_(new ArrayList(), strictNbt -> strictNbt.addAll(List.of(Boolean.valueOf(false), Boolean.valueOf(false)))), (List)Util.m_137469_(new ArrayList(), consumes -> consumes.addAll(List.of(Boolean.valueOf(true), Boolean.valueOf(true)))), (List)Util.m_137469_(new ArrayList(), useDurability -> useDurability.addAll(List.of(Boolean.valueOf(false), Boolean.valueOf(false)))), List.of(Integer.valueOf(leftInput.get(0).m_41613_()), Integer.valueOf(rightInputCount)), false, experience);
    }

    public AnvilRecipe(ResourceLocation id, ItemStack result, ItemStack leftInput, Ingredient rightInput, int rightInputCount, int experience) {
        this(id, result, (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{leftInput}), rightInput}), (NonNullList<ItemStack>)((NonNullList)Util.m_137469_((Object)NonNullList.m_122779_(), returns -> returns.addAll(List.of(ItemStack.f_41583_, ItemStack.f_41583_)))), (List)Util.m_137469_(new ArrayList(), nbt -> nbt.addAll(List.of(leftInput.m_41782_() ? leftInput.m_41783_() : new CompoundTag(), new CompoundTag()))), (List)Util.m_137469_(new ArrayList(), strictNbt -> strictNbt.addAll(List.of(Boolean.valueOf(false), Boolean.valueOf(false)))), (List)Util.m_137469_(new ArrayList(), consumes -> consumes.addAll(List.of(Boolean.valueOf(true), Boolean.valueOf(true)))), (List)Util.m_137469_(new ArrayList(), useDurability -> useDurability.addAll(List.of(Boolean.valueOf(false), Boolean.valueOf(false)))), List.of(Integer.valueOf(leftInput.m_41613_()), Integer.valueOf(rightInputCount)), false, experience);
    }

    public AnvilRecipe(ResourceLocation id, ItemStack result, Ingredient leftInput, int leftInputCount, Ingredient rightInput, int rightInputCount, int experience) {
        this(id, result, (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{leftInput, rightInput}), (NonNullList<ItemStack>)((NonNullList)Util.m_137469_((Object)NonNullList.m_122779_(), returns -> returns.addAll(List.of(ItemStack.f_41583_, ItemStack.f_41583_)))), (List)Util.m_137469_(new ArrayList(), nbt -> nbt.addAll(List.of(new CompoundTag(), new CompoundTag()))), (List)Util.m_137469_(new ArrayList(), strictNbt -> strictNbt.addAll(List.of(Boolean.valueOf(false), Boolean.valueOf(false)))), (List)Util.m_137469_(new ArrayList(), consumes -> consumes.addAll(List.of(Boolean.valueOf(true), Boolean.valueOf(true)))), (List)Util.m_137469_(new ArrayList(), useDurability -> useDurability.addAll(List.of(Boolean.valueOf(false), Boolean.valueOf(false)))), List.of(Integer.valueOf(leftInputCount), Integer.valueOf(rightInputCount)), false, experience);
    }

    public AnvilRecipe(ResourceLocation id, ItemStack result, Ingredient leftInput, int leftInputCount, Ingredient rightInput, int rightInputCount, int experience, boolean shapeless) {
        this(id, result, (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{leftInput, rightInput}), (NonNullList<ItemStack>)((NonNullList)Util.m_137469_((Object)NonNullList.m_122779_(), returns -> returns.addAll(List.of(ItemStack.f_41583_, ItemStack.f_41583_)))), (List)Util.m_137469_(new ArrayList(), nbt -> nbt.addAll(List.of(new CompoundTag(), new CompoundTag()))), (List)Util.m_137469_(new ArrayList(), strictNbt -> strictNbt.addAll(List.of(Boolean.valueOf(false), Boolean.valueOf(false)))), (List)Util.m_137469_(new ArrayList(), consumes -> consumes.addAll(List.of(Boolean.valueOf(true), Boolean.valueOf(true)))), (List)Util.m_137469_(new ArrayList(), useDurability -> useDurability.addAll(List.of(Boolean.valueOf(false), Boolean.valueOf(false)))), List.of(Integer.valueOf(leftInputCount), Integer.valueOf(rightInputCount)), shapeless, experience);
    }

    public AnvilRecipe(ResourceLocation id, ItemStack result, Ingredient leftInput, Ingredient rightInput, int experience) {
        this(id, result, (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{leftInput, rightInput}), (NonNullList<ItemStack>)((NonNullList)Util.m_137469_((Object)NonNullList.m_122779_(), returns -> returns.addAll(List.of(ItemStack.f_41583_, ItemStack.f_41583_)))), (List)Util.m_137469_(new ArrayList(), nbt -> nbt.addAll(List.of(new CompoundTag(), new CompoundTag()))), (List)Util.m_137469_(new ArrayList(), strictNbt -> strictNbt.addAll(List.of(Boolean.valueOf(false), Boolean.valueOf(false)))), (List)Util.m_137469_(new ArrayList(), consumes -> consumes.addAll(List.of(Boolean.valueOf(true), Boolean.valueOf(true)))), (List)Util.m_137469_(new ArrayList(), useDurability -> useDurability.addAll(List.of(Boolean.valueOf(false), Boolean.valueOf(false)))), List.of(Integer.valueOf(1), Integer.valueOf(1)), false, experience);
    }

    protected AnvilRecipe(ResourceLocation id, ItemStack result, NonNullList<Ingredient> inputs, NonNullList<ItemStack> returns, List<CompoundTag> nbt, List<Boolean> strictNbt, List<Boolean> consumes, List<Boolean> useDurability, List<Integer> counts, boolean shapeless, int experience) {
        this.id = id;
        this.result = result;
        this.inputs = inputs;
        this.returns = returns;
        this.nbt = nbt;
        this.strictNbt = strictNbt;
        this.consumes = consumes;
        this.useDurability = useDurability;
        this.counts = counts;
        this.shapeless = shapeless;
        this.experience = experience;
    }

    @CanIgnoreReturnValue
    public AnvilRecipe shapeless() {
        this.shapeless = true;
        return this;
    }

    @CanIgnoreReturnValue
    public AnvilRecipe shapeless(boolean shapeless) {
        this.shapeless = shapeless;
        return this;
    }

    @CanIgnoreReturnValue
    public AnvilRecipe consume(int inputId, boolean consume) {
        this.consumes.set(inputId, this.useDurability.get(inputId) != false || consume);
        return this;
    }

    @CanIgnoreReturnValue
    public AnvilRecipe setUseDurability(int inputId, boolean useDurability) {
        this.useDurability.set(inputId, useDurability);
        this.consumes.set(inputId, useDurability || this.consumes.get(inputId) != false);
        return this;
    }

    @CanIgnoreReturnValue
    public AnvilRecipe setUseDurability(int inputId) {
        this.useDurability.set(inputId, true);
        this.consumes.set(inputId, true);
        return this;
    }

    @CanIgnoreReturnValue
    public AnvilRecipe setReturnItem(int inputId, ItemStack returnItem) {
        this.returns.set(inputId, (Object)returnItem);
        return this;
    }

    @CanIgnoreReturnValue
    public AnvilRecipe strictNbt(int inputId) {
        this.strictNbt.set(inputId, this.hasNbt(inputId));
        return this;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.result;
    }

    @Override
    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    @Override
    public Ingredient getInput(int inputId) {
        return (Ingredient)this.inputs.get(inputId);
    }

    @Override
    public NonNullList<ItemStack> getReturns() {
        return this.returns;
    }

    @Override
    public ItemStack getReturn(int inputId) {
        return (ItemStack)this.returns.get(inputId);
    }

    @Override
    public List<Integer> getCounts() {
        return this.counts;
    }

    @Override
    public int getInputCount(int inputId) {
        return this.counts.get(inputId);
    }

    @Override
    public boolean isConsuming(int inputId) {
        return this.consumes.get(inputId);
    }

    @Override
    public List<Boolean> getUseDurability() {
        return this.useDurability;
    }

    @Override
    public boolean isUsingDurability(int inputId) {
        return this.useDurability.get(inputId);
    }

    @Override
    public List<CompoundTag> getAllNbt() {
        return this.nbt;
    }

    @Override
    public CompoundTag getInputNbt(int inputId) {
        return this.nbt.get(inputId);
    }

    @Override
    public boolean hasNbt(int inputId) {
        return !this.nbt.get(inputId).m_128456_();
    }

    @Override
    public List<Boolean> getStrictNbt() {
        return this.strictNbt;
    }

    @Override
    public boolean isNbtStrict(int inputId) {
        return this.hasNbt(inputId) && this.strictNbt.get(inputId) != false;
    }

    @Override
    public List<Boolean> getConsumes() {
        return this.consumes;
    }

    @Override
    public boolean isShapeless() {
        return this.shapeless;
    }

    @Override
    public int getExperience() {
        return this.experience;
    }

    public ItemStack m_5874_(Container container, RegistryAccess access) {
        return this.m_8043_(access).m_41777_();
    }

    public boolean m_5818_(Container container, Level level) {
        NonNullList inputs = NonNullList.m_122779_();
        inputs.add((Object)container.m_8020_(0));
        inputs.add((Object)container.m_8020_(1));
        if (this.shapeless) {
            ArrayList checked = Lists.newArrayList();
            inputs.removeIf(stack -> stack == null || stack == ItemStack.f_41583_);
            if (inputs.size() != this.inputs.size()) {
                return false;
            }
            for (int ingredientId = 0; ingredientId < this.inputs.size(); ++ingredientId) {
                boolean flag = false;
                Ingredient ingredient = (Ingredient)this.inputs.get(ingredientId);
                Integer ingredientCount = this.counts.get(ingredientId);
                CompoundTag ingredientNbt = this.nbt.get(ingredientId);
                for (int inputId = 0; inputId < inputs.size(); ++inputId) {
                    ItemStack input = (ItemStack)inputs.get(inputId);
                    if (this.useDurability.get(ingredientId).booleanValue() && (!input.m_41763_() || input.m_41776_() - input.m_41773_() + 1 < this.getInputCount(ingredientId)) || checked.contains(inputId) || input.m_41613_() < ingredientCount || (!this.isNbtStrict(ingredientId) ? !NbtUtils.m_129235_((Tag)ingredientNbt, (Tag)(input.m_41782_() ? input.m_41783_() : new CompoundTag()), (boolean)true) : !ingredientNbt.equals((Object)(input.m_41782_() ? input.m_41783_() : new CompoundTag()))) || !ingredient.test(input)) continue;
                    flag = true;
                    checked.add(inputId);
                    break;
                }
                if (flag) continue;
                return false;
            }
            return true;
        }
        return this.getInput(0).test((ItemStack)inputs.get(0)) && this.getInputCount(0) <= ((ItemStack)inputs.get(0)).m_41613_() && (this.isNbtStrict(0) ? this.getInputNbt(0).equals((Object)(((ItemStack)inputs.get(0)).m_41782_() ? ((ItemStack)inputs.get(0)).m_41783_() : new CompoundTag())) : NbtUtils.m_129235_((Tag)this.getInputNbt(0), (Tag)(((ItemStack)inputs.get(0)).m_41782_() ? ((ItemStack)inputs.get(0)).m_41783_() : new CompoundTag()), (boolean)true)) && (!this.isUsingDurability(0) || ((ItemStack)inputs.get(0)).m_41763_()) && this.getInput(1).test((ItemStack)inputs.get(1)) && this.getInputCount(1) <= ((ItemStack)inputs.get(1)).m_41613_() && (this.isNbtStrict(1) ? this.getInputNbt(1).equals((Object)(((ItemStack)inputs.get(1)).m_41782_() ? ((ItemStack)inputs.get(1)).m_41783_() : new CompoundTag())) : NbtUtils.m_129235_((Tag)this.getInputNbt(1), (Tag)(((ItemStack)inputs.get(1)).m_41782_() ? ((ItemStack)inputs.get(1)).m_41783_() : new CompoundTag()), (boolean)true)) && (!this.isUsingDurability(1) || ((ItemStack)inputs.get(1)).m_41763_());
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)Items.f_42146_);
    }

    public RecipeType<IAnvilRecipe> m_6671_() {
        return (RecipeType)BARegistry.ANVIL.get();
    }

    public RecipeSerializer<IAnvilRecipe> m_7707_() {
        return (RecipeSerializer)BARegistry.ANVIL_S.get();
    }

    public AnvilRecipe addCriterion(String name, CriterionTriggerInstance criterion) {
        this.advancementBuilder.m_138386_(name, criterion);
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.advancementBuilder.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
        this.advancementBuilder.m_138396_(ResourceLocation.m_135820_((String)"recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)new RecipeUnlockedTrigger.TriggerInstance(ContextAwarePredicate.f_285567_, id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept(new Result(id));
    }

    private class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final ResourceLocation advancementId;

        Result(ResourceLocation id) {
            this.id = id;
            this.advancementId = new ResourceLocation(id.m_135827_(), "recipes/" + id.m_135815_());
        }

        public JsonObject m_125966_() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("type", type.toString());
            if (!AnvilRecipe.this.conditions.isEmpty()) {
                JsonArray conditionsArray = new JsonArray();
                for (ICondition condition : AnvilRecipe.this.conditions) {
                    conditionsArray.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
                }
                jsonObject.add("conditions", (JsonElement)conditionsArray);
            }
            this.m_7917_(jsonObject);
            return jsonObject;
        }

        public void m_7917_(JsonObject json) {
            JsonArray inputsJson = new JsonArray();
            for (int inputId = 0; inputId < AnvilRecipe.this.inputs.size(); ++inputId) {
                JsonObject inputJson = ((Ingredient)AnvilRecipe.this.inputs.get(inputId)).m_43942_().getAsJsonObject();
                if (AnvilRecipe.this.counts.get(inputId) != 1) {
                    inputJson.addProperty("count", (Number)AnvilRecipe.this.counts.get(inputId));
                }
                if (!AnvilRecipe.this.nbt.get(inputId).m_128456_()) {
                    inputJson.addProperty("nbt", AnvilRecipe.this.nbt.get(inputId).toString());
                }
                if (AnvilRecipe.this.strictNbt.get(inputId).booleanValue()) {
                    inputJson.addProperty("strictNbt", AnvilRecipe.this.strictNbt.get(inputId));
                }
                if (!AnvilRecipe.this.consumes.get(inputId).booleanValue()) {
                    inputJson.addProperty("consume", AnvilRecipe.this.consumes.get(inputId));
                }
                if (AnvilRecipe.this.useDurability.get(inputId).booleanValue()) {
                    inputJson.addProperty("useDurability", AnvilRecipe.this.useDurability.get(inputId));
                }
                if (!((ItemStack)AnvilRecipe.this.returns.get(inputId)).m_41619_()) {
                    inputJson.add("return", (JsonElement)ItemHelper.serialize((ItemStack)AnvilRecipe.this.returns.get(inputId)));
                }
                inputsJson.add((JsonElement)inputJson);
            }
            json.add("inputs", (JsonElement)inputsJson);
            json.add("result", (JsonElement)ItemHelper.serialize(AnvilRecipe.this.result));
            if (AnvilRecipe.this.shapeless) {
                json.addProperty("shapeless", Boolean.valueOf(true));
            }
            if (AnvilRecipe.this.experience != 0) {
                json.addProperty("experience", (Number)AnvilRecipe.this.experience);
            }
        }

        @Nonnull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(type);
        }

        @Nullable
        public JsonObject m_5860_() {
            return AnvilRecipe.this.advancementBuilder.m_138400_();
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }

    public static class Serializer
    implements RecipeSerializer<IAnvilRecipe> {
        public IAnvilRecipe fromJson(ResourceLocation id, JsonObject json) {
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true, (boolean)false);
            NonNullList inputs = NonNullList.m_122779_();
            NonNullList returns = NonNullList.m_122779_();
            ArrayList nbt = Lists.newArrayList();
            ArrayList strictNbt = Lists.newArrayList();
            ArrayList consumes = Lists.newArrayList();
            ArrayList useDurability = Lists.newArrayList();
            ArrayList counts = Lists.newArrayList();
            for (JsonElement inputElement : GsonHelper.m_13933_((JsonObject)json, (String)"inputs")) {
                inputs.add((Object)Ingredient.m_43917_((JsonElement)inputElement));
                returns.add((Object)(inputElement.getAsJsonObject().has("return") ? CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)inputElement.getAsJsonObject(), (String)"return"), (boolean)true, (boolean)false) : ItemStack.f_41583_));
                nbt.add(inputElement.getAsJsonObject().has("nbt") ? CraftingHelper.getNBT((JsonElement)inputElement.getAsJsonObject().get("nbt")) : new CompoundTag());
                strictNbt.add(GsonHelper.m_13855_((JsonObject)inputElement.getAsJsonObject(), (String)"strictNbt", (boolean)false));
                consumes.add(GsonHelper.m_13855_((JsonObject)inputElement.getAsJsonObject(), (String)"consume", (boolean)true));
                useDurability.add(GsonHelper.m_13855_((JsonObject)inputElement.getAsJsonObject(), (String)"useDurability", (boolean)false));
                counts.add(GsonHelper.m_13824_((JsonObject)inputElement.getAsJsonObject(), (String)"count", (int)1));
            }
            boolean shapeless = false;
            if (json.has("shapeless")) {
                shapeless = GsonHelper.m_13912_((JsonObject)json, (String)"shapeless");
            }
            int experience = GsonHelper.m_13824_((JsonObject)json, (String)"experience", (int)0);
            return new AnvilRecipe(id, result, (NonNullList<Ingredient>)inputs, (NonNullList<ItemStack>)returns, nbt, strictNbt, consumes, useDurability, counts, shapeless, experience);
        }

        @Nullable
        public IAnvilRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            ItemStack result = buffer.m_130267_();
            int inputsSize = buffer.readInt();
            NonNullList inputs = NonNullList.m_122779_();
            for (int inputId = 0; inputId < inputsSize; ++inputId) {
                inputs.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            int returnsSize = buffer.readInt();
            NonNullList returns = NonNullList.m_122779_();
            for (int returnId = 0; returnId < returnsSize; ++returnId) {
                returns.add((Object)buffer.m_130267_());
            }
            int nbtSize = buffer.readInt();
            ArrayList nbt = Lists.newArrayList();
            for (int nbtId = 0; nbtId < nbtSize; ++nbtId) {
                nbt.add(buffer.m_130260_());
            }
            int strictNbtSize = buffer.readInt();
            ArrayList strictNbt = Lists.newArrayList();
            for (int strictNbtId = 0; strictNbtId < strictNbtSize; ++strictNbtId) {
                strictNbt.add(buffer.readBoolean());
            }
            int consumesSize = buffer.readInt();
            ArrayList consumes = Lists.newArrayList();
            for (int consumeId = 0; consumeId < consumesSize; ++consumeId) {
                consumes.add(buffer.readBoolean());
            }
            int useDurabilitySize = buffer.readInt();
            ArrayList useDurability = Lists.newArrayList();
            for (int useDurabilityId = 0; useDurabilityId < useDurabilitySize; ++useDurabilityId) {
                useDurability.add(buffer.readBoolean());
            }
            int countsSize = buffer.readInt();
            ArrayList counts = Lists.newArrayList();
            for (int countId = 0; countId < countsSize; ++countId) {
                counts.add(buffer.readInt());
            }
            boolean shapeless = buffer.readBoolean();
            int experience = buffer.readInt();
            return new AnvilRecipe(id, result, (NonNullList<Ingredient>)inputs, (NonNullList<ItemStack>)returns, nbt, strictNbt, consumes, useDurability, counts, shapeless, experience);
        }

        public void toNetwork(FriendlyByteBuf buffer, IAnvilRecipe recipe) {
            buffer.m_130055_(recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()));
            buffer.writeInt(recipe.m_7527_().size());
            for (Ingredient input : recipe.m_7527_()) {
                input.m_43923_(buffer);
            }
            buffer.writeInt(recipe.getReturns().size());
            for (ItemStack ret : recipe.getReturns()) {
                buffer.m_130055_(ret);
            }
            buffer.writeInt(recipe.getAllNbt().size());
            for (CompoundTag nbt : recipe.getAllNbt()) {
                buffer.m_130079_(nbt);
            }
            buffer.writeInt(recipe.getStrictNbt().size());
            for (Boolean strictNbt : recipe.getStrictNbt()) {
                buffer.writeBoolean(strictNbt.booleanValue());
            }
            buffer.writeInt(recipe.getConsumes().size());
            for (Boolean consume : recipe.getConsumes()) {
                buffer.writeBoolean(consume.booleanValue());
            }
            buffer.writeInt(recipe.getUseDurability().size());
            for (Boolean useDurability : recipe.getUseDurability()) {
                buffer.writeBoolean(useDurability.booleanValue());
            }
            buffer.writeInt(recipe.getCounts().size());
            for (Integer count : recipe.getCounts()) {
                buffer.writeInt(count.intValue());
            }
            buffer.writeBoolean(recipe.isShapeless());
            buffer.writeInt(recipe.getExperience());
        }
    }
}

