/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.Nullable;
import ru.blatfan.blatapi.BlatApi;
import ru.blatfan.blatapi.common.BARegistry;
import ru.blatfan.blatapi.common.recipe.IAnvilRepairRecipe;
import ru.blatfan.blatapi.utils.ItemHelper;

public class AnvilRepairRecipe
implements IAnvilRepairRecipe {
    public static final ResourceLocation type = BlatApi.loc("anvil_repair");
    private final List<ICondition> conditions = Lists.newArrayList();
    private final Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();
    private final ResourceLocation id;
    private final Item baseItem;
    private final Ingredient repairItem;

    public AnvilRepairRecipe(ResourceLocation id, Item baseItem, Ingredient repairItem) {
        this.id = id;
        this.baseItem = baseItem;
        this.repairItem = repairItem;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public Item getBaseItem() {
        return this.baseItem;
    }

    @Override
    public Ingredient getRepairItem() {
        return this.repairItem;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return new ItemStack((ItemLike)this.baseItem);
    }

    public ItemStack m_5874_(Container container, RegistryAccess access) {
        return this.m_8043_(access).m_41777_();
    }

    public boolean m_5818_(Container container, Level level) {
        return container.m_8020_(0).m_150930_(this.baseItem) && this.repairItem.test(container.m_8020_(1));
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)Items.f_42146_);
    }

    public RecipeType<IAnvilRepairRecipe> m_6671_() {
        return (RecipeType)BARegistry.ANVIL_REPAIR.get();
    }

    public RecipeSerializer<IAnvilRepairRecipe> m_7707_() {
        return (RecipeSerializer)BARegistry.ANVIL_REPAIR_S.get();
    }

    public AnvilRepairRecipe addCriterion(String name, CriterionTriggerInstance criterion) {
        this.advancementBuilder.m_138386_(name, criterion);
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.advancementBuilder.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
        this.advancementBuilder.m_138396_(ResourceLocation.m_135820_((String)"recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)new RecipeUnlockedTrigger.TriggerInstance(ContextAwarePredicate.f_285567_, id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept(new Result(id));
    }

    private class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final ResourceLocation advancementId;

        Result(ResourceLocation id) {
            this.id = id;
            this.advancementId = new ResourceLocation(id.m_135827_(), "recipes/" + id.m_135815_());
        }

        public JsonObject m_125966_() {
            JsonObject json = new JsonObject();
            json.addProperty("type", type.toString());
            if (!AnvilRepairRecipe.this.conditions.isEmpty()) {
                JsonArray conditionsArray = new JsonArray();
                for (ICondition condition : AnvilRepairRecipe.this.conditions) {
                    conditionsArray.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
                }
                json.add("conditions", (JsonElement)conditionsArray);
            }
            this.m_7917_(json);
            return json;
        }

        public void m_7917_(JsonObject json) {
            json.add("baseItem", (JsonElement)ItemHelper.serialize(AnvilRepairRecipe.this.baseItem));
            json.add("repairItem", AnvilRepairRecipe.this.repairItem.m_43942_());
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(type);
        }

        @Nullable
        public JsonObject m_5860_() {
            return AnvilRepairRecipe.this.advancementBuilder.m_138400_();
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }

    public static class Serializer
    implements RecipeSerializer<IAnvilRepairRecipe> {
        public IAnvilRepairRecipe fromJson(ResourceLocation id, JsonObject json) {
            Item baseItem = GsonHelper.m_13909_((JsonObject)json, (String)"baseItem");
            JsonElement repairItemJson = json.get("repairItem");
            Ingredient repairItem = repairItemJson.isJsonPrimitive() ? Ingredient.m_43929_((ItemLike[])new ItemLike[]{GsonHelper.m_13874_((JsonElement)repairItemJson, (String)"repairItem")}) : Ingredient.m_288218_((JsonElement)json.get("repairItem"), (boolean)false);
            return new AnvilRepairRecipe(id, baseItem, repairItem);
        }

        @Nullable
        public IAnvilRepairRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            Item baseItem = (Item)ForgeRegistries.ITEMS.getValue(buffer.m_130281_());
            Ingredient repairItem = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            return new AnvilRepairRecipe(id, baseItem, repairItem);
        }

        public void toNetwork(FriendlyByteBuf buffer, IAnvilRepairRecipe recipe) {
            buffer.m_130085_(ForgeRegistries.ITEMS.getKey((Object)recipe.getBaseItem()));
            recipe.getRepairItem().m_43923_(buffer);
        }
    }
}

