/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.recipe;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import ru.blatfan.blatapi.common.recipe.SimpleShapedRecipe;
import ru.blatfan.blatapi.utils.RecipeUtil;

public interface IRecipePattern {
    public int getRecipeWidth();

    public int getRecipeHeight();

    default public NonNullList<Ingredient> patternsFromJson(JsonObject pJson) {
        return RecipeUtil.patternIngsFromJson(pJson, this.getRecipeWidth(), this.getRecipeHeight());
    }

    default public void patternToNetwork(FriendlyByteBuf buf, SimpleShapedRecipe recipe) {
        RecipeUtil.patternIngsToNetwork(buf, recipe);
    }

    default public NonNullList<Ingredient> patternFromNetwork(FriendlyByteBuf buf) {
        return RecipeUtil.patternIngFromNetwork(buf);
    }

    @VisibleForTesting
    public static String[] shrink(String ... pToShrink) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < pToShrink.length; ++i1) {
            String s = pToShrink[i1];
            i = Math.min(i, IRecipePattern.firstNonSpace(s));
            int j1 = IRecipePattern.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (pToShrink.length == l) {
            return new String[0];
        }
        String[] astring = new String[pToShrink.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = pToShrink[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    private static int firstNonSpace(String pEntry) {
        int i;
        for (i = 0; i < pEntry.length() && pEntry.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String pEntry) {
        int i;
        for (i = pEntry.length() - 1; i >= 0 && pEntry.charAt(i) == ' '; --i) {
        }
        return i;
    }

    public static NonNullList<Ingredient> dissolvePattern(String[] pPattern, Map<String, Ingredient> pKeys, int pPatternWidth, int pPatternHeight) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)(pPatternWidth * pPatternHeight), (Object)Ingredient.f_43901_);
        HashSet set = Sets.newHashSet(pKeys.keySet());
        set.remove(" ");
        for (int i = 0; i < pPattern.length; ++i) {
            for (int j = 0; j < pPattern[i].length(); ++j) {
                String s = pPattern[i].substring(j, j + 1);
                Ingredient ingredient = pKeys.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + pPatternWidth * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    public static String[] patternFromJson(JsonArray pPatternArray, int MAX_WIDTH, int MAX_HEIGHT) {
        String[] astring = new String[pPatternArray.size()];
        if (astring.length > MAX_HEIGHT) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, " + MAX_HEIGHT + " is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = GsonHelper.m_13805_((JsonElement)pPatternArray.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > MAX_WIDTH) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, " + MAX_WIDTH + " is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    public static Map<String, Ingredient> keyFromJson(JsonObject pKeyEntry) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : pKeyEntry.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), Ingredient.m_288218_((JsonElement)((JsonElement)entry.getValue()), (boolean)false));
        }
        map.put(" ", Ingredient.f_43901_);
        return map;
    }
}

