/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class IngredientWithCount
extends Ingredient {
    private final Ingredient base;
    private final int count;

    private IngredientWithCount(Ingredient base, int count) {
        super(Stream.of(base.f_43902_));
        this.base = base;
        this.count = Math.max(1, count);
    }

    public static IngredientWithCount of(Ingredient base, int count) {
        return new IngredientWithCount(base, count);
    }

    public static IngredientWithCount of(Ingredient base) {
        return new IngredientWithCount(base, 1);
    }

    public boolean test(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return this.base.test(stack) && stack.m_41613_() >= this.count;
    }

    public ItemStack[] m_43908_() {
        ItemStack[] baseItems = this.base.m_43908_();
        ItemStack[] items = new ItemStack[baseItems.length];
        for (int i = 0; i < baseItems.length; ++i) {
            items[i] = baseItems[i].m_41777_();
            items[i].m_41764_(this.count);
        }
        return items;
    }

    public boolean isSimple() {
        return this.base.isSimple();
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.add("ingredient", this.base.m_43942_());
        if (this.count > 1) {
            json.addProperty("count", (Number)this.count);
        }
        return json;
    }

    public static IngredientWithCount fromJson(JsonElement element) {
        if (element.isJsonObject()) {
            JsonObject json = element.getAsJsonObject();
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
            int count = json.has("count") ? json.get("count").getAsInt() : 1;
            return new IngredientWithCount(ingredient, count);
        }
        return new IngredientWithCount(Ingredient.m_43917_((JsonElement)element), 1);
    }

    public String toString() {
        return "IngredientWithCount(base=" + this.getBase().toString() + ", count=" + this.getCount() + ")";
    }

    public Ingredient getBase() {
        return this.base;
    }

    public int getCount() {
        return this.count;
    }
}

