/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.recipe;

import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import ru.blatfan.blatapi.common.recipe.IRecipePattern;
import ru.blatfan.blatapi.common.recipe.SimpleRecipe;

public abstract class SimpleShapedRecipe<T extends CraftingContainer>
extends SimpleRecipe<T>
implements IRecipePattern {
    private final int width;
    private final int height;

    public SimpleShapedRecipe(ResourceLocation id, NonNullList<Ingredient> ingredients, ItemStack result, int width, int height) {
        super(id, ingredients, result);
        this.width = width;
        this.height = height;
    }

    @Override
    public int getRecipeWidth() {
        return this.width;
    }

    @Override
    public int getRecipeHeight() {
        return this.height;
    }

    public boolean matches(T pInv, Level pLevel) {
        for (int i = 0; i <= pInv.m_39347_() - this.width; ++i) {
            for (int j = 0; j <= pInv.m_39346_() - this.height; ++j) {
                if (this.matches(pInv, i, j, true)) {
                    return true;
                }
                if (!this.matches(pInv, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(T pCraftingInventory, int pWidth, int pHeight, boolean pMirrored) {
        for (int i = 0; i < pCraftingInventory.m_39347_(); ++i) {
            for (int j = 0; j < pCraftingInventory.m_39346_(); ++j) {
                int k = i - pWidth;
                int l = j - pHeight;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = pMirrored ? (Ingredient)this.m_7527_().get(this.width - k - 1 + l * this.width) : (Ingredient)this.m_7527_().get(k + l * this.width);
                }
                if (ingredient.test(pCraftingInventory.m_8020_(i + j * pCraftingInventory.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }
}

