/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.registry;

import java.util.function.Supplier;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import oshi.util.tuples.Pair;
import ru.blatfan.blatapi.common.registry.BlatRegistryEvent;

public class BlatRegister {
    public final String modid;
    public final DeferredRegister<Block> BLOCKS;
    public final DeferredRegister<Fluid> FLUIDS;
    public final DeferredRegister<FluidType> FLUID_TYPES;
    public final DeferredRegister<Item> ITEMS;
    public final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TAB;
    public final DeferredRegister<MobEffect> MOB_EFFECTS;
    public final DeferredRegister<SoundEvent> SOUND_EVENTS;
    public final DeferredRegister<Potion> POTIONS;
    public final DeferredRegister<Enchantment> ENCHANTMENTS;
    public final DeferredRegister<EntityType<?>> ENTITY_TYPES;
    public final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES;
    public final DeferredRegister<ParticleType<?>> PARTICLE_TYPES;
    public final DeferredRegister<MenuType<?>> MENU_TYPES;
    public final DeferredRegister<PaintingVariant> PAINTING_VARIANTS;
    public final DeferredRegister<RecipeType<?>> RECIPE_TYPES;
    public final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS;
    public final DeferredRegister<Attribute> ATTRIBUTES;
    public final DeferredRegister<StatType<?>> STAT_TYPES;
    public final DeferredRegister<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENT_TYPES;
    public final DeferredRegister<VillagerProfession> VILLAGER_PROFESSIONS;
    public final DeferredRegister<PoiType> POI_TYPES;
    public final DeferredRegister<MemoryModuleType<?>> MEMORY_MODULE_TYPES;
    public final DeferredRegister<SensorType<?>> SENSOR_TYPES;
    public final DeferredRegister<Schedule> SCHEDULES;
    public final DeferredRegister<Activity> ACTIVITIES;
    public final DeferredRegister<WorldCarver<?>> WORLD_CARVERS;
    public final DeferredRegister<Feature<?>> FEATURES;
    public final DeferredRegister<ChunkStatus> CHUNK_STATUS;
    public final DeferredRegister<BlockStateProviderType<?>> BLOCK_STATE_PROVIDER_TYPES;
    public final DeferredRegister<FoliagePlacerType<?>> FOLIAGE_PLACER_TYPES;
    public final DeferredRegister<TreeDecoratorType<?>> TREE_DECORATOR_TYPES;
    public final DeferredRegister<Biome> BIOMES;
    public final DeferredRegister<TrunkPlacerType<?>> TRUNK_PLACER_TYPE;

    public BlatRegister(String modid) {
        this.modid = modid;
        this.BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)modid);
        this.FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)modid);
        this.FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)modid);
        this.ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)modid);
        this.CREATIVE_MODE_TAB = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)modid);
        this.MOB_EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)modid);
        this.SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)modid);
        this.POTIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POTIONS, (String)modid);
        this.ENCHANTMENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (String)modid);
        this.ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)modid);
        this.BLOCK_ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)modid);
        this.PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)modid);
        this.MENU_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)modid);
        this.PAINTING_VARIANTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PAINTING_VARIANTS, (String)modid);
        this.RECIPE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)modid);
        this.RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)modid);
        this.ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)modid);
        this.STAT_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STAT_TYPES, (String)modid);
        this.COMMAND_ARGUMENT_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.COMMAND_ARGUMENT_TYPES, (String)modid);
        this.VILLAGER_PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.VILLAGER_PROFESSIONS, (String)modid);
        this.POI_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)modid);
        this.MEMORY_MODULE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MEMORY_MODULE_TYPES, (String)modid);
        this.SENSOR_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SENSOR_TYPES, (String)modid);
        this.SCHEDULES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SCHEDULES, (String)modid);
        this.ACTIVITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ACTIVITIES, (String)modid);
        this.WORLD_CARVERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.WORLD_CARVERS, (String)modid);
        this.FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)modid);
        this.CHUNK_STATUS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CHUNK_STATUS, (String)modid);
        this.BLOCK_STATE_PROVIDER_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_STATE_PROVIDER_TYPES, (String)modid);
        this.FOLIAGE_PLACER_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FOLIAGE_PLACER_TYPES, (String)modid);
        this.TREE_DECORATOR_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TREE_DECORATOR_TYPES, (String)modid);
        this.BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)modid);
        this.TRUNK_PLACER_TYPE = DeferredRegister.create((ResourceKey)Registries.f_256963_, (String)modid);
    }

    public void register(IEventBus eventBus) {
        this.BLOCKS.register(eventBus);
        this.FLUIDS.register(eventBus);
        this.FLUID_TYPES.register(eventBus);
        this.ITEMS.register(eventBus);
        this.CREATIVE_MODE_TAB.register(eventBus);
        this.MOB_EFFECTS.register(eventBus);
        this.SOUND_EVENTS.register(eventBus);
        this.POTIONS.register(eventBus);
        this.ENCHANTMENTS.register(eventBus);
        this.ENTITY_TYPES.register(eventBus);
        this.BLOCK_ENTITY_TYPES.register(eventBus);
        this.PARTICLE_TYPES.register(eventBus);
        this.MENU_TYPES.register(eventBus);
        this.PAINTING_VARIANTS.register(eventBus);
        this.RECIPE_TYPES.register(eventBus);
        this.RECIPE_SERIALIZERS.register(eventBus);
        this.ATTRIBUTES.register(eventBus);
        this.STAT_TYPES.register(eventBus);
        this.COMMAND_ARGUMENT_TYPES.register(eventBus);
        this.VILLAGER_PROFESSIONS.register(eventBus);
        this.POI_TYPES.register(eventBus);
        this.MEMORY_MODULE_TYPES.register(eventBus);
        this.SENSOR_TYPES.register(eventBus);
        this.SCHEDULES.register(eventBus);
        this.ACTIVITIES.register(eventBus);
        this.WORLD_CARVERS.register(eventBus);
        this.FEATURES.register(eventBus);
        this.CHUNK_STATUS.register(eventBus);
        this.BLOCK_STATE_PROVIDER_TYPES.register(eventBus);
        this.FOLIAGE_PLACER_TYPES.register(eventBus);
        this.TREE_DECORATOR_TYPES.register(eventBus);
        this.BIOMES.register(eventBus);
        this.TRUNK_PLACER_TYPE.register(eventBus);
    }

    public RegistryObject<Block> block(String id, Supplier<Block> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.BLOCKS.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.BLOCKS.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public RegistryObject<Fluid> fluid(String id, Supplier<Fluid> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.FLUIDS.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.FLUIDS.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public RegistryObject<FluidType> fluid_type(String id, Supplier<FluidType> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.Keys.FLUID_TYPES, new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.FLUID_TYPES.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public RegistryObject<Item> item(String id, Supplier<Item> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.ITEMS.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.ITEMS.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public RegistryObject<CreativeModeTab> creative_mode_tab(String id, Supplier<CreativeModeTab> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, Registries.f_279569_, new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.CREATIVE_MODE_TAB.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public RegistryObject<MobEffect> mob_effect(String id, Supplier<MobEffect> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.MOB_EFFECTS.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.MOB_EFFECTS.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public RegistryObject<SoundEvent> sound_event(String id, Supplier<SoundEvent> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.SOUND_EVENTS.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.SOUND_EVENTS.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public RegistryObject<Potion> potion(String id, Supplier<Potion> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.POTIONS.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.POTIONS.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public RegistryObject<Enchantment> enchantment(String id, Supplier<Enchantment> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.ENCHANTMENTS.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.ENCHANTMENTS.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public <T extends EntityType<?>> RegistryObject<T> entity_type(String id, Supplier<T> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.ENTITY_TYPES.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.ENTITY_TYPES.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public <T extends BlockEntityType<?>> RegistryObject<T> block_entity_type(String id, Supplier<T> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.BLOCK_ENTITY_TYPES.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.BLOCK_ENTITY_TYPES.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public <T extends ParticleType<?>> RegistryObject<T> particle_type(String id, Supplier<T> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.PARTICLE_TYPES.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.PARTICLE_TYPES.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public <T extends MenuType<?>> RegistryObject<T> menu_type(String id, Supplier<T> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.MENU_TYPES.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.MENU_TYPES.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public RegistryObject<PaintingVariant> painting_variant(String id, Supplier<PaintingVariant> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.PAINTING_VARIANTS.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.PAINTING_VARIANTS.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public <T extends RecipeType<?>> RegistryObject<T> recipe_type(String id, Supplier<T> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.RECIPE_TYPES.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.RECIPE_TYPES.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public <T extends RecipeSerializer<?>> RegistryObject<T> recipe_serializer(String id, Supplier<T> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.RECIPE_SERIALIZERS.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.RECIPE_SERIALIZERS.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public RegistryObject<Attribute> attribute(String id, Supplier<Attribute> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.ATTRIBUTES.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.ATTRIBUTES.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public RegistryObject<StatType<?>> stat_type(String id, Supplier<StatType<?>> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.STAT_TYPES.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.STAT_TYPES.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public RegistryObject<ArgumentTypeInfo<?, ?>> command_argument_type(String id, Supplier<ArgumentTypeInfo<?, ?>> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.COMMAND_ARGUMENT_TYPES.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.COMMAND_ARGUMENT_TYPES.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public RegistryObject<VillagerProfession> villager_profession(String id, Supplier<VillagerProfession> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.VILLAGER_PROFESSIONS.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.VILLAGER_PROFESSIONS.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public RegistryObject<PoiType> poi_type(String id, Supplier<PoiType> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.POI_TYPES.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.POI_TYPES.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public RegistryObject<MemoryModuleType<?>> memory_module_type(String id, Supplier<MemoryModuleType<?>> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.MEMORY_MODULE_TYPES.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.MEMORY_MODULE_TYPES.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public RegistryObject<SensorType<?>> sensor_type(String id, Supplier<SensorType<?>> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.SENSOR_TYPES.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.SENSOR_TYPES.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public RegistryObject<Schedule> schedule(String id, Supplier<Schedule> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.SCHEDULES.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.SCHEDULES.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public RegistryObject<Activity> activitie(String id, Supplier<Activity> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.ACTIVITIES.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.ACTIVITIES.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public RegistryObject<WorldCarver<?>> world_carver(String id, Supplier<WorldCarver<?>> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.WORLD_CARVERS.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.WORLD_CARVERS.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public RegistryObject<Feature<?>> feature(String id, Supplier<Feature<?>> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.FEATURES.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.FEATURES.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public RegistryObject<ChunkStatus> chunk_statu(String id, Supplier<ChunkStatus> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.CHUNK_STATUS.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.CHUNK_STATUS.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public RegistryObject<BlockStateProviderType<?>> block_state_provider_type(String id, Supplier<BlockStateProviderType<?>> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.BLOCK_STATE_PROVIDER_TYPES.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.BLOCK_STATE_PROVIDER_TYPES.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public RegistryObject<FoliagePlacerType<?>> foliage_placer_type(String id, Supplier<FoliagePlacerType<?>> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.FOLIAGE_PLACER_TYPES.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.FOLIAGE_PLACER_TYPES.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public RegistryObject<TreeDecoratorType<?>> tree_decorator_type(String id, Supplier<TreeDecoratorType<?>> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.TREE_DECORATOR_TYPES.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.TREE_DECORATOR_TYPES.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public RegistryObject<TrunkPlacerType<?>> trunk_placer_type(String id, Supplier<TrunkPlacerType<?>> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, Registries.f_256963_, new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.TRUNK_PLACER_TYPE.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public RegistryObject<Biome> biome(String id, Supplier<Biome> supplier) {
        BlatRegistryEvent e = new BlatRegistryEvent(this, ForgeRegistries.BIOMES.getRegistryKey(), new Pair((Object)id, supplier));
        MinecraftForge.EVENT_BUS.post(e);
        return this.BIOMES.register((String)e.getObject().getA(), (Supplier)e.getObject().getB());
    }

    public <T extends Recipe<?>> RegistryObject<RecipeType<T>> recipe_type(String id) {
        return this.recipe_type(id, () -> RecipeType.simple((ResourceLocation)new ResourceLocation(this.modid, id)));
    }

    public RegistryObject<Block> block(String id) {
        return this.block(id, () -> new Block(BlockBehaviour.Properties.m_284310_()));
    }

    public RegistryObject<Item> item(String id) {
        return this.item(id, () -> new Item(new Item.Properties()));
    }

    public RegistryObject<SoundEvent> sound_event(String name) {
        return this.sound_event(name, () -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(this.modid, name)));
    }

    public <T extends Entity> RegistryObject<EntityType<T>> entity_type(String name, MobCategory mobCategory, float width, float height, int trackingRange, EntityType.EntityFactory<T> factory) {
        return this.entity_type(name, () -> EntityType.Builder.m_20704_((EntityType.EntityFactory)factory, (MobCategory)mobCategory).setTrackingRange(trackingRange).setUpdateInterval(1).m_20699_(width, height).m_20712_(this.modid + ":" + name));
    }

    public <T extends BlockEntity> RegistryObject<BlockEntityType<?>> block_entity_type(String id, BlockEntityType.BlockEntitySupplier<T> pFactory, Block ... pValidBlocks) {
        return this.block_entity_type(id, () -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)pFactory, (Block[])pValidBlocks).m_58966_(null));
    }
}

