/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.reward;

import com.google.gson.JsonObject;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import ru.blatfan.blatapi.common.reward.Reward;

public class CommandReward
extends Reward {
    private final String command;
    private final boolean player;
    private final boolean visible;

    public String getFormatedCommand(Player player) {
        return this.getCommand().replace(new StringBuffer("%player"), player.m_5446_().getString()).replace(new StringBuffer("%x"), String.valueOf(player.m_20185_())).replace(new StringBuffer("%y"), String.valueOf(player.m_20186_())).replace(new StringBuffer("%z"), String.valueOf(player.m_20189_()));
    }

    @Override
    public void apply(Player player) {
        CommandSourceStack source = player.m_20203_();
        if (!this.isPlayer()) {
            source = source.m_81325_(4);
        }
        player.m_20194_().m_129892_().m_230957_(source, this.getFormatedCommand(player));
    }

    public static CommandReward fromJson(JsonObject json) {
        String c = json.get("command").getAsString();
        boolean b = !json.has("visible") || json.get("visible").getAsBoolean();
        boolean p = !json.has("player") || json.get("player").getAsBoolean();
        return new CommandReward(c, p, b);
    }

    @Override
    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("command", this.command);
        tag.m_128379_("player", this.player);
        tag.m_128379_("visible", this.visible);
        return tag;
    }

    public static Reward fromTag(CompoundTag tag) {
        return new CommandReward(tag.m_128461_("command"), tag.m_128471_("player"), tag.m_128471_("visible"));
    }

    @Override
    public Component text(Player player) {
        return Component.m_237113_((String)this.getFormatedCommand(player)).m_130940_(ChatFormatting.GRAY);
    }

    public CommandReward(String command, boolean player, boolean visible) {
        this.command = command;
        this.player = player;
        this.visible = visible;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean isPlayer() {
        return this.player;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }
}

