/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.reward;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import ru.blatfan.blatapi.common.reward.AttributeReward;
import ru.blatfan.blatapi.common.reward.ClientReward;
import ru.blatfan.blatapi.common.reward.CloseMenuReward;
import ru.blatfan.blatapi.common.reward.CommandReward;
import ru.blatfan.blatapi.fluffy_fur.common.network.FluffyFurPacketHandler;
import ru.blatfan.blatapi.fluffy_fur.common.network.RewardPacket;

public abstract class Reward {
    public static final Map<String, Function<JsonObject, Reward>> TYPES = new HashMap<String, Function<JsonObject, Reward>>();
    public static final Map<String, Function<CompoundTag, Reward>> TYPES_TAG = new HashMap<String, Function<CompoundTag, Reward>>();

    public static void applyList(List<Reward> rewards) {
        ArrayList<Reward> r = new ArrayList<Reward>();
        for (Reward reward : rewards) {
            if (reward instanceof ClientReward) {
                reward.apply((Player)Minecraft.m_91087_().f_91074_);
                continue;
            }
            r.add(reward);
        }
        if (!r.isEmpty()) {
            FluffyFurPacketHandler.sendToServer(new RewardPacket(r));
        }
    }

    public abstract void apply(Player var1);

    public abstract boolean isVisible();

    public static Reward fromJson(JsonObject json) {
        JsonObject data = json.get("data").getAsJsonObject();
        String type = json.get("type").getAsString();
        return TYPES.containsKey(type) ? TYPES.get(type).apply(data) : null;
    }

    public abstract CompoundTag toTag();

    public static Reward fromTag(CompoundTag tag) {
        String type = tag.m_128461_("type");
        return TYPES_TAG.containsKey(type) ? TYPES_TAG.get(type).apply(tag) : null;
    }

    public abstract Component text(Player var1);

    static {
        TYPES.put("attribute", AttributeReward::fromJson);
        TYPES_TAG.put("attribute", AttributeReward::fromTag);
        TYPES.put("command", CommandReward::fromJson);
        TYPES_TAG.put("command", CommandReward::fromTag);
        TYPES_TAG.put("close_menu", CloseMenuReward::fromTag);
    }
}

