/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.common.task;

import com.google.gson.JsonObject;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import ru.blatfan.blatapi.common.task.Task;
import ru.blatfan.blatapi.utils.collection.Text;

public class NotTask
extends Task {
    private final boolean visible;
    private final Task task;

    @Override
    public boolean get(Player player) {
        return !this.task.get(player);
    }

    public static NotTask fromJson(JsonObject json) {
        boolean b = !json.has("visible") || json.get("visible").getAsBoolean();
        Task task = Task.fromJson(json.get("task").getAsJsonObject());
        return new NotTask(b, task);
    }

    @Override
    public Component text(Player player) {
        return Text.create("!").add(this.task.text(player)).asComponent();
    }

    public NotTask(boolean visible, Task task) {
        this.visible = visible;
        this.task = task;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public Task getTask() {
        return this.task;
    }
}

