/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.compat.jei.category;

import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import ru.blatfan.blatapi.BlatApi;
import ru.blatfan.blatapi.common.recipe.IAnvilRecipe;
import ru.blatfan.blatapi.utils.ItemHelper;

public final class AnvilRecipeCategory
implements IRecipeCategory<IAnvilRecipe> {
    private static final ResourceLocation TEXTURE = BlatApi.loc("textures/gui/jei/anvil.png");
    public static final RecipeType<IAnvilRecipe> RECIPE_TYPE = RecipeType.create((String)"blatapi", (String)"anvil", IAnvilRecipe.class);
    private final IDrawable background;
    private final IDrawable shapeless;
    private final IDrawable icon;

    public AnvilRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 152, 79);
        this.shapeless = helper.createDrawable(TEXTURE, 153, 0, 18, 16);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blocks.f_50322_));
    }

    public RecipeType<IAnvilRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"block.minecraft.anvil");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(IAnvilRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        Font font = Minecraft.m_91087_().f_91062_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        graphics.m_280430_(font, (Component)Component.m_237113_((String)recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()).m_41786_().getString()), 46, 17, -1);
        if (recipe.isShapeless()) {
            this.shapeless.draw(graphics, 135, 62);
        }
        if (!recipe.getReturns().stream().allMatch(ItemStack::m_41619_)) {
            ItemStack item;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
            if (!recipe.getReturn(0).m_41619_() && mouseX > 9.0 && mouseX < 26.0 && mouseY > 39.0 && mouseY < 56.0) {
                item = recipe.getReturn(0);
                graphics.m_280480_(item, (int)mouseX + 12, (int)mouseY + 30);
                graphics.m_280370_(font, item, (int)mouseX + 12, (int)mouseY + 30);
            }
            if (!recipe.getReturn(1).m_41619_() && mouseX > 58.0 && mouseX < 75.0 && mouseY > 39.0 && mouseY < 56.0) {
                item = recipe.getReturn(1);
                graphics.m_280480_(item, (int)mouseX + 12, (int)mouseY + 30);
                graphics.m_280370_(font, item, (int)mouseX + 12, (int)mouseY + 30);
            }
            graphics.m_280168_().m_85849_();
        }
        if (recipe.getExperience() > 0) {
            graphics.m_280488_(font, Component.m_237110_((String)"container.repair.cost", (Object[])new Object[]{recipe.getExperience() < 0 ? "err" : String.valueOf(recipe.getExperience())}).getString(), 9, 65, player == null || player.m_7500_() || recipe.getExperience() < 40 && recipe.getExperience() <= player.f_36078_ ? -8323296 : -40864);
        }
    }

    public List<Component> getTooltipStrings(IAnvilRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (recipe.isShapeless() && mouseX > 135.0 && mouseX < (double)(this.shapeless.getWidth() + 135) && mouseY > 62.0 && mouseY < (double)(this.shapeless.getHeight() + 62)) {
            return List.of(Component.m_237115_((String)"tooltip.blatapi.shapeless"));
        }
        return super.getTooltipStrings((Object)recipe, recipeSlotsView, mouseX, mouseY);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IAnvilRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(recipe.isConsuming(0) ? RecipeIngredientRole.INPUT : RecipeIngredientRole.CATALYST, 10, 40).addItemStacks(Arrays.stream(recipe.getInput(0).m_43908_()).map(stack -> ItemHelper.withSize(stack, recipe.getInputCount(0), false)).peek(stack -> stack.m_41751_(recipe.getInputNbt(0))).toList())).addTooltipCallback((slotView, tooltip) -> {
            tooltip.add(Component.m_237115_((String)"tooltip.blatapi.consumes").m_130946_(": ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)(recipe.isConsuming(0) ? Component.m_237113_((String)"Yes").m_130940_(ChatFormatting.RED) : Component.m_237113_((String)"No").m_130940_(ChatFormatting.GREEN))));
            if (recipe.isUsingDurability(0)) {
                tooltip.add(Component.m_237115_((String)"tooltip.blatapi.uses_durability").m_130946_(": ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)"tooltip.blatapi.yes").m_130940_(ChatFormatting.RED)));
            }
            if (recipe.hasNbt(0)) {
                tooltip.add(Component.m_237115_((String)"tooltip.blatapi.strict_nbt").m_130946_(": ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)(recipe.isNbtStrict(0) ? Component.m_237115_((String)"tooltip.blatapi.yes").m_130940_(ChatFormatting.RED) : Component.m_237115_((String)"tooltip.blatapi.no").m_130940_(ChatFormatting.GREEN))));
            }
            if (!recipe.getReturn(0).m_41619_()) {
                tooltip.add(Component.m_237115_((String)"tooltip.blatapi.returns").m_130946_(": ").m_130940_(ChatFormatting.GRAY));
                tooltip.add(Component.m_237119_());
                tooltip.add(Component.m_237119_());
            }
        });
        ((IRecipeSlotBuilder)builder.addSlot(recipe.isConsuming(1) ? RecipeIngredientRole.INPUT : RecipeIngredientRole.CATALYST, 59, 40).addItemStacks(Arrays.stream(recipe.getInput(1).m_43908_()).map(stack -> ItemHelper.withSize(stack, recipe.getInputCount(1), false)).peek(stack -> stack.m_41751_(recipe.getInputNbt(1))).toList())).addTooltipCallback((slotView, tooltip) -> {
            tooltip.add(Component.m_237115_((String)"tooltip.blatapi.consumes").m_130946_(": ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)(recipe.isConsuming(1) ? Component.m_237113_((String)"Yes").m_130940_(ChatFormatting.RED) : Component.m_237113_((String)"No").m_130940_(ChatFormatting.GREEN))));
            if (recipe.isUsingDurability(1)) {
                tooltip.add(Component.m_237115_((String)"tooltip.blatapi.uses_durability").m_130946_(": ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)"tooltip.blatapi.yes").m_130940_(ChatFormatting.RED)));
            }
            if (recipe.hasNbt(1)) {
                tooltip.add(Component.m_237115_((String)"tooltip.blatapi.strict_nbt").m_130946_(": ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)(recipe.isNbtStrict(1) ? Component.m_237115_((String)"tooltip.blatapi.yes").m_130940_(ChatFormatting.RED) : Component.m_237115_((String)"tooltip.blatapi.no").m_130940_(ChatFormatting.GREEN))));
            }
            if (!recipe.getReturn(1).m_41619_()) {
                tooltip.add(Component.m_237115_((String)"tooltip.blatapi.returns").m_130946_(": ").m_130940_(ChatFormatting.GRAY));
                tooltip.add(Component.m_237119_());
                tooltip.add(Component.m_237119_());
            }
        });
        builder.addSlot(RecipeIngredientRole.OUTPUT, 117, 40).addItemStack(recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()));
        if (!recipe.getReturn(0).m_41619_()) {
            builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(recipe.getReturn(0));
        }
        if (!recipe.getReturn(1).m_41619_()) {
            builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(recipe.getReturn(1));
        }
    }
}

