/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.fluffy_fur.client.gui.components;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LogoRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ru.blatfan.blatapi.utils.animation.AnimationCurve;
import ru.blatfan.blatapi.utils.collection.Vector3;

@OnlyIn(value=Dist.CLIENT)
public class FluffyFurLogoRenderer
extends LogoRenderer {
    public ResourceLocation logo;
    private float ticks = 0.0f;
    private boolean invert = false;

    public FluffyFurLogoRenderer(ResourceLocation logo, boolean keepLogoThroughFade) {
        super(keepLogoThroughFade);
        this.logo = logo;
    }

    public void m_280037_(GuiGraphics guiGraphics, int screenWidth, float transparency) {
        this.ticks += this.invert ? -AnimationCurve.timeUnite() : AnimationCurve.timeUnite();
        float time = this.ticks / 40.0f % 20.0f;
        if (time >= 1.0f) {
            this.invert = true;
        }
        if (time <= 0.0f) {
            this.invert = false;
        }
        Vector3 pos = AnimationCurve.bezier(new Vector3(-6.0, 32.0, 0.0), new Vector3(6.0, 27.0, 0.0), new Vector3(6.0, 27.0, 0.0), new Vector3(-6.0, 32.0, 0.0), time);
        this.renderSmoothLogo(guiGraphics, (double)screenWidth + pos.x, transparency, pos.y);
    }

    public void m_280118_(GuiGraphics guiGraphics, int screenWidth, float transparency, int height) {
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, this.f_263708_ ? 1.0f : transparency);
        int i = screenWidth / 2 - 128;
        guiGraphics.m_280163_(this.logo, i, height, 0.0f, 0.0f, 256, 64, 256, 64);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderSmoothLogo(GuiGraphics guiGraphics, double screenWidth, float transparency, double height) {
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, this.f_263708_ ? 1.0f : transparency);
        double i = screenWidth / 2.0 - 128.0;
        PoseStack pose = guiGraphics.m_280168_();
        pose.m_85836_();
        pose.m_85837_(i, height, 0.0);
        guiGraphics.m_280163_(this.logo, 0, 0, 0.0f, 0.0f, 256, 64, 256, 64);
        pose.m_85849_();
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

