/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.fluffy_fur.client.gui.components;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import ru.blatfan.blatapi.fluffy_fur.client.event.FluffyFurClientEvents;
import ru.blatfan.blatapi.fluffy_fur.common.creativetab.MultiCreativeTab;
import ru.blatfan.blatapi.fluffy_fur.common.creativetab.SubCreativeTab;

public class SubCreativeTabButton
extends Button {
    public CreativeModeInventoryScreen screen;
    public MultiCreativeTab multiTab;
    public SubCreativeTab subTab;
    public int ry;
    public int rx;
    public int arrow = 0;

    public SubCreativeTabButton(CreativeModeInventoryScreen screen, MultiCreativeTab multiTab, SubCreativeTab subTab, int x, int y, int ry) {
        super(x, y, 20, 20, (Component)Component.m_237119_(), SubCreativeTabButton::click, f_252438_);
        this.screen = screen;
        this.multiTab = multiTab;
        this.subTab = subTab;
        this.rx = x;
        this.ry = ry;
        this.refreshSub();
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.arrow == 0) {
            if (this.subTab.getSubTabImage() == null) {
                super.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
            } else {
                guiGraphics.m_280163_(this.subTab.getSubTabImage(), this.m_252754_(), this.m_252907_(), this.m_198029_() ? 20.0f : 0.0f, 0.0f, 20, 20, 64, 64);
            }
            if (this.subTab.getSubIconItem() != null) {
                guiGraphics.m_280480_(this.subTab.getSubIconItem(), this.m_252754_() + 2, this.m_252907_() + 2);
            } else if (this.multiTab.m_40787_() != null) {
                guiGraphics.m_280480_(this.multiTab.m_40787_(), this.m_252754_() + 2, this.m_252907_() + 2);
            }
            if (mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX <= this.m_252754_() + 20 && mouseY < this.m_252907_() + 20) {
                ArrayList<Component> list = new ArrayList<Component>();
                if (this.subTab.getSubDisplayName() != null) {
                    list.add(this.subTab.getSubDisplayName());
                } else if (this.multiTab.m_40786_() != null) {
                    list.add(this.multiTab.m_40786_());
                }
                guiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, list, Optional.empty(), mouseX, mouseY);
            }
        } else {
            guiGraphics.m_280163_(this.multiTab.getSubArrowsImage(), this.m_252754_(), this.m_252907_(), this.m_198029_() ? 20.0f : 0.0f, this.arrow == 1 ? 20.0f : 0.0f, 20, 20, 64, 64);
        }
    }

    public static void click(Button button) {
        if (button instanceof SubCreativeTabButton) {
            SubCreativeTabButton subButton = (SubCreativeTabButton)button;
            if (subButton.arrow == 0) {
                subButton.multiTab.setCurrentSubTab(subButton.subTab);
                subButton.screen.f_98508_ = 0.0f;
                subButton.screen.m_257687_(subButton.multiTab.m_260957_());
            } else {
                subButton.multiTab.scroll += subButton.arrow;
            }
            for (SubCreativeTabButton sb : FluffyFurClientEvents.subCreativeTabButtons) {
                if (!((Object)((Object)sb.multiTab)).equals((Object)subButton.multiTab)) continue;
                sb.refreshSub();
            }
        }
    }

    public boolean m_93696_() {
        return false;
    }

    public void refreshSub() {
        this.refreshSubVisible(CreativeModeInventoryScreen.f_98507_);
        if (this.multiTab.getCurrentSubTab().equals(this.subTab) && this.arrow == 0) {
            this.m_252865_(this.rx - 4);
        } else {
            this.m_252865_(this.rx);
        }
        if (this.multiTab.getSortedSubTabs().contains(this.subTab)) {
            int i = this.multiTab.getSortedSubTabs().indexOf(this.subTab);
            this.m_253211_(this.ry + (i - this.multiTab.scroll) * 22);
        }
    }

    public void refreshSubVisible(CreativeModeTab tab) {
        boolean exist = tab.equals((Object)this.multiTab);
        if (exist) {
            if (this.multiTab.getSortedSubTabs().contains(this.subTab)) {
                int i = this.multiTab.getSortedSubTabs().indexOf(this.subTab);
                this.f_93624_ = i - this.multiTab.scroll >= -1 && i - this.multiTab.scroll < 7;
                this.arrow = 0;
                if (this.multiTab.scroll > 0 && i - this.multiTab.scroll == -1) {
                    this.arrow = -1;
                }
                if (i - this.multiTab.scroll == 6) {
                    this.arrow = 1;
                }
            } else {
                this.f_93624_ = false;
            }
        } else {
            this.f_93624_ = false;
        }
    }
}

