/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.fluffy_fur.client.playerskin;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import ru.blatfan.blatapi.fluffy_fur.client.event.ClientTickHandler;
import ru.blatfan.blatapi.fluffy_fur.client.model.playerskin.PlayerSkinData;
import ru.blatfan.blatapi.fluffy_fur.client.playerskin.PlayerSkinHandler;

public class PlayerSkin {
    public String id;
    public boolean slim = false;
    public ResourceLocation skinTexture;
    public ResourceLocation skinBlinkTexture;
    public int blinkTime = 3;
    public int blinkMinDelay = 40;
    public int blinkMaxDelay = 100;
    public static Random random = new Random();

    public PlayerSkin(String id) {
        this.id = id;
    }

    public PlayerSkin setSlim(boolean slim) {
        this.slim = slim;
        return this;
    }

    public PlayerSkin setSkinTexture(ResourceLocation skinTexture) {
        this.skinTexture = skinTexture;
        return this;
    }

    public PlayerSkin setSkinBlinkTexture(ResourceLocation skinBlinkTexture) {
        this.skinBlinkTexture = skinBlinkTexture;
        return this;
    }

    public PlayerSkin setBlinkTime(int blinkTime) {
        this.blinkTime = blinkTime;
        return this;
    }

    public PlayerSkin setBlinkDelay(int blinkMinDelay, int blinkMaxDelay) {
        this.blinkMinDelay = blinkMinDelay;
        this.blinkMaxDelay = blinkMaxDelay;
        return this;
    }

    public ResourceLocation getSkin(Player player) {
        PlayerSkinData data = this.getData(player);
        int ticks = ClientTickHandler.ticksInGame;
        if (data.getBlinkTick() < ticks) {
            return this.skinBlinkTexture;
        }
        return this.skinTexture;
    }

    public boolean getSlim(Player player) {
        return this.slim;
    }

    public PlayerSkinData getDefaultData() {
        return new PlayerSkinData();
    }

    public PlayerSkinData getData(Player player) {
        PlayerSkinData data = PlayerSkinHandler.getSkinData(player);
        if (data == null) {
            data = this.getDefaultData();
            PlayerSkinHandler.setSkinData(player, data);
            return data;
        }
        return data;
    }

    public void tick(Player player) {
        PlayerSkinData data = this.getData(player);
        int ticks = ClientTickHandler.ticksInGame;
        if (data.getBlinkTick() + this.blinkTime < ticks) {
            data.setBlinkTick(ClientTickHandler.ticksInGame + random.nextInt(this.blinkMinDelay, this.blinkMaxDelay));
        }
    }

    public void extraRender(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Player player, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch, HumanoidModel defaultModel) {
    }

    public static ResourceLocation getSkinLocation(String mod, String texture) {
        return new ResourceLocation(mod, "textures/entity/skin/" + texture + ".png");
    }

    public String getId() {
        return this.id;
    }
}

