/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.fluffy_fur.client.render;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import ru.blatfan.blatapi.fluffy_fur.client.event.ClientTickHandler;
import ru.blatfan.blatapi.fluffy_fur.client.render.LevelRenderHandler;
import ru.blatfan.blatapi.fluffy_fur.client.render.trail.TrailPoint;
import ru.blatfan.blatapi.fluffy_fur.client.render.trail.TrailRenderPoint;
import ru.blatfan.blatapi.utils.GuiUtil;

public class RenderBuilder {
    public float r1 = 1.0f;
    public float g1 = 1.0f;
    public float b1 = 1.0f;
    public float a1 = 1.0f;
    public float r2 = 1.0f;
    public float g2 = 1.0f;
    public float b2 = 1.0f;
    public float a2 = 1.0f;
    public float r3 = 1.0f;
    public float g3 = 1.0f;
    public float b3 = 1.0f;
    public float a3 = 1.0f;
    public int l1 = GuiUtil.FULL_BRIGHT;
    public int l2 = GuiUtil.FULL_BRIGHT;
    public int l3 = GuiUtil.FULL_BRIGHT;
    public float u0 = 0.0f;
    public float v0 = 0.0f;
    public float u1 = 1.0f;
    public float v1 = 1.0f;
    public float u2 = 0.0f;
    public float v2 = 0.0f;
    public float u3 = 1.0f;
    public float v3 = 1.0f;
    public float u4 = 0.0f;
    public float v4 = 0.0f;
    public float u5 = 1.0f;
    public float v5 = 1.0f;
    public boolean firstSide = true;
    public boolean secondSide = false;
    protected MultiBufferSource bufferSource = LevelRenderHandler.DELAYED_RENDER;
    protected RenderType renderType;
    protected VertexFormat format;
    protected VertexConsumerActor supplier;
    protected VertexConsumer vertexConsumer;
    public static final HashMap<VertexFormatElement, VertexConsumerActor> CONSUMER_INFO_MAP = new HashMap();
    private static final float ROOT_3 = (float)(Math.sqrt(3.0) / 2.0);

    public static RenderBuilder create() {
        return new RenderBuilder();
    }

    public RenderBuilder replaceBufferSource(MultiBufferSource bufferSource) {
        this.bufferSource = bufferSource;
        return this;
    }

    public RenderBuilder setRenderType(RenderType renderType) {
        return this.setRenderTypeRaw(renderType).setFormat(renderType.m_110508_()).setVertexConsumer(this.bufferSource.m_6299_(renderType));
    }

    public RenderBuilder setRenderTypeRaw(RenderType renderType) {
        this.renderType = renderType;
        return this;
    }

    public RenderBuilder setFormat(VertexFormat format) {
        ImmutableList elements = format.m_86023_();
        return this.setFormatRaw(format).setVertexSupplier((consumer, last, builder, x, y, z, r, g, b, a, u, v, l) -> {
            for (VertexFormatElement element : elements) {
                CONSUMER_INFO_MAP.get(element).placeVertex(consumer, last, this, x, y, z, r, g, b, a, u, v, l);
            }
            consumer.m_5752_();
        });
    }

    public RenderBuilder setFormatRaw(VertexFormat format) {
        this.format = format;
        return this;
    }

    public RenderBuilder setVertexSupplier(VertexConsumerActor supplier) {
        this.supplier = supplier;
        return this;
    }

    public RenderBuilder setVertexConsumer(VertexConsumer vertexConsumer) {
        this.vertexConsumer = vertexConsumer;
        return this;
    }

    public VertexConsumer getVertexConsumer() {
        if (this.vertexConsumer == null) {
            this.setVertexConsumer(this.bufferSource.m_6299_(this.renderType));
        }
        return this.vertexConsumer;
    }

    public MultiBufferSource getBufferSource() {
        return this.bufferSource;
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    public VertexFormat getFormat() {
        return this.format;
    }

    public VertexConsumerActor getSupplier() {
        return this.supplier;
    }

    public RenderBuilder setColor(Color color) {
        return this.setColor(color.getRed(), color.getGreen(), color.getBlue());
    }

    public RenderBuilder setColor(Color color, float a) {
        return this.setFirstColor(color).setFirstAlpha(a).setSecondColor(color).setSecondAlpha(a).setThirdColor(color).setThirdAlpha(a);
    }

    public RenderBuilder setColor(float r, float g, float b, float a) {
        return this.setFirstColor(r, g, b).setFirstAlpha(a).setSecondColor(r, g, b).setSecondAlpha(a).setThirdColor(r, g, b).setThirdAlpha(a);
    }

    public RenderBuilder setColor(float r, float g, float b) {
        this.setFirstColor(r, g, b).setSecondColor(r, g, b).setThirdColor(r, g, b);
        return this;
    }

    public RenderBuilder setColorRaw(float r, float g, float b) {
        return this.setFirstColorRaw(r, g, b).setSecondColorRaw(r, g, b).setThirdColorRaw(r, g, b);
    }

    public RenderBuilder setAlpha(float a) {
        return this.setFirstAlpha(a).setSecondAlpha(a).setThirdAlpha(a);
    }

    public RenderBuilder setLight(int light) {
        return this.setFirstLight(light).setSecondLight(light);
    }

    public RenderBuilder setFirstColor(Color color) {
        return this.setFirstColor(color.getRed(), color.getGreen(), color.getBlue());
    }

    public RenderBuilder setFirstColor(Color color, float a) {
        return this.setFirstColor(color).setFirstAlpha(a);
    }

    public RenderBuilder setFirstColor(float r, float g, float b, float a) {
        return this.setFirstColor(r, g, b).setFirstAlpha(a);
    }

    public RenderBuilder setFirstColor(float r, float g, float b) {
        this.r1 = r / 255.0f;
        this.g1 = g / 255.0f;
        this.b1 = b / 255.0f;
        return this;
    }

    public RenderBuilder setFirstColorRaw(float r, float g, float b) {
        this.r1 = r;
        this.g1 = g;
        this.b1 = b;
        return this;
    }

    public RenderBuilder setFirstAlpha(float a) {
        this.a1 = a;
        return this;
    }

    public RenderBuilder setFirstLight(int light) {
        this.l1 = light;
        return this;
    }

    public RenderBuilder setSecondColor(Color color) {
        return this.setSecondColor(color.getRed(), color.getGreen(), color.getBlue());
    }

    public RenderBuilder setSecondColor(Color color, float a) {
        return this.setSecondColor(color).setSecondAlpha(a);
    }

    public RenderBuilder setSecondColor(float r, float g, float b, float a) {
        return this.setSecondColor(r, g, b).setSecondAlpha(a);
    }

    public RenderBuilder setSecondColor(float r, float g, float b) {
        this.r2 = r / 255.0f;
        this.g2 = g / 255.0f;
        this.b2 = b / 255.0f;
        return this;
    }

    public RenderBuilder setSecondColorRaw(float r, float g, float b) {
        this.r2 = r;
        this.g2 = g;
        this.b2 = b;
        return this;
    }

    public RenderBuilder setSecondAlpha(float a) {
        this.a2 = a;
        return this;
    }

    public RenderBuilder setSecondLight(int light) {
        this.l2 = light;
        return this;
    }

    public RenderBuilder setThirdColor(Color color) {
        return this.setThirdColor(color.getRed(), color.getGreen(), color.getBlue());
    }

    public RenderBuilder setThirdColor(Color color, float a) {
        return this.setThirdColor(color).setThirdAlpha(a);
    }

    public RenderBuilder setThirdColor(float r, float g, float b, float a) {
        return this.setThirdColor(r, g, b).setThirdAlpha(a);
    }

    public RenderBuilder setThirdColor(float r, float g, float b) {
        this.r3 = r / 255.0f;
        this.g3 = g / 255.0f;
        this.b3 = b / 255.0f;
        return this;
    }

    public RenderBuilder setThirdColorRaw(float r, float g, float b) {
        this.r3 = r;
        this.g3 = g;
        this.b3 = b;
        return this;
    }

    public RenderBuilder setThirdAlpha(float a) {
        this.a3 = a;
        return this;
    }

    public RenderBuilder setThirdLight(int light) {
        this.l3 = light;
        return this;
    }

    public RenderBuilder setUV(float u0, float v0, float u1, float v1) {
        return this.setFirstUV(u0, v0, u1, v1).setSecondUV(u0, v0, u1, v1).setThirdUV(u0, v0, u1, v1);
    }

    public RenderBuilder setUV(TextureAtlasSprite sprite) {
        return this.setUV(sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_());
    }

    public RenderBuilder setFirstUV(float u0, float v0, float u1, float v1) {
        this.u0 = u0;
        this.v0 = v0;
        this.u1 = u1;
        this.v1 = v1;
        return this;
    }

    public RenderBuilder setFirstUV(TextureAtlasSprite sprite) {
        return this.setFirstUV(sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_());
    }

    public RenderBuilder setSecondUV(float u0, float v0, float u1, float v1) {
        this.u2 = u0;
        this.v2 = v0;
        this.u3 = u1;
        this.v3 = v1;
        return this;
    }

    public RenderBuilder setSecondUV(TextureAtlasSprite sprite) {
        return this.setSecondUV(sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_());
    }

    public RenderBuilder setThirdUV(float u0, float v0, float u1, float v1) {
        this.u4 = u0;
        this.v4 = v0;
        this.u5 = u1;
        this.v5 = v1;
        return this;
    }

    public RenderBuilder setThirdUV(TextureAtlasSprite sprite) {
        return this.setThirdUV(sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_());
    }

    public RenderBuilder enableSided() {
        return this.setSided(true);
    }

    public RenderBuilder disableSided() {
        return this.setSided(false);
    }

    public RenderBuilder setSided(boolean side) {
        return this.setFirstSide(side).setSecondSide(side);
    }

    public RenderBuilder enableFirstSide() {
        return this.setFirstSide(true);
    }

    public RenderBuilder disableFirstSide() {
        return this.setFirstSide(false);
    }

    public RenderBuilder setFirstSide(boolean side) {
        this.firstSide = side;
        return this;
    }

    public RenderBuilder enableSecondSide() {
        return this.setSecondSide(true);
    }

    public RenderBuilder disableSecondSide() {
        return this.setSecondSide(false);
    }

    public RenderBuilder setSecondSide(boolean side) {
        this.secondSide = side;
        return this;
    }

    public RenderBuilder setSided(boolean firstSide, boolean secondSide) {
        return this.setFirstSide(firstSide).setSecondSide(secondSide);
    }

    public RenderBuilder endBatch() {
        ((MultiBufferSource.BufferSource)this.getBufferSource()).m_109911_();
        return this;
    }

    public RenderBuilder renderQuad(PoseStack stack, float size) {
        return this.renderQuad(stack, size, size);
    }

    public RenderBuilder renderQuad(PoseStack stack, float width, float height) {
        Vector3f[] positions = new Vector3f[]{new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f)};
        return this.renderQuad(stack, positions, width, height);
    }

    public RenderBuilder renderCenteredQuad(PoseStack stack, float size) {
        return this.renderCenteredQuad(stack, size, size);
    }

    public RenderBuilder renderCenteredQuad(PoseStack stack, float width, float height) {
        Vector3f[] positions = new Vector3f[]{new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, -1.0f, 0.0f)};
        return this.renderQuad(stack, positions, width, height);
    }

    public RenderBuilder renderQuad(PoseStack stack, Vector3f[] positions, float size) {
        return this.renderQuad(stack, positions, size, size);
    }

    public RenderBuilder renderQuad(PoseStack stack, Vector3f[] positions, float width, float height) {
        for (Vector3f position : positions) {
            position.mul(width, height, width);
        }
        return this.renderQuad(stack.m_85850_().m_252922_(), positions);
    }

    public RenderBuilder renderQuad(Matrix4f last, Vector3f[] positions) {
        if (this.firstSide) {
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[0].x(), positions[0].y(), positions[0].z(), this.r1, this.g1, this.b1, this.a1, this.u0, this.v1, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[1].x(), positions[1].y(), positions[1].z(), this.r1, this.g1, this.b1, this.a1, this.u1, this.v1, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[2].x(), positions[2].y(), positions[2].z(), this.r1, this.g1, this.b1, this.a1, this.u1, this.v0, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[3].x(), positions[3].y(), positions[3].z(), this.r1, this.g1, this.b1, this.a1, this.u0, this.v0, this.l1);
        }
        if (this.secondSide) {
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[3].x(), positions[3].y(), positions[3].z(), this.r1, this.g1, this.b1, this.a1, this.u0, this.v0, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[2].x(), positions[2].y(), positions[2].z(), this.r1, this.g1, this.b1, this.a1, this.u1, this.v0, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[1].x(), positions[1].y(), positions[1].z(), this.r1, this.g1, this.b1, this.a1, this.u1, this.v1, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[0].x(), positions[0].y(), positions[0].z(), this.r1, this.g1, this.b1, this.a1, this.u0, this.v1, this.l1);
        }
        return this;
    }

    public RenderBuilder renderCube(PoseStack stack, float size) {
        return this.renderCube(stack, size, size, size);
    }

    public RenderBuilder renderCube(PoseStack stack, float width, float height, float length) {
        Vector3f[] positions;
        for (Vector3f position : positions = new Vector3f[]{new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, 0.0f)}) {
            position.mul(width, height, length);
        }
        return this.renderCube(stack.m_85850_().m_252922_(), positions);
    }

    public RenderBuilder renderCenteredCube(PoseStack stack, float size) {
        return this.renderCenteredCube(stack, size, size, size);
    }

    public RenderBuilder renderCenteredCube(PoseStack stack, float width, float height, float length) {
        Vector3f[] positions;
        for (Vector3f position : positions = new Vector3f[]{new Vector3f(-1.0f, 1.0f, -1.0f), new Vector3f(-1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, -1.0f), new Vector3f(1.0f, -1.0f, -1.0f), new Vector3f(1.0f, -1.0f, 1.0f), new Vector3f(-1.0f, -1.0f, 1.0f), new Vector3f(-1.0f, -1.0f, -1.0f)}) {
            position.mul(width, height, length);
        }
        return this.renderCube(stack.m_85850_().m_252922_(), positions);
    }

    public RenderBuilder renderCube(Matrix4f last, Vector3f[] positions) {
        if (this.firstSide) {
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[0].x(), positions[0].y(), positions[0].z(), this.r1, this.g1, this.b1, this.a1, this.u0, this.v0, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[1].x(), positions[1].y(), positions[1].z(), this.r1, this.g1, this.b1, this.a1, this.u1, this.v0, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[2].x(), positions[2].y(), positions[2].z(), this.r1, this.g1, this.b1, this.a1, this.u1, this.v1, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[3].x(), positions[3].y(), positions[3].z(), this.r1, this.g1, this.b1, this.a1, this.u0, this.v1, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[4].x(), positions[4].y(), positions[4].z(), this.r1, this.g1, this.b1, this.a1, this.u0, this.v0, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[5].x(), positions[5].y(), positions[5].z(), this.r1, this.g1, this.b1, this.a1, this.u1, this.v0, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[6].x(), positions[6].y(), positions[6].z(), this.r1, this.g1, this.b1, this.a1, this.u1, this.v1, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[7].x(), positions[7].y(), positions[7].z(), this.r1, this.g1, this.b1, this.a1, this.u0, this.v1, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[6].x(), positions[6].y(), positions[6].z(), this.r1, this.g1, this.b1, this.a1, this.u2, this.v3, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[5].x(), positions[5].y(), positions[5].z(), this.r1, this.g1, this.b1, this.a1, this.u3, this.v3, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[2].x(), positions[2].y(), positions[2].z(), this.r1, this.g1, this.b1, this.a1, this.u3, this.v2, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[1].x(), positions[1].y(), positions[1].z(), this.r1, this.g1, this.b1, this.a1, this.u2, this.v2, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[0].x(), positions[0].y(), positions[0].z(), this.r1, this.g1, this.b1, this.a1, this.u2, this.v2, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[3].x(), positions[3].y(), positions[3].z(), this.r1, this.g1, this.b1, this.a1, this.u3, this.v2, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[4].x(), positions[4].y(), positions[4].z(), this.r1, this.g1, this.b1, this.a1, this.u3, this.v3, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[7].x(), positions[7].y(), positions[7].z(), this.r1, this.g1, this.b1, this.a1, this.u2, this.v3, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[3].x(), positions[3].y(), positions[3].z(), this.r1, this.g1, this.b1, this.a1, this.u4, this.v4, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[2].x(), positions[2].y(), positions[2].z(), this.r1, this.g1, this.b1, this.a1, this.u5, this.v4, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[5].x(), positions[5].y(), positions[5].z(), this.r1, this.g1, this.b1, this.a1, this.u5, this.v5, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[4].x(), positions[4].y(), positions[4].z(), this.r1, this.g1, this.b1, this.a1, this.u4, this.v5, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[7].x(), positions[7].y(), positions[7].z(), this.r1, this.g1, this.b1, this.a1, this.u4, this.v5, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[6].x(), positions[6].y(), positions[6].z(), this.r1, this.g1, this.b1, this.a1, this.u5, this.v5, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[1].x(), positions[1].y(), positions[1].z(), this.r1, this.g1, this.b1, this.a1, this.u5, this.v4, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[0].x(), positions[0].y(), positions[0].z(), this.r1, this.g1, this.b1, this.a1, this.u4, this.v4, this.l1);
        }
        if (this.secondSide) {
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[3].x(), positions[3].y(), positions[3].z(), this.r1, this.g1, this.b1, this.a1, this.u0, this.v1, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[2].x(), positions[2].y(), positions[2].z(), this.r1, this.g1, this.b1, this.a1, this.u1, this.v1, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[1].x(), positions[1].y(), positions[1].z(), this.r1, this.g1, this.b1, this.a1, this.u1, this.v0, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[0].x(), positions[0].y(), positions[0].z(), this.r1, this.g1, this.b1, this.a1, this.u0, this.v0, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[7].x(), positions[7].y(), positions[7].z(), this.r1, this.g1, this.b1, this.a1, this.u0, this.v1, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[6].x(), positions[6].y(), positions[6].z(), this.r1, this.g1, this.b1, this.a1, this.u1, this.v1, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[5].x(), positions[5].y(), positions[5].z(), this.r1, this.g1, this.b1, this.a1, this.u1, this.v0, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[4].x(), positions[4].y(), positions[4].z(), this.r1, this.g1, this.b1, this.a1, this.u0, this.v0, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[1].x(), positions[1].y(), positions[1].z(), this.r1, this.g1, this.b1, this.a1, this.u2, this.v2, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[2].x(), positions[2].y(), positions[2].z(), this.r1, this.g1, this.b1, this.a1, this.u3, this.v2, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[5].x(), positions[5].y(), positions[5].z(), this.r1, this.g1, this.b1, this.a1, this.u3, this.v3, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[6].x(), positions[6].y(), positions[6].z(), this.r1, this.g1, this.b1, this.a1, this.u2, this.v3, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[7].x(), positions[7].y(), positions[7].z(), this.r1, this.g1, this.b1, this.a1, this.u2, this.v3, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[4].x(), positions[4].y(), positions[4].z(), this.r1, this.g1, this.b1, this.a1, this.u3, this.v3, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[3].x(), positions[3].y(), positions[3].z(), this.r1, this.g1, this.b1, this.a1, this.u3, this.v2, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[0].x(), positions[0].y(), positions[0].z(), this.r1, this.g1, this.b1, this.a1, this.u2, this.v2, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[4].x(), positions[4].y(), positions[4].z(), this.r1, this.g1, this.b1, this.a1, this.u4, this.v5, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[5].x(), positions[5].y(), positions[5].z(), this.r1, this.g1, this.b1, this.a1, this.u5, this.v5, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[2].x(), positions[2].y(), positions[2].z(), this.r1, this.g1, this.b1, this.a1, this.u5, this.v4, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[3].x(), positions[3].y(), positions[3].z(), this.r1, this.g1, this.b1, this.a1, this.u4, this.v4, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[0].x(), positions[0].y(), positions[0].z(), this.r1, this.g1, this.b1, this.a1, this.u4, this.v4, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[1].x(), positions[1].y(), positions[1].z(), this.r1, this.g1, this.b1, this.a1, this.u5, this.v4, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[6].x(), positions[6].y(), positions[6].z(), this.r1, this.g1, this.b1, this.a1, this.u5, this.v5, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[7].x(), positions[7].y(), positions[7].z(), this.r1, this.g1, this.b1, this.a1, this.u4, this.v5, this.l1);
        }
        return this;
    }

    public RenderBuilder renderRay(PoseStack stack, float width, float height) {
        return this.renderRay(stack, width, height, 1.0f);
    }

    public RenderBuilder renderRay(PoseStack stack, float width, float height, float endOffset) {
        int i;
        Vector3f[] positions = new Vector3f[]{new Vector3f(-1.0f, 1.0f, -1.0f), new Vector3f(-1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, -1.0f), new Vector3f(1.0f, -1.0f, -1.0f), new Vector3f(1.0f, -1.0f, 1.0f), new Vector3f(-1.0f, -1.0f, 1.0f), new Vector3f(-1.0f, -1.0f, -1.0f)};
        for (i = 0; i < 4; ++i) {
            positions[i].mul(width * endOffset, height, width * endOffset);
        }
        for (i = 0; i < 4; ++i) {
            positions[i + 4].mul(width);
        }
        return this.renderRay(stack.m_85850_().m_252922_(), positions);
    }

    public RenderBuilder renderRay(Matrix4f last, Vector3f[] positions) {
        if (this.firstSide) {
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[0].x(), positions[0].y(), positions[0].z(), this.r2, this.g2, this.b2, this.a2, this.u0, this.v0, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[1].x(), positions[1].y(), positions[1].z(), this.r2, this.g2, this.b2, this.a2, this.u1, this.v0, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[2].x(), positions[2].y(), positions[2].z(), this.r2, this.g2, this.b2, this.a2, this.u1, this.v1, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[3].x(), positions[3].y(), positions[3].z(), this.r2, this.g2, this.b2, this.a2, this.u0, this.v1, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[4].x(), positions[4].y(), positions[4].z(), this.r1, this.g1, this.b1, this.a1, this.u0, this.v0, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[5].x(), positions[5].y(), positions[5].z(), this.r1, this.g1, this.b1, this.a1, this.u1, this.v0, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[6].x(), positions[6].y(), positions[6].z(), this.r1, this.g1, this.b1, this.a1, this.u1, this.v1, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[7].x(), positions[7].y(), positions[7].z(), this.r1, this.g1, this.b1, this.a1, this.u0, this.v1, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[6].x(), positions[6].y(), positions[6].z(), this.r1, this.g1, this.b1, this.a1, this.u2, this.v3, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[5].x(), positions[5].y(), positions[5].z(), this.r1, this.g1, this.b1, this.a1, this.u3, this.v3, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[2].x(), positions[2].y(), positions[2].z(), this.r2, this.g2, this.b2, this.a2, this.u3, this.v2, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[1].x(), positions[1].y(), positions[1].z(), this.r2, this.g2, this.b2, this.a2, this.u2, this.v2, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[0].x(), positions[0].y(), positions[0].z(), this.r2, this.g2, this.b2, this.a2, this.u2, this.v2, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[3].x(), positions[3].y(), positions[3].z(), this.r2, this.g2, this.b2, this.a2, this.u3, this.v2, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[4].x(), positions[4].y(), positions[4].z(), this.r1, this.g1, this.b1, this.a1, this.u3, this.v3, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[7].x(), positions[7].y(), positions[7].z(), this.r1, this.g1, this.b1, this.a1, this.u2, this.v3, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[3].x(), positions[3].y(), positions[3].z(), this.r2, this.g2, this.b2, this.a2, this.u4, this.v4, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[2].x(), positions[2].y(), positions[2].z(), this.r2, this.g2, this.b2, this.a2, this.u5, this.v4, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[5].x(), positions[5].y(), positions[5].z(), this.r1, this.g1, this.b1, this.a1, this.u5, this.v5, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[4].x(), positions[4].y(), positions[4].z(), this.r1, this.g1, this.b1, this.a1, this.u4, this.v5, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[7].x(), positions[7].y(), positions[7].z(), this.r1, this.g1, this.b1, this.a1, this.u4, this.v5, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[6].x(), positions[6].y(), positions[6].z(), this.r1, this.g1, this.b1, this.a1, this.u5, this.v5, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[1].x(), positions[1].y(), positions[1].z(), this.r2, this.g2, this.b2, this.a2, this.u5, this.v4, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[0].x(), positions[0].y(), positions[0].z(), this.r2, this.g2, this.b2, this.a2, this.u4, this.v4, this.l2);
        }
        if (this.secondSide) {
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[3].x(), positions[3].y(), positions[3].z(), this.r2, this.g2, this.b2, this.a2, this.u0, this.v1, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[2].x(), positions[2].y(), positions[2].z(), this.r2, this.g2, this.b2, this.a2, this.u1, this.v1, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[1].x(), positions[1].y(), positions[1].z(), this.r2, this.g2, this.b2, this.a2, this.u1, this.v0, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[0].x(), positions[0].y(), positions[0].z(), this.r2, this.g2, this.b2, this.a2, this.u0, this.v0, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[7].x(), positions[7].y(), positions[7].z(), this.r1, this.g1, this.b1, this.a1, this.u0, this.v1, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[6].x(), positions[6].y(), positions[6].z(), this.r1, this.g1, this.b1, this.a1, this.u1, this.v1, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[5].x(), positions[5].y(), positions[5].z(), this.r1, this.g1, this.b1, this.a1, this.u1, this.v0, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[4].x(), positions[4].y(), positions[4].z(), this.r1, this.g1, this.b1, this.a1, this.u0, this.v0, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[1].x(), positions[1].y(), positions[1].z(), this.r2, this.g2, this.b2, this.a2, this.u2, this.v2, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[2].x(), positions[2].y(), positions[2].z(), this.r2, this.g2, this.b2, this.a2, this.u3, this.v2, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[5].x(), positions[5].y(), positions[5].z(), this.r1, this.g1, this.b1, this.a1, this.u3, this.v3, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[6].x(), positions[6].y(), positions[6].z(), this.r1, this.g1, this.b1, this.a1, this.u2, this.v3, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[7].x(), positions[7].y(), positions[7].z(), this.r1, this.g1, this.b1, this.a1, this.u2, this.v3, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[4].x(), positions[4].y(), positions[4].z(), this.r1, this.g1, this.b1, this.a1, this.u3, this.v3, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[3].x(), positions[3].y(), positions[3].z(), this.r2, this.g2, this.b2, this.a2, this.u3, this.v2, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[0].x(), positions[0].y(), positions[0].z(), this.r2, this.g2, this.b2, this.a2, this.u2, this.v2, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[4].x(), positions[4].y(), positions[4].z(), this.r1, this.g1, this.b1, this.a1, this.u4, this.v5, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[5].x(), positions[5].y(), positions[5].z(), this.r1, this.g1, this.b1, this.a1, this.u5, this.v5, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[2].x(), positions[2].y(), positions[2].z(), this.r2, this.g2, this.b2, this.a2, this.u5, this.v4, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[3].x(), positions[3].y(), positions[3].z(), this.r2, this.g2, this.b2, this.a2, this.u4, this.v4, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[0].x(), positions[0].y(), positions[0].z(), this.r2, this.g2, this.b2, this.a2, this.u4, this.v4, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[1].x(), positions[1].y(), positions[1].z(), this.r2, this.g2, this.b2, this.a2, this.u5, this.v4, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[6].x(), positions[6].y(), positions[6].z(), this.r1, this.g1, this.b1, this.a1, this.u5, this.v5, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[7].x(), positions[7].y(), positions[7].z(), this.r1, this.g1, this.b1, this.a1, this.u4, this.v5, this.l1);
        }
        return this;
    }

    public RenderBuilder renderBeam(PoseStack stack, float width, float height) {
        return this.renderBeam(stack, width, height, 1.0f);
    }

    public RenderBuilder renderBeam(PoseStack stack, float width, float height, float endOffset) {
        int i;
        Vector3f[] positions = new Vector3f[]{new Vector3f(-1.0f, 1.0f, -1.0f), new Vector3f(-1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, -1.0f), new Vector3f(1.0f, 0.0f, -1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(-1.0f, 0.0f, 1.0f), new Vector3f(-1.0f, 0.0f, -1.0f)};
        for (i = 0; i < 4; ++i) {
            positions[i].mul(width * endOffset, height, width * endOffset);
        }
        for (i = 0; i < 4; ++i) {
            positions[i + 4].mul(width);
        }
        return this.renderBeam(stack.m_85850_().m_252922_(), positions);
    }

    public RenderBuilder renderBeam(Matrix4f last, Vector3f[] positions) {
        if (this.firstSide) {
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[6].x(), positions[6].y(), positions[6].z(), this.r1, this.g1, this.b1, this.a1, this.u2, this.v3, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[5].x(), positions[5].y(), positions[5].z(), this.r1, this.g1, this.b1, this.a1, this.u3, this.v3, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[2].x(), positions[2].y(), positions[2].z(), this.r2, this.g2, this.b2, this.a2, this.u3, this.v2, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[1].x(), positions[1].y(), positions[1].z(), this.r2, this.g2, this.b2, this.a2, this.u2, this.v2, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[0].x(), positions[0].y(), positions[0].z(), this.r2, this.g2, this.b2, this.a2, this.u2, this.v2, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[3].x(), positions[3].y(), positions[3].z(), this.r2, this.g2, this.b2, this.a2, this.u3, this.v2, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[4].x(), positions[4].y(), positions[4].z(), this.r1, this.g1, this.b1, this.a1, this.u3, this.v3, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[7].x(), positions[7].y(), positions[7].z(), this.r1, this.g1, this.b1, this.a1, this.u2, this.v3, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[3].x(), positions[3].y(), positions[3].z(), this.r2, this.g2, this.b2, this.a2, this.u4, this.v4, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[2].x(), positions[2].y(), positions[2].z(), this.r2, this.g2, this.b2, this.a2, this.u5, this.v4, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[5].x(), positions[5].y(), positions[5].z(), this.r1, this.g1, this.b1, this.a1, this.u5, this.v5, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[4].x(), positions[4].y(), positions[4].z(), this.r1, this.g1, this.b1, this.a1, this.u4, this.v5, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[7].x(), positions[7].y(), positions[7].z(), this.r1, this.g1, this.b1, this.a1, this.u4, this.v5, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[6].x(), positions[6].y(), positions[6].z(), this.r1, this.g1, this.b1, this.a1, this.u5, this.v5, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[1].x(), positions[1].y(), positions[1].z(), this.r2, this.g2, this.b2, this.a2, this.u5, this.v4, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[0].x(), positions[0].y(), positions[0].z(), this.r2, this.g2, this.b2, this.a2, this.u4, this.v4, this.l2);
        }
        if (this.secondSide) {
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[1].x(), positions[1].y(), positions[1].z(), this.r2, this.g2, this.b2, this.a2, this.u2, this.v2, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[2].x(), positions[2].y(), positions[2].z(), this.r2, this.g2, this.b2, this.a2, this.u3, this.v2, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[5].x(), positions[5].y(), positions[5].z(), this.r1, this.g1, this.b1, this.a1, this.u3, this.v3, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[6].x(), positions[6].y(), positions[6].z(), this.r1, this.g1, this.b1, this.a1, this.u2, this.v3, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[7].x(), positions[7].y(), positions[7].z(), this.r1, this.g1, this.b1, this.a1, this.u2, this.v3, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[4].x(), positions[4].y(), positions[4].z(), this.r1, this.g1, this.b1, this.a1, this.u3, this.v3, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[3].x(), positions[3].y(), positions[3].z(), this.r2, this.g2, this.b2, this.a2, this.u3, this.v2, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[0].x(), positions[0].y(), positions[0].z(), this.r2, this.g2, this.b2, this.a2, this.u2, this.v2, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[4].x(), positions[4].y(), positions[4].z(), this.r1, this.g1, this.b1, this.a1, this.u4, this.v5, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[5].x(), positions[5].y(), positions[5].z(), this.r1, this.g1, this.b1, this.a1, this.u5, this.v5, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[2].x(), positions[2].y(), positions[2].z(), this.r2, this.g2, this.b2, this.a2, this.u5, this.v4, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[3].x(), positions[3].y(), positions[3].z(), this.r2, this.g2, this.b2, this.a2, this.u4, this.v4, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[0].x(), positions[0].y(), positions[0].z(), this.r2, this.g2, this.b2, this.a2, this.u4, this.v4, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[1].x(), positions[1].y(), positions[1].z(), this.r2, this.g2, this.b2, this.a2, this.u5, this.v4, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[6].x(), positions[6].y(), positions[6].z(), this.r1, this.g1, this.b1, this.a1, this.u5, this.v5, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, positions[7].x(), positions[7].y(), positions[7].z(), this.r1, this.g1, this.b1, this.a1, this.u4, this.v5, this.l1);
        }
        return this;
    }

    public RenderBuilder renderWavyQuad(PoseStack stack, float size, float strength, float time) {
        return this.renderWavyQuad(stack, size, size, strength, time);
    }

    public RenderBuilder renderWavyQuad(PoseStack stack, float width, float height, float strength, float time) {
        Vector3f[] positions = new Vector3f[]{new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, -1.0f, 0.0f)};
        GuiUtil.applyWobble(positions, strength, time);
        return this.renderQuad(stack, positions, width, height);
    }

    public RenderBuilder renderWavyQuad(PoseStack stack, Vector3f[] positions, float width, float height, float strength, float time) {
        GuiUtil.applyWobble(positions, strength, time);
        return this.renderQuad(stack, positions, width, height);
    }

    public RenderBuilder renderWavyCube(PoseStack stack, float size, float strength, float time) {
        return this.renderWavyCube(stack, size, size, size, strength, time);
    }

    public RenderBuilder renderWavyCube(PoseStack stack, float width, float height, float length, float strength, float time) {
        Vector3f[] positions;
        for (Vector3f position : positions = new Vector3f[]{new Vector3f(-1.0f, 1.0f, -1.0f), new Vector3f(-1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, -1.0f), new Vector3f(1.0f, -1.0f, -1.0f), new Vector3f(1.0f, -1.0f, 1.0f), new Vector3f(-1.0f, -1.0f, 1.0f), new Vector3f(-1.0f, -1.0f, -1.0f)}) {
            position.mul(width, height, length);
        }
        GuiUtil.applyWobble(positions, strength, time);
        return this.renderCube(stack.m_85850_().m_252922_(), positions);
    }

    public RenderBuilder renderBeam(@Nullable Matrix4f last, Vec3 start, Vec3 end, float width) {
        Minecraft minecraft = Minecraft.m_91087_();
        Vec3 cameraPosition = minecraft.m_167982_().f_112249_.m_90583_();
        return this.renderBeam(last, start, end, width, width, cameraPosition);
    }

    public RenderBuilder renderBeam(@Nullable Matrix4f last, Vec3 start, Vec3 end, float width1, float width2) {
        Minecraft minecraft = Minecraft.m_91087_();
        Vec3 cameraPosition = minecraft.m_167982_().f_112249_.m_90583_();
        return this.renderBeam(last, start, end, width1, width2, cameraPosition);
    }

    public RenderBuilder renderBeam(@Nullable Matrix4f last, Vec3 start, Vec3 end, float width, Vec3 cameraPosition) {
        return this.renderBeam(last, start, end, width, width, cameraPosition);
    }

    public RenderBuilder renderBeam(@Nullable Matrix4f last, Vec3 start, Vec3 end, float width1, float width2, Vec3 cameraPosition) {
        Vec3 delta = end.m_82546_(start);
        Vec3 normalStart = start.m_82546_(cameraPosition).m_82537_(delta).m_82541_().m_82542_((double)(width1 / 2.0f), (double)(width1 / 2.0f), (double)(width1 / 2.0f));
        Vec3 normalEnd = start.m_82546_(cameraPosition).m_82537_(delta).m_82541_().m_82542_((double)(width2 / 2.0f), (double)(width2 / 2.0f), (double)(width2 / 2.0f));
        Vec3[] positions = new Vec3[]{start.m_82546_(normalStart), start.m_82549_(normalStart), end.m_82549_(normalEnd), end.m_82546_(normalEnd)};
        this.supplier.placeVertex(this.getVertexConsumer(), last, this, (float)positions[0].f_82479_, (float)positions[0].f_82480_, (float)positions[0].f_82481_, this.r1, this.g1, this.b1, this.a1, this.u0, this.v1, this.l1);
        this.supplier.placeVertex(this.getVertexConsumer(), last, this, (float)positions[1].f_82479_, (float)positions[1].f_82480_, (float)positions[1].f_82481_, this.r1, this.g1, this.b1, this.a1, this.u1, this.v1, this.l1);
        this.supplier.placeVertex(this.getVertexConsumer(), last, this, (float)positions[2].f_82479_, (float)positions[2].f_82480_, (float)positions[2].f_82481_, this.r2, this.g2, this.b2, this.a2, this.u1, this.v0, this.l2);
        this.supplier.placeVertex(this.getVertexConsumer(), last, this, (float)positions[3].f_82479_, (float)positions[3].f_82480_, (float)positions[3].f_82481_, this.r2, this.g2, this.b2, this.a2, this.u0, this.v0, this.l2);
        return this;
    }

    public RenderBuilder renderTrail(PoseStack stack, List<TrailPoint> trailSegments, float width) {
        return this.renderTrail(stack, trailSegments, (Float f) -> Float.valueOf(width), (Float f) -> {});
    }

    public RenderBuilder renderTrail(PoseStack stack, List<TrailPoint> trailSegments, Function<Float, Float> widthFunc) {
        return this.renderTrail(stack, trailSegments, widthFunc, (Float f) -> {});
    }

    public RenderBuilder renderTrail(PoseStack stack, List<TrailPoint> trailSegments, Function<Float, Float> widthFunc, Consumer<Float> vfxOperator) {
        return this.renderTrail(stack.m_85850_().m_252922_(), trailSegments, widthFunc, vfxOperator);
    }

    public RenderBuilder renderTrail(Matrix4f pose, List<TrailPoint> trailSegments, Function<Float, Float> widthFunc, Consumer<Float> vfxOperator) {
        if (trailSegments.size() < 2) {
            return this;
        }
        List<Vector4f> positions = trailSegments.stream().map(TrailPoint::getMatrixPosition).peek(p -> p.mul((Matrix4fc)pose)).toList();
        int count = trailSegments.size() - 1;
        float increment = 1.0f / (float)count;
        TrailRenderPoint[] points = new TrailRenderPoint[trailSegments.size()];
        for (int i = 1; i < count; ++i) {
            float width = widthFunc.apply(Float.valueOf(increment * (float)i)).floatValue();
            Vector4f previous = positions.get(i - 1);
            Vector4f current = positions.get(i);
            Vector4f next = positions.get(i + 1);
            points[i] = new TrailRenderPoint(current, GuiUtil.perpendicularTrailPoints(previous, next, width));
        }
        points[0] = new TrailRenderPoint(positions.get(0), GuiUtil.perpendicularTrailPoints(positions.get(0), positions.get(1), widthFunc.apply(Float.valueOf(0.0f)).floatValue()));
        points[count] = new TrailRenderPoint(positions.get(count), GuiUtil.perpendicularTrailPoints(positions.get(count - 1), positions.get(count), widthFunc.apply(Float.valueOf(1.0f)).floatValue()));
        return this.renderPoints(points, this.u0, this.v0, this.u1, this.v1, vfxOperator);
    }

    public RenderBuilder renderTrail(List<TrailPoint> trailSegments, Function<Float, Float> widthFunc, Consumer<Float> vfxOperator) {
        if (trailSegments.size() < 2) {
            return this;
        }
        List<Vector4f> positions = trailSegments.stream().map(TrailPoint::getMatrixPosition).toList();
        int count = trailSegments.size() - 1;
        float increment = 1.0f / (float)count;
        TrailRenderPoint[] points = new TrailRenderPoint[trailSegments.size()];
        for (int i = 1; i < count; ++i) {
            float width = widthFunc.apply(Float.valueOf(increment * (float)i)).floatValue();
            Vector4f previous = positions.get(i - 1);
            Vector4f current = positions.get(i);
            Vector4f next = positions.get(i + 1);
            points[i] = new TrailRenderPoint(current, GuiUtil.perpendicularTrailPoints(previous, next, width));
        }
        points[0] = new TrailRenderPoint(positions.get(0), GuiUtil.perpendicularTrailPoints(positions.get(0), positions.get(1), widthFunc.apply(Float.valueOf(0.0f)).floatValue()));
        points[count] = new TrailRenderPoint(positions.get(count), GuiUtil.perpendicularTrailPoints(positions.get(count - 1), positions.get(count), widthFunc.apply(Float.valueOf(1.0f)).floatValue()));
        return this.renderPoints(points, this.u0, this.v0, this.u1, this.v1, vfxOperator);
    }

    public RenderBuilder renderPoints(TrailRenderPoint[] points, float u0, float v0, float u1, float v1, Consumer<Float> vfxOperator) {
        int count = points.length - 1;
        float increment = 1.0f / (float)count;
        vfxOperator.accept(Float.valueOf(0.0f));
        points[0].renderStart(this.getVertexConsumer(), this, u0, v0, u1, Mth.m_14179_((float)increment, (float)v0, (float)v1), this.r1, this.g1, this.b1, this.a1, this.l1);
        for (int i = 1; i < count; ++i) {
            float current = Mth.m_14179_((float)((float)i * increment), (float)v0, (float)v1);
            vfxOperator.accept(Float.valueOf(current));
            float r = Mth.m_14179_((float)((float)i * increment), (float)this.r1, (float)this.r2);
            float g = Mth.m_14179_((float)((float)i * increment), (float)this.g1, (float)this.g2);
            float b = Mth.m_14179_((float)((float)i * increment), (float)this.b1, (float)this.b2);
            float a = Mth.m_14179_((float)((float)i * increment), (float)this.a1, (float)this.a2);
            int l = (int)Mth.m_14179_((float)((float)i * increment), (float)this.l1, (float)this.l2);
            points[i].renderMid(this.getVertexConsumer(), this, u0, current, u1, current, r, g, b, a, l);
        }
        vfxOperator.accept(Float.valueOf(1.0f));
        points[count].renderEnd(this.getVertexConsumer(), this, u0, Mth.m_14179_((float)((float)count * increment), (float)v0, (float)v1), u1, v1, this.r2, this.g2, this.b2, this.a2, this.l2);
        return this;
    }

    public RenderBuilder renderDragon(PoseStack stack, float radius, float partialTicks, float randomF) {
        return this.renderDragon(stack, 0.0, 0.0, 0.0, radius, partialTicks, randomF);
    }

    public RenderBuilder renderDragon(PoseStack stack, double x, double y, double z, float radius, float partialTicks, float randomF) {
        float f5 = 0.5f;
        float f7 = Math.min(f5 > 0.8f ? (f5 - 0.8f) / 0.2f : 0.0f, 1.0f);
        Random random = new Random((long)(432.0f + randomF));
        stack.m_85836_();
        stack.m_85837_(x, y, z);
        float rotation = ((float)ClientTickHandler.ticksInGame + partialTicks) / 200.0f;
        int i = 0;
        while ((float)i < (f5 + f5 * f5) / 2.0f * 60.0f) {
            stack.m_252781_(Axis.f_252529_.m_252977_(random.nextFloat() * 360.0f));
            stack.m_252781_(Axis.f_252436_.m_252977_(random.nextFloat() * 360.0f));
            stack.m_252781_(Axis.f_252403_.m_252977_(random.nextFloat() * 360.0f));
            stack.m_252781_(Axis.f_252529_.m_252977_(random.nextFloat() * 360.0f));
            stack.m_252781_(Axis.f_252436_.m_252977_(random.nextFloat() * 360.0f));
            stack.m_252781_(Axis.f_252403_.m_252977_(random.nextFloat() * 360.0f + rotation * 90.0f));
            float f3 = random.nextFloat() * 20.0f + 5.0f + f7 * 10.0f;
            float f4 = random.nextFloat() * 2.0f + 1.0f + f7 * 2.0f;
            Matrix4f last = stack.m_85850_().m_252922_();
            float alpha = (1.0f - f7) * this.a1;
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, 0.0f, 0.0f, 0.0f, this.r1, this.g1, this.b1, alpha, 0.0f, 0.0f, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, 0.0f, 0.0f, 0.0f, this.r1, this.g1, this.b1, alpha, 0.0f, 0.0f, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, -ROOT_3 * (f4 *= 0.05f * radius), f3 *= 0.05f * radius, -0.5f * f4, this.r2, this.g2, this.b2, 0.0f, 0.0f, 0.0f, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, ROOT_3 * f4, f3, -0.5f * f4, this.r2, this.g2, this.b2, 0.0f, 0.0f, 0.0f, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, 0.0f, 0.0f, 0.0f, this.r1, this.g1, this.b1, alpha, 0.0f, 0.0f, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, 0.0f, 0.0f, 0.0f, this.r1, this.g1, this.b1, alpha, 0.0f, 0.0f, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, ROOT_3 * f4, f3, -0.5f * f4, this.r2, this.g2, this.b2, 0.0f, 0.0f, 0.0f, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, 0.0f, f3, f4, this.r2, this.g2, this.b2, 0.0f, 0.0f, 0.0f, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, 0.0f, 0.0f, 0.0f, this.r1, this.g1, this.b1, alpha, 0.0f, 0.0f, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, 0.0f, 0.0f, 0.0f, this.r1, this.g1, this.b1, alpha, 0.0f, 0.0f, this.l1);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, 0.0f, f3, f4, this.r2, this.g2, this.b2, 0.0f, 0.0f, 0.0f, this.l2);
            this.supplier.placeVertex(this.getVertexConsumer(), last, this, -ROOT_3 * f4, f3, -0.5f * f4, this.r2, this.g2, this.b2, 0.0f, 0.0f, 0.0f, this.l2);
            ++i;
        }
        stack.m_85849_();
        return this;
    }

    public RenderBuilder renderSphere(PoseStack stack, float radius, int longs, int lats, float endU, boolean stretch) {
        Matrix4f last = stack.m_85850_().m_252922_();
        float startU = 0.0f;
        float startV = 0.0f;
        float endV = (float)Math.PI;
        float stepU = (endU - startU) / (float)longs;
        float stepV = (endV - startV) / (float)lats;
        for (int i = 0; i < longs; ++i) {
            for (int j = 0; j < lats; ++j) {
                float u = (float)i * stepU + startU;
                float v = (float)j * stepV + startV;
                float un = i + 1 == longs ? endU : (float)(i + 1) * stepU + startU;
                float vn = j + 1 == lats ? endV : (float)(j + 1) * stepV + startV;
                Vector3f p0 = GuiUtil.parametricSphere(u, v, radius);
                Vector3f p1 = GuiUtil.parametricSphere(u, vn, radius);
                Vector3f p2 = GuiUtil.parametricSphere(un, v, radius);
                Vector3f p3 = GuiUtil.parametricSphere(un, vn, radius);
                float textureU = this.u0;
                float textureV = this.v0;
                float textureUN = this.u1;
                float textureVN = this.v1;
                if (stretch) {
                    textureU = this.u1 - u / endU * (this.u1 - this.u0);
                    textureV = this.v0 + v / endV * (this.v1 - this.v0);
                    textureUN = this.u1 - un / endU * (this.u1 - this.u0);
                    textureVN = this.v0 + vn / endV * (this.v1 - this.v0);
                }
                if (this.firstSide) {
                    this.supplier.placeVertex(this.getVertexConsumer(), last, this, p0.x(), p0.y(), p0.z(), this.r1, this.g1, this.b1, this.a1, textureU, textureV, this.l1);
                    this.supplier.placeVertex(this.getVertexConsumer(), last, this, p0.x(), p0.y(), p0.z(), this.r1, this.g1, this.b1, this.a1, textureU, textureV, this.l1);
                    this.supplier.placeVertex(this.getVertexConsumer(), last, this, p2.x(), p2.y(), p2.z(), this.r1, this.g1, this.b1, this.a1, textureUN, textureV, this.l1);
                    this.supplier.placeVertex(this.getVertexConsumer(), last, this, p1.x(), p1.y(), p1.z(), this.r1, this.g1, this.b1, this.a1, textureU, textureVN, this.l1);
                    this.supplier.placeVertex(this.getVertexConsumer(), last, this, p3.x(), p3.y(), p3.z(), this.r1, this.g1, this.b1, this.a1, textureUN, textureVN, this.l1);
                    this.supplier.placeVertex(this.getVertexConsumer(), last, this, p3.x(), p3.y(), p3.z(), this.r1, this.g1, this.b1, this.a1, textureUN, textureVN, this.l1);
                    this.supplier.placeVertex(this.getVertexConsumer(), last, this, p1.x(), p1.y(), p1.z(), this.r1, this.g1, this.b1, this.a1, textureU, textureVN, this.l1);
                    this.supplier.placeVertex(this.getVertexConsumer(), last, this, p2.x(), p2.y(), p2.z(), this.r1, this.g1, this.b1, this.a1, textureUN, textureV, this.l1);
                }
                if (!this.secondSide) continue;
                this.supplier.placeVertex(this.getVertexConsumer(), last, this, p1.x(), p1.y(), p1.z(), this.r1, this.g1, this.b1, this.a1, textureU, textureVN, this.l1);
                this.supplier.placeVertex(this.getVertexConsumer(), last, this, p1.x(), p1.y(), p1.z(), this.r1, this.g1, this.b1, this.a1, textureU, textureVN, this.l1);
                this.supplier.placeVertex(this.getVertexConsumer(), last, this, p3.x(), p3.y(), p3.z(), this.r1, this.g1, this.b1, this.a1, textureUN, textureVN, this.l1);
                this.supplier.placeVertex(this.getVertexConsumer(), last, this, p0.x(), p0.y(), p0.z(), this.r1, this.g1, this.b1, this.a1, textureU, textureV, this.l1);
                this.supplier.placeVertex(this.getVertexConsumer(), last, this, p2.x(), p2.y(), p2.z(), this.r1, this.g1, this.b1, this.a1, textureUN, textureV, this.l1);
                this.supplier.placeVertex(this.getVertexConsumer(), last, this, p2.x(), p2.y(), p2.z(), this.r1, this.g1, this.b1, this.a1, textureUN, textureV, this.l1);
                this.supplier.placeVertex(this.getVertexConsumer(), last, this, p0.x(), p0.y(), p0.z(), this.r1, this.g1, this.b1, this.a1, textureU, textureV, this.l1);
                this.supplier.placeVertex(this.getVertexConsumer(), last, this, p3.x(), p3.y(), p3.z(), this.r1, this.g1, this.b1, this.a1, textureUN, textureVN, this.l1);
            }
        }
        return this;
    }

    public RenderBuilder renderSphere(PoseStack stack, float radius, int longs, int lats, boolean stretch) {
        return this.renderSphere(stack, radius, longs, lats, (float)Math.PI * 2, stretch);
    }

    public RenderBuilder renderSemiSphere(PoseStack stack, float radius, int longs, int lats, boolean stretch) {
        return this.renderSphere(stack, radius, longs, lats, (float)Math.PI, stretch);
    }

    public RenderBuilder renderSphere(PoseStack stack, float radius, int longs, int lats) {
        return this.renderSphere(stack, radius, longs, lats, true);
    }

    public RenderBuilder renderSemiSphere(PoseStack stack, float radius, int longs, int lats) {
        return this.renderSemiSphere(stack, radius, longs, lats, true);
    }

    static {
        CONSUMER_INFO_MAP.put(DefaultVertexFormat.f_85804_, (consumer, last, builder, x, y, z, r, g, b, a, u, v, l) -> {
            if (last == null) {
                consumer.m_5483_((double)x, (double)y, (double)z);
            } else {
                consumer.m_252986_(last, x, y, z);
            }
        });
        CONSUMER_INFO_MAP.put(DefaultVertexFormat.f_85805_, (consumer, last, builder, x, y, z, r, g, b, a, u, v, l) -> consumer.m_85950_(r, g, b, a));
        CONSUMER_INFO_MAP.put(DefaultVertexFormat.f_85806_, (consumer, last, builder, x, y, z, r, g, b, a, u, v, l) -> consumer.m_7421_(u, v));
        CONSUMER_INFO_MAP.put(DefaultVertexFormat.f_85808_, (consumer, last, builder, x, y, z, r, g, b, a, u, v, l) -> consumer.m_85969_(l));
    }

    public static interface VertexConsumerActor {
        public void placeVertex(VertexConsumer var1, Matrix4f var2, RenderBuilder var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, int var13);
    }
}

