/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.fluffy_fur.client.screenshake;

import java.util.ArrayList;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import ru.blatfan.blatapi.fluffy_fur.FluffyFur;
import ru.blatfan.blatapi.fluffy_fur.client.event.ClientTickHandler;
import ru.blatfan.blatapi.fluffy_fur.client.screenshake.ScreenshakeInstance;
import ru.blatfan.blatapi.fluffy_fur.common.raycast.RayCast;
import ru.blatfan.blatapi.fluffy_fur.common.raycast.RayCastContext;
import ru.blatfan.blatapi.fluffy_fur.common.raycast.RayHitResult;
import ru.blatfan.blatapi.fluffy_fur.config.FluffyFurClientConfig;

public class ScreenshakeHandler {
    public static final ArrayList<ScreenshakeInstance> INSTANCES = new ArrayList();
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    public static float intensityRotation;
    public static float intensityPosition;
    public static float intensityFov;
    public static float intensityFovNormalize;
    public static Vec3 intensityVector;
    public static Vec3 intensityVectorOld;

    public static void cameraTick(Camera camera) {
        Vec3 posOffset;
        Vec3 pos;
        if (intensityRotation > 0.0f) {
            float yawOffset = ScreenshakeHandler.randomizeOffset(intensityRotation);
            float pitchOffset = ScreenshakeHandler.randomizeOffset(intensityRotation);
            camera.m_90572_(camera.m_90590_() + yawOffset, camera.m_90589_() + pitchOffset);
        }
        boolean cameraUpdate = false;
        Vec3 cameraPos = pos = camera.m_90583_();
        if (intensityPosition > 0.0f) {
            double angleA = RANDOM.m_188500_() * Math.PI * 2.0;
            double angleB = RANDOM.m_188500_() * Math.PI * 2.0;
            float x = (float)(Math.cos(angleA) * Math.cos(angleB)) * ScreenshakeHandler.randomizeOffset(intensityPosition);
            float y = (float)(Math.sin(angleA) * Math.cos(angleB)) * ScreenshakeHandler.randomizeOffset(intensityPosition);
            float z = (float)Math.sin(angleB) * ScreenshakeHandler.randomizeOffset(intensityPosition);
            posOffset = new Vec3(pos.m_7096_() + (double)x, pos.m_7098_() + (double)y, pos.m_7094_() + (double)z);
            pos = new Vec3(posOffset.m_7096_(), posOffset.m_7098_(), posOffset.m_7094_());
            cameraUpdate = true;
        }
        if (!intensityVector.equals((Object)Vec3.f_82478_) && !intensityVectorOld.equals((Object)Vec3.f_82478_)) {
            float partialTicks = ClientTickHandler.partialTicks;
            double lx = Mth.m_14139_((double)partialTicks, (double)intensityVectorOld.m_7096_(), (double)intensityVector.m_7096_());
            double ly = Mth.m_14139_((double)partialTicks, (double)intensityVectorOld.m_7098_(), (double)intensityVector.m_7098_());
            double lz = Mth.m_14139_((double)partialTicks, (double)intensityVectorOld.m_7094_(), (double)intensityVector.m_7094_());
            posOffset = new Vec3(pos.m_7096_() + lx, pos.m_7098_() + ly, pos.m_7094_() + lz);
            pos = new Vec3(posOffset.m_7096_(), posOffset.m_7098_(), posOffset.m_7094_());
            cameraUpdate = true;
        }
        if (cameraUpdate) {
            Level level = FluffyFur.proxy.getLevel();
            if (level != null) {
                RayHitResult hitResult = RayCast.getHit(level, new RayCastContext(cameraPos, pos).setBlockShape(RayCastContext.Block.VISUAL));
                double distance = Math.sqrt(Math.pow(cameraPos.m_7096_() - hitResult.getPos().m_7096_(), 2.0) + Math.pow(cameraPos.m_7098_() - hitResult.getPos().m_7098_(), 2.0) + Math.pow(cameraPos.m_7094_() - hitResult.getPos().m_7094_(), 2.0));
                if ((distance -= (double)0.1f) < 0.0) {
                    distance = 0.0;
                }
                double dX = cameraPos.m_7096_() - hitResult.getPos().m_7096_();
                double dY = cameraPos.m_7098_() - hitResult.getPos().m_7098_();
                double dZ = cameraPos.m_7094_() - hitResult.getPos().m_7094_();
                double yaw = Math.atan2(dZ, dX);
                double pitch = Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY) + Math.PI;
                double x = Math.sin(pitch) * Math.cos(yaw) * distance;
                double y = Math.cos(pitch) * distance;
                double z = Math.sin(pitch) * Math.sin(yaw) * distance;
                pos = new Vec3(cameraPos.m_7096_() + x, cameraPos.m_7098_() + y, cameraPos.m_7094_() + z);
            }
            camera.m_90584_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
        }
    }

    public static void fovTick(ComputeFovModifierEvent event) {
        float fovModifier = event.getFovModifier();
        if (fovModifier != event.getNewFovModifier()) {
            fovModifier = event.getNewFovModifier();
        }
        boolean update = false;
        if (intensityFov >= 0.0f) {
            float offset = ScreenshakeHandler.randomizeOffset(intensityFov);
            fovModifier += offset;
            update = true;
        }
        if (intensityFovNormalize != 0.0f) {
            fovModifier += intensityFovNormalize;
            update = true;
        }
        if (update) {
            event.setNewFovModifier((float)Mth.m_14139_((double)((Double)Minecraft.m_91087_().f_91066_.m_231925_().m_231551_()), (double)1.0, (double)fovModifier));
        }
    }

    public static void clientTick(Camera camera) {
        double intensity = (Double)FluffyFurClientConfig.SCREENSHAKE_INTENSITY.get();
        double rotationNormalize = 0.0;
        double positionNormalize = 0.0;
        double fovNormalize = 0.0;
        double fovNorm = 0.0;
        double rotation = 0.0;
        double position = 0.0;
        double fov = 0.0;
        Vec3 vector = Vec3.f_82478_;
        for (ScreenshakeInstance instance : INSTANCES) {
            double update = instance.updateIntensity(camera);
            if (instance.isRotation) {
                if (instance.isNormalize) {
                    rotationNormalize += update;
                } else if (rotation < update) {
                    rotation = update;
                }
            }
            if (instance.isPosition) {
                if (instance.isNormalize) {
                    positionNormalize += update;
                } else if (position < update) {
                    position = update;
                }
            }
            if (instance.isFov) {
                if (instance.isNormalize) {
                    if (instance.isFovNormalize) {
                        if (fovNormalize < update) {
                            fovNormalize += update;
                        }
                    } else {
                        fovNormalize += update;
                    }
                } else if (instance.isFovNormalize) {
                    fovNorm += update;
                } else {
                    fov += update;
                }
            }
            if (!instance.isVector) continue;
            if (instance.isNormalize) {
                Vec3 newVec = instance.vector.m_82490_(update * intensity);
                double dX = newVec.m_7096_() - vector.m_7096_();
                double dY = newVec.m_7098_() - vector.m_7098_();
                double dZ = newVec.m_7094_() - vector.m_7094_();
                vector = new Vec3(dX, dY, dZ);
                continue;
            }
            vector = vector.m_82549_(instance.vector.m_82490_(update * intensity));
        }
        rotationNormalize = Math.min(rotationNormalize, intensity);
        positionNormalize = Math.min(positionNormalize, intensity);
        fovNorm = Math.min(fovNorm, intensity);
        intensityRotation = (float)Math.max(Math.pow(rotationNormalize, 3.0), rotation *= intensity);
        intensityPosition = (float)Math.max(Math.pow(positionNormalize / 2.0, 3.0), position *= intensity);
        intensityFov = (float)Math.max(fovNorm, fov *= intensity);
        intensityFovNormalize = (float)fovNormalize;
        intensityVectorOld = intensityVector;
        intensityVector = vector;
        INSTANCES.removeIf(i -> i.progress >= i.duration);
    }

    public static void addScreenshake(ScreenshakeInstance instance) {
        INSTANCES.add(instance);
    }

    public static float randomizeOffset(float offset) {
        return Mth.m_216267_((RandomSource)RANDOM, (float)(-offset * 2.0f), (float)(offset * 2.0f));
    }

    static {
        intensityVector = Vec3.f_82478_;
        intensityVectorOld = Vec3.f_82478_;
    }
}

