/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.fluffy_fur.client.shader.postprocess;

import com.google.common.collect.Lists;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import ru.blatfan.blatapi.fluffy_fur.FluffyFur;
import ru.blatfan.blatapi.fluffy_fur.client.event.ClientTickHandler;

public abstract class PostProcess {
    public static final Minecraft minecraft = Minecraft.m_91087_();
    public static final Collection<Pair<String, Consumer<Uniform>>> COMMON_UNIFORMS = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"cameraPos", u -> u.m_142276_(new Vector3f((Vector3fc)PostProcess.minecraft.f_91063_.m_109153_().m_90583_().m_252839_()))), Pair.of((Object)"lookVector", u -> u.m_142276_(PostProcess.minecraft.f_91063_.m_109153_().m_253058_())), Pair.of((Object)"upVector", u -> u.m_142276_(PostProcess.minecraft.f_91063_.m_109153_().m_253028_())), Pair.of((Object)"leftVector", u -> u.m_142276_(PostProcess.minecraft.f_91063_.m_109153_().m_252775_())), Pair.of((Object)"invViewMat", u -> {
        Matrix4f invertedViewMatrix = new Matrix4f((Matrix4fc)viewModelStack.m_85850_().m_252922_());
        invertedViewMatrix.invert();
        u.m_5679_(invertedViewMatrix);
    }), Pair.of((Object)"invProjMat", u -> {
        Matrix4f invertedProjectionMatrix = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
        invertedProjectionMatrix.invert();
        u.m_5679_(invertedProjectionMatrix);
    }), Pair.of((Object)"nearPlaneDistance", u -> u.m_5985_(0.05f)), Pair.of((Object)"farPlaneDistance", u -> u.m_5985_(PostProcess.minecraft.f_91063_.m_172790_())), Pair.of((Object)"fov", u -> u.m_5985_((float)Math.toRadians(PostProcess.minecraft.f_91063_.m_109141_(PostProcess.minecraft.f_91063_.m_109153_(), minecraft.m_91296_(), true)))), Pair.of((Object)"aspectRatio", u -> u.m_5985_((float)minecraft.m_91268_().m_85441_() / (float)minecraft.m_91268_().m_85442_()))});
    public static PoseStack viewModelStack;
    public PostChain postChain;
    public boolean effectActive;
    public RenderTarget tempDepthBuffer;
    public EffectInstance[] effects;
    public Collection<Pair<Uniform, Consumer<Uniform>>> defaultUniforms;
    public boolean initialized = false;
    public boolean isActive = true;
    public double time;

    public void init() {
        this.loadPostChain();
        if (this.postChain != null) {
            this.tempDepthBuffer = this.postChain.m_110036_("depthMain");
            this.defaultUniforms = new ArrayList<Pair<Uniform, Consumer<Uniform>>>();
            for (EffectInstance e : this.effects) {
                for (Pair<String, Consumer<Uniform>> pair : COMMON_UNIFORMS) {
                    Uniform u = e.m_108952_((String)pair.getFirst());
                    if (u == null) continue;
                    this.defaultUniforms.add((Pair<Uniform, Consumer<Uniform>>)Pair.of((Object)u, (Object)((Consumer)pair.getSecond())));
                }
            }
        }
        this.initialized = true;
    }

    public void tick() {
    }

    public void loadPostChain() {
        if (this.postChain != null) {
            this.postChain.close();
            this.postChain = null;
        }
        try {
            ResourceLocation resourceLocation = this.getPostChainLocation();
            this.postChain = new PostChain(minecraft.m_91097_(), minecraft.m_91098_(), minecraft.m_91385_(), resourceLocation);
            this.postChain.m_110025_(minecraft.m_91268_().m_85441_(), minecraft.m_91268_().m_85442_());
            this.effects = (EffectInstance[])this.postChain.f_110009_.stream().map(PostPass::m_110074_).toArray(EffectInstance[]::new);
            this.effectActive = true;
        }
        catch (JsonSyntaxException | IOException ioexception) {
            FluffyFur.LOGGER.error("Failed to load post-processing shader: ", ioexception);
            this.effectActive = false;
        }
    }

    public void copyDepthBuffer() {
        if (this.isActive) {
            if (this.postChain == null || this.tempDepthBuffer == null) {
                return;
            }
            this.tempDepthBuffer.m_83945_(minecraft.m_91385_());
            GlStateManager._glBindFramebuffer((int)36009, (int)PostProcess.minecraft.m_91385_().f_83920_);
        }
    }

    public void resize(int width, int height) {
        if (this.postChain != null) {
            this.postChain.m_110025_(width, height);
            if (this.tempDepthBuffer != null) {
                this.tempDepthBuffer.m_83941_(width, height, Minecraft.f_91002_);
            }
        }
    }

    public void applyDefaultUniforms() {
        Arrays.stream(this.effects).forEach(e -> e.m_108960_("totalTicks").m_5985_(ClientTickHandler.getTotal()));
        Arrays.stream(this.effects).forEach(e -> e.m_108960_("partialTicks").m_5985_(ClientTickHandler.partialTicks));
        Arrays.stream(this.effects).forEach(e -> e.m_108960_("gameTicks").m_142617_(ClientTickHandler.ticksInGame));
        Arrays.stream(this.effects).forEach(e -> e.m_108960_("time").m_5985_((float)this.time));
        this.defaultUniforms.forEach(pair -> ((Consumer)pair.getSecond()).accept((Uniform)pair.getFirst()));
    }

    public void applyPostProcess() {
        if (this.isActive) {
            if (!this.initialized) {
                this.init();
            }
            if (this.postChain != null) {
                this.time += (double)minecraft.m_91297_() / 20.0;
                this.applyDefaultUniforms();
                this.beforeProcess(viewModelStack);
                if (!this.isActive) {
                    return;
                }
                this.postChain.m_110023_(minecraft.m_91296_());
                GlStateManager._glBindFramebuffer((int)36009, (int)PostProcess.minecraft.m_91385_().f_83920_);
                this.afterProcess();
            }
        }
    }

    public abstract ResourceLocation getPostChainLocation();

    public abstract void beforeProcess(PoseStack var1);

    public abstract void afterProcess();

    public void setActive(boolean active) {
        this.isActive = active;
        if (!active) {
            this.time = 0.0;
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isScreen() {
        return false;
    }

    public boolean isWindow() {
        return false;
    }

    public float getPriority() {
        return 0.0f;
    }
}

