/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.fluffy_fur.common.creativetab;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import ru.blatfan.blatapi.fluffy_fur.common.creativetab.MultiCreativeTabBuilder;
import ru.blatfan.blatapi.fluffy_fur.common.creativetab.SubCreativeTab;

public class MultiCreativeTab
extends CreativeModeTab {
    public ResourceLocation multiBackgroundLocation;
    public ResourceLocation subArrowsImage = MultiCreativeTabBuilder.STANDARD_SUB_ARROWS;
    public ArrayList<SubCreativeTab> subCreativeTabs = new ArrayList();
    public ArrayList<SubCreativeTab> sortedSubCreativeTabs = new ArrayList();
    public SubCreativeTab currentSubTab;
    public int scroll = 0;

    protected MultiCreativeTab(CreativeModeTab.Builder builder) {
        super(builder);
    }

    public MultiCreativeTab(MultiCreativeTabBuilder builder) {
        super((CreativeModeTab.Builder)builder);
    }

    public static MultiCreativeTabBuilder builder() {
        return new MultiCreativeTabBuilder(CreativeModeTab.Row.TOP, 0);
    }

    public Component m_40786_() {
        if (this.getCurrentSubTab() != null && this.getCurrentSubTab().getDisplayName() != null) {
            return this.getCurrentSubTab().getDisplayName();
        }
        return super.m_40786_();
    }

    public ItemStack m_40787_() {
        if (this.getCurrentSubTab() != null && this.getCurrentSubTab().getIconItem() != null) {
            return this.getCurrentSubTab().getIconItem();
        }
        return super.m_40787_();
    }

    public boolean m_40789_() {
        if (this.getCurrentSubTab() != null && this.getCurrentSubTab().hasShowTitle()) {
            return this.getCurrentSubTab().showTitle();
        }
        return super.m_40789_();
    }

    public boolean m_40791_() {
        if (this.getCurrentSubTab() != null && this.getCurrentSubTab().hasCanScroll()) {
            return this.getCurrentSubTab().canScroll();
        }
        return super.m_40791_();
    }

    public Collection<ItemStack> m_260957_() {
        if (this.getCurrentSubTab() != null && this.getCurrentSubTab().getDisplayItems() != null) {
            return this.getCurrentSubTab().getDisplayItems();
        }
        return super.m_260957_();
    }

    public Collection<ItemStack> m_261235_() {
        if (this.getCurrentSubTab() != null && this.getCurrentSubTab().getSearchTabDisplayItems() != null) {
            return this.getCurrentSubTab().getSearchTabDisplayItems();
        }
        return super.m_261235_();
    }

    public boolean m_257694_(ItemStack stack) {
        return this.m_261235_().contains(stack);
    }

    public ResourceLocation getBackgroundLocation() {
        if (this.getCurrentSubTab() != null && this.getCurrentSubTab().getBackgroundLocation() != null) {
            return this.getCurrentSubTab().getBackgroundLocation();
        }
        return this.multiBackgroundLocation;
    }

    public boolean hasSearchBar() {
        if (this.getCurrentSubTab() != null && this.getCurrentSubTab().hasSearch()) {
            return this.getCurrentSubTab().hasSearchBar();
        }
        return super.hasSearchBar();
    }

    public int getSearchBarWidth() {
        if (this.getCurrentSubTab() != null && this.getCurrentSubTab().hasSearchBarWidth()) {
            return this.getCurrentSubTab().getSearchBarWidth();
        }
        return super.getSearchBarWidth();
    }

    public ResourceLocation getTabsImage() {
        if (this.getCurrentSubTab() != null && this.getCurrentSubTab().getTabsImage() != null) {
            return this.getCurrentSubTab().getTabsImage();
        }
        return super.getTabsImage();
    }

    public int getLabelColor() {
        if (this.getCurrentSubTab() != null && this.getCurrentSubTab().hasLabelColor()) {
            return this.getCurrentSubTab().getLabelColor();
        }
        return super.getLabelColor();
    }

    public int getSlotColor() {
        if (this.getCurrentSubTab() != null && this.getCurrentSubTab().hasSlotColor()) {
            return this.getCurrentSubTab().getSlotColor();
        }
        return super.getSlotColor();
    }

    public MultiCreativeTab withSubArrowsImage(ResourceLocation image) {
        this.subArrowsImage = image;
        return this;
    }

    public MultiCreativeTab addSubTab(SubCreativeTab subTab) {
        this.subCreativeTabs.add(subTab);
        if (this.getCurrentSubTab() == null) {
            this.setCurrentSubTab(subTab);
        }
        return this;
    }

    public MultiCreativeTab sortSubTabs() {
        this.sortedSubCreativeTabs.clear();
        for (SubCreativeTab subTab : this.getSubTabs()) {
            if (!subTab.getSubShow()) continue;
            this.sortedSubCreativeTabs.add(subTab);
        }
        if (this.scroll < 0) {
            this.scroll = 0;
        } else if (this.scroll > this.getSortedSubTabs().size() - 6 && this.getSortedSubTabs().size() > 6) {
            this.scroll = this.getSortedSubTabs().size() - 6;
        }
        if (this.getSortedSubTabs().size() > 0 && !this.getSortedSubTabs().contains(this.getCurrentSubTab())) {
            this.setCurrentSubTab(this.getSortedSubTabs().get(0));
        }
        return this;
    }

    public MultiCreativeTab setCurrentSubTab(SubCreativeTab subTab) {
        this.currentSubTab = subTab;
        return this;
    }

    public ArrayList<SubCreativeTab> getSubTabs() {
        return this.subCreativeTabs;
    }

    public ArrayList<SubCreativeTab> getSortedSubTabs() {
        return this.sortedSubCreativeTabs;
    }

    public ResourceLocation getSubArrowsImage() {
        return this.subArrowsImage;
    }

    public SubCreativeTab getCurrentSubTab() {
        return this.currentSubTab;
    }
}

