/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.fluffy_fur.common.creativetab;

import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.level.ItemLike;
import ru.blatfan.blatapi.BlatApi;

public class SubCreativeTab {
    public Component displayName;
    public Supplier<ItemStack> iconItemStack = () -> null;
    public boolean showTitle = true;
    public boolean canScroll = true;
    public Collection<ItemStack> displayItems = ItemStackLinkedSet.m_261170_();
    public Set<ItemStack> displayItemsSearchTab = ItemStackLinkedSet.m_261170_();
    public ResourceLocation backgroundLocation;
    public boolean hasSearchBar = false;
    public int searchBarWidth = 89;
    public ResourceLocation tabsImage;
    public int labelColor = 0x404040;
    public int slotColor = -2130706433;
    public boolean hasShowTitle = false;
    public boolean hasCanScroll = false;
    public boolean hasSearch = false;
    public boolean hasSearchBarWidth = false;
    public boolean hasLabelColor = false;
    public boolean hasSlotColor = false;
    public Component subDisplayName;
    public Supplier<ItemStack> subIconItemStack = () -> null;
    public ResourceLocation subTabImage = BlatApi.loc("textures/gui/sub_tab.png");
    public Supplier<Boolean> subShow = () -> true;

    public static SubCreativeTab create() {
        return new SubCreativeTab();
    }

    public SubCreativeTab title(Component title) {
        this.displayName = title;
        return this;
    }

    public SubCreativeTab icon(Supplier<ItemStack> icon) {
        this.iconItemStack = icon;
        return this;
    }

    public SubCreativeTab hideTitle() {
        this.hasShowTitle = true;
        this.showTitle = false;
        return this;
    }

    public SubCreativeTab noScrollBar() {
        this.hasCanScroll = true;
        this.canScroll = false;
        return this;
    }

    public SubCreativeTab withTitle() {
        this.hasShowTitle = true;
        this.showTitle = true;
        return this;
    }

    public SubCreativeTab witScrollBar() {
        this.hasCanScroll = true;
        this.canScroll = true;
        return this;
    }

    public SubCreativeTab withBackgroundLocation(ResourceLocation background) {
        this.backgroundLocation = background;
        return this;
    }

    public SubCreativeTab hideSearchBar() {
        this.hasSearch = true;
        this.hasSearchBar = false;
        return this;
    }

    public SubCreativeTab withSearchBar() {
        this.hasSearch = true;
        this.hasSearchBar = true;
        return this;
    }

    public SubCreativeTab withSearchBar(int searchBarWidth) {
        this.hasSearchBarWidth = true;
        this.searchBarWidth = searchBarWidth;
        return this.withSearchBar();
    }

    public SubCreativeTab withSearchBarWidth(int searchBarWidth) {
        this.hasSearchBarWidth = true;
        this.searchBarWidth = searchBarWidth;
        return this;
    }

    public SubCreativeTab withTabsImage(ResourceLocation tabsImage) {
        this.tabsImage = tabsImage;
        return this;
    }

    public SubCreativeTab withLabelColor(int labelColor) {
        this.hasLabelColor = true;
        this.labelColor = labelColor;
        return this;
    }

    public SubCreativeTab withSlotColor(int slotColor) {
        this.hasSlotColor = true;
        this.slotColor = slotColor;
        return this;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public ItemStack getIconItem() {
        return this.iconItemStack.get();
    }

    public boolean showTitle() {
        return this.showTitle;
    }

    public boolean canScroll() {
        return this.canScroll;
    }

    public Collection<ItemStack> getDisplayItems() {
        return this.displayItems;
    }

    public Collection<ItemStack> getSearchTabDisplayItems() {
        return this.displayItemsSearchTab;
    }

    public boolean contains(ItemStack stack) {
        return this.getSearchTabDisplayItems().contains(stack);
    }

    public ResourceLocation getBackgroundLocation() {
        return this.backgroundLocation;
    }

    public boolean hasSearchBar() {
        return this.hasSearchBar;
    }

    public int getSearchBarWidth() {
        return this.searchBarWidth;
    }

    public ResourceLocation getTabsImage() {
        return this.tabsImage;
    }

    public int getLabelColor() {
        return this.labelColor;
    }

    public int getSlotColor() {
        return this.slotColor;
    }

    public boolean hasShowTitle() {
        return this.hasShowTitle;
    }

    public boolean hasCanScroll() {
        return this.hasCanScroll;
    }

    public boolean hasSearch() {
        return this.hasSearch;
    }

    public boolean hasSearchBarWidth() {
        return this.hasSearchBarWidth;
    }

    public boolean hasLabelColor() {
        return this.hasLabelColor;
    }

    public boolean hasSlotColor() {
        return this.hasSlotColor;
    }

    public SubCreativeTab subTitle(Component title) {
        this.subDisplayName = title;
        return this;
    }

    public SubCreativeTab subIcon(Supplier<ItemStack> icon) {
        this.subIconItemStack = icon;
        return this;
    }

    public SubCreativeTab withSubTabImage(ResourceLocation image) {
        this.subTabImage = image;
        return this;
    }

    public SubCreativeTab setSubShow(Supplier<Boolean> subShow) {
        this.subShow = subShow;
        return this;
    }

    public Component getSubDisplayName() {
        if (this.subDisplayName != null) {
            return this.subDisplayName;
        }
        if (this.getDisplayName() != null) {
            return this.getDisplayName();
        }
        return null;
    }

    public ItemStack getSubIconItem() {
        if (this.subIconItemStack.get() != null) {
            return this.subIconItemStack.get();
        }
        if (this.getIconItem() != null) {
            return this.getIconItem();
        }
        return null;
    }

    public ResourceLocation getSubTabImage() {
        if (this.subTabImage != null) {
            return this.subTabImage;
        }
        return null;
    }

    public boolean getSubShow() {
        return this.subShow.get();
    }

    public SubCreativeTab addItem(ItemStack item) {
        this.addDisplayItem(item);
        this.addDisplaySearchItem(item);
        return this;
    }

    public SubCreativeTab addItem(ItemLike item) {
        this.addDisplayItem(item);
        this.addDisplaySearchItem(item);
        return this;
    }

    public SubCreativeTab addItems(Collection<ItemStack> items) {
        this.addDisplayItems(items);
        this.addDisplaySearchItems(items);
        return this;
    }

    public SubCreativeTab addDisplayItem(ItemStack item) {
        this.displayItems.add(item);
        return this;
    }

    public SubCreativeTab addDisplayItem(ItemLike item) {
        this.displayItems.add(new ItemStack(item));
        return this;
    }

    public SubCreativeTab addDisplayItems(Collection<ItemStack> items) {
        this.displayItems.addAll(items);
        return this;
    }

    public SubCreativeTab addDisplaySearchItem(ItemStack item) {
        this.displayItemsSearchTab.add(item);
        return this;
    }

    public SubCreativeTab addDisplaySearchItem(ItemLike item) {
        this.displayItemsSearchTab.add(new ItemStack(item));
        return this;
    }

    public SubCreativeTab addDisplaySearchItems(Collection<ItemStack> items) {
        this.displayItemsSearchTab.addAll(items);
        return this;
    }

    public void clearItems() {
        this.displayItems.clear();
        this.displayItemsSearchTab.clear();
    }
}

