/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.fluffy_fur.common.itemskin;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ru.blatfan.blatapi.fluffy_fur.client.model.armor.ArmorModel;
import ru.blatfan.blatapi.fluffy_fur.common.itemskin.ItemSkinEntry;
import ru.blatfan.blatapi.fluffy_fur.common.itemskin.ItemSkinHandler;
import ru.blatfan.blatapi.fluffy_fur.registry.client.FluffyFurModels;
import ru.blatfan.blatapi.utils.ColorHelper;

public class ItemSkin {
    public String id;
    public Color color;
    public List<ItemSkinEntry> skinEntries = new ArrayList<ItemSkinEntry>();

    public ItemSkin(String id) {
        this.id = id;
        this.color = Color.WHITE;
    }

    public ItemSkin(String id, Color color) {
        this.id = id;
        this.color = color;
    }

    public String getTranslatedName() {
        return ItemSkin.getTranslatedName(this.id);
    }

    public String getTranslatedLoreName() {
        return ItemSkin.getTranslatedLoreName(this.id);
    }

    public static String getTranslatedName(String id) {
        int i = id.indexOf(":");
        String modId = id.substring(0, i);
        String monogramId = id.substring(i + 1);
        return "item_skin." + modId + "." + monogramId;
    }

    public static String getTranslatedLoreName(String id) {
        return ItemSkin.getTranslatedName(id) + ".lore";
    }

    public static Component getSkinName(ItemSkin skin) {
        Color color = skin.getColor();
        return Component.m_237115_((String)skin.getTranslatedName()).m_130948_(Style.f_131099_.m_178520_(ColorHelper.getColor(color.getRed(), color.getGreen(), color.getBlue())));
    }

    public static Component getSkinComponent(ItemSkin skin) {
        return Component.m_237115_((String)"lore.fluffy_fur.skin").m_130948_(Style.f_131099_.m_178520_(ColorHelper.getColor(249, 210, 129))).m_130946_(" ").m_7220_(ItemSkin.getSkinName(skin));
    }

    public Component getSkinName() {
        return ItemSkin.getSkinName(this);
    }

    public Component getSkinComponent() {
        return ItemSkin.getSkinComponent(this);
    }

    public boolean canApplyOnItem(ItemStack itemStack) {
        for (ItemSkinEntry skinEntry : this.getSkinEntries()) {
            if (!skinEntry.canApplyOnItem(itemStack)) continue;
            return true;
        }
        return false;
    }

    public ItemStack applyOnItem(ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41784_();
        nbt.m_128359_("skin", this.getId());
        return itemStack;
    }

    public static ItemSkin getSkinFromItem(ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41784_();
        if (nbt.m_128441_("skin")) {
            return ItemSkinHandler.getSkin(nbt.m_128461_("skin"));
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ArmorModel getArmorModel(LivingEntity entity, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel _default) {
        for (ItemSkinEntry skinEntry : this.getSkinEntries()) {
            if (!skinEntry.canApplyOnItem(itemStack)) continue;
            return skinEntry.getArmorModel(entity, itemStack, armorSlot, _default);
        }
        return FluffyFurModels.EMPTY_ARMOR;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        for (ItemSkinEntry skinEntry : this.getSkinEntries()) {
            if (!skinEntry.canApplyOnItem(stack)) continue;
            return skinEntry.getArmorTexture(stack, entity, slot, type);
        }
        return "blatapi:textures/models/armor/skin/empty.png";
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getItemModelName(ItemStack stack) {
        for (ItemSkinEntry skinEntry : this.getSkinEntries()) {
            if (!skinEntry.canApplyOnItem(stack)) continue;
            return skinEntry.getItemModelName(stack);
        }
        return null;
    }

    public void addSkinEntry(ItemSkinEntry skinEntry) {
        this.skinEntries.add(skinEntry);
    }

    public void setupSkinEntries() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isDefaultModel(Entity entity) {
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            return player.m_108564_().equals("default");
        }
        return true;
    }

    public String getId() {
        return this.id;
    }

    public Color getColor() {
        return this.color;
    }

    public List<ItemSkinEntry> getSkinEntries() {
        return this.skinEntries;
    }
}

